/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.ProfilesSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.ProfilesSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.SVSDSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.SVSDSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.VDisksSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.VDisksSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddStoragePage3View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddStoragePage4View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddStorageTraysModel;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddStorageTraysView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.CreatePoolPage1View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.CreatePoolPage3View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.CreatePoolWizardData;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.NewStorageFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.RaidSetGroup;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;

public class CreatePoolImpl
extends SEWizardImpl {
    public static final String MODELNAME = "CreatePoolWizard_ModelName";
    public static final String IMPLNAME = "CreatePoolWizard_ImplName";
    private static final String SUCCESS_SUMMARY = "se6x20ui.wizards.pool.CreatePool.success";
    private static final String ADDSTORAGE_SUCCESS_SUMMARY = "se6x20ui.wizards.pool.CreatePool.success.addstorage";
    private static final String FAILURE_SUMMARY = "se6x20ui.error.wizards.pool.CreatePool.failed";
    private static final String PARTIAL_SUMMARY = "se6920ui.error.wizards.pool.CreatePool.partial";
    static final String CONFIG_TYPE = "CreatePool_ConfigType";
    static final int CONFIG_NONE = 0;
    static final int CONFIG_TRAYS = 1;
    static final int CONFIG_VDISKS = 2;
    static final int CONFIG_AUTO = 3;
    static final String PROGRESS_PAGE = "1";
    static final String DOMAIN_PAGE = "2";
    static final String PROFILE_PAGE = "4";
    static final String ADDSTORAGE_PAGE = "5";
    static final String CONFIG_PAGE = "6";
    static final String SELECT_SIZE_PAGE = "7";
    static final String TRAYS_PAGE = "8";
    static final String VDISKS_PAGE = "9";
    static final String SUMMARY_PAGE = "10";
    private boolean boolAddStorage = false;
    private boolean isNumDisksVariable = false;
    private int configType = 0;
    private ArrayList wwnList = null;
    private ArrayList pbdList = null;
    private int numDisks = 0;
    private boolean storageAvailableForProfile = false;
    private NewStorageFilter storageFilter;
    private StorageProfileInterface profileHandle;
    private List t4List;

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.pool.CreatePool.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.CreatePoolImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new CreatePoolImpl(requestContext);
    }

    public CreatePoolImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public String getNextPageId(String pageId) {
        int page = this.pageIdToPage(pageId);
        String nextPageId = Integer.toString(this.nextPages[page][0]);
        if (pageId.equals(PROFILE_PAGE)) {
            List unUsedDisks = this.getUnUsedVDisksInDomain();
            if (!(this.storageAvailableForProfile || unUsedDisks != null && unUsedDisks.size() != 0)) {
                this.configType = 0;
                this.wizardModel.setValue(CONFIG_TYPE, (Object)Integer.toString(this.configType));
                nextPageId = Integer.toString(this.nextPages[page + 5][0]);
            }
        } else if (pageId.equals(ADDSTORAGE_PAGE)) {
            Trace.verbose((Object)((Object)this), (String)"getNextPageId", (String)("AddStorage selected is : " + this.boolAddStorage));
            nextPageId = this.boolAddStorage ? Integer.toString(this.nextPages[page][0]) : Integer.toString(this.nextPages[page + 4][0]);
        } else if (pageId.equals(CONFIG_PAGE)) {
            Trace.verbose((Object)((Object)this), (String)"getNextPageId", (String)("ConfigType Selected is : " + this.configType));
            nextPageId = this.configType == 1 ? Integer.toString(this.nextPages[page + 1][0]) : (this.configType == 2 ? Integer.toString(this.nextPages[page + 2][0]) : Integer.toString(this.nextPages[page][0]));
        } else if (pageId.equals(SELECT_SIZE_PAGE)) {
            nextPageId = Integer.toString(this.nextPages[page + 2][0]);
        } else if (pageId.equals(TRAYS_PAGE)) {
            nextPageId = Integer.toString(this.nextPages[page + 1][0]);
        }
        return nextPageId;
    }

    public List getUnUsedVDisksInDomain() {
        String METHOD_NAME = "getUnUsedVDisksInDomain";
        Trace.methodBegin((Object)((Object)this), (String)"getUnassignedVDisks");
        StorageProfileInterface profile = (StorageProfileInterface)this.wizardModel.getValue("WIZARD_PROFILE_HANDLE");
        if (profile == null) {
            Trace.error((Object)((Object)this), (String)"getUnUsedVDisksInDomain", (String)"Profile is null");
            return null;
        }
        String profileName = profile.getName();
        String domainName = (String)this.wizardModel.getValue("WIZARD_DOMAIN_NAME");
        if (domainName == null) {
            Trace.error((Object)((Object)this), (String)"getUnUsedVDisksInDomain", (String)"Domain name is null");
            return null;
        }
        ConfigContext context = UIUtil.getConfigContext();
        ManageStoragePoolsInterface poolsMgr = ManageStoragePoolsFactory.getManager();
        List unUsedDisks = null;
        try {
            poolsMgr.init(context, null);
            unUsedDisks = poolsMgr.findVDisksForStealing(false, profileName, domainName);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"getUnUsedVDisksInDomain", (String)"Exception in pool manager");
        }
        return unUsedDisks;
    }

    public String[] getFutureSteps(String currentPageId) {
        return new String[0];
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        if (wizardEvent.getPageId().equals(PROFILE_PAGE)) {
            this.processProfilesPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(PROGRESS_PAGE)) {
            this.processProgressPage();
        } else if (wizardEvent.getPageId().equals(DOMAIN_PAGE)) {
            this.processDomainsPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(ADDSTORAGE_PAGE)) {
            this.processAddStoragePage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(SELECT_SIZE_PAGE)) {
            this.processAvailableCapacityPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(CONFIG_PAGE)) {
            this.processConfigPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(TRAYS_PAGE)) {
            this.processTraysPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(VDISKS_PAGE)) {
            this.processVDisksPage(wizardEvent);
        }
        return true;
    }

    public boolean gotoStep(WizardEvent wizardEvent) {
        return !wizardEvent.getGotoPageId().equals(PROGRESS_PAGE);
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"finishStep");
        String name = (String)this.wizardModel.getValue("PoolNameField");
        String description = (String)this.wizardModel.getValue("PoolDescField");
        String profile = (String)this.wizardModel.getValue("ProfileNameField");
        String domain = (String)this.wizardModel.getValue("DomainField");
        Trace.verbose((Object)((Object)this), (String)"finshStep", (String)(" Pool name: " + name));
        if (name.trim().length() <= 0) {
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation();
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Storage pool name is empty");
            return true;
        }
        ConfigContext context = UIUtil.getConfigContext();
        if (context == null) {
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation();
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Configcontext is empty");
            return true;
        }
        ManageStoragePoolsInterface poolsMgr = ManageStoragePoolsFactory.getManager();
        try {
            poolsMgr.init(context, null);
        }
        catch (ConfigMgmtException cme) {
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation();
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Error initializing the storage pool manager.");
            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
            return true;
        }
        Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Calling createStoragePool with name=" + name + " description=" + description + " profile=" + profile + " domain=" + domain));
        MethodCallStatus mcs = null;
        try {
            mcs = poolsMgr.createStoragePool(name, description, profile, domain);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
            this.transaction.addFailedOperation(name, (Exception)((Object)cme));
            this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
            return true;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)((Object)this), (String)"finishStep", (Throwable)infe);
            this.transaction.addFailedOperation(name, (Exception)((Object)infe));
            this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
            return true;
        }
        if (!UIUtil.isMCSSuccess((MethodCallStatus)mcs)) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Error creating the storage pool.");
            Trace.error((Object)((Object)this), (String)"finishStep", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
            this.transaction.addFailedOperation(name, "error.cim." + mcs.getReturnCode());
            this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
            return true;
        }
        this.transaction.addSuccessfulOperation(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.pool.CreatePool.specificsuccess", (String)name));
        if (!this.boolAddStorage) {
            this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
            return true;
        }
        StoragePoolInterface pool = null;
        try {
            pool = poolsMgr.getItemByName(name, domain);
        }
        catch (ConfigMgmtException cme) {
            this.transaction.addFailedOperation(name, (Exception)((Object)cme));
            this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
            Trace.error((Object)((Object)this), (String)"finishStep", (String)("Cannot get the reference to StoragePool with name: " + name + ", to add storage to it"));
            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
            return true;
        }
        catch (ItemNotFoundException infe) {
            this.transaction.addFailedOperation(name, (Exception)((Object)infe));
            this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
            Trace.error((Object)((Object)this), (String)"finishStep", (String)("Cannot get the reference to StoragePool with name: " + name + ", to add storage to it"));
            Trace.error((Object)((Object)this), (String)"finishStep", (Throwable)infe);
            return true;
        }
        switch (this.configType) {
            case 1: {
                this.addTrays(pool);
                break;
            }
            case 2: {
                this.addVDisks(pool);
                this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
                break;
            }
            case 3: {
                this.addAutomaticSize(pool);
                break;
            }
            default: {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Config Type is None of the three types.. so quitting");
            }
        }
        Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Removing RELOAD_DATA from session");
        HttpSession session = RequestManager.getSession();
        session.setAttribute("RELOAD_DATA", (Object)Boolean.FALSE);
        this.wizardModel.clearWizardData();
        Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Done with this method");
        return true;
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"cancelStep");
        HttpSession session = RequestManager.getSession();
        session.removeAttribute("RELOAD_DATA");
        this.wizardModel.clearWizardData();
        return true;
    }

    private void addTrays(StoragePoolInterface pool) {
        Trace.methodBegin((Object)((Object)this), (String)"addTrays");
        if (this.pbdList.size() <= 0) {
            Trace.error((Object)((Object)this), (String)"addTrays", (String)"Trays List is empty..");
            return;
        }
        ArrayList<RaidSetGroup> raidSetGroups = new ArrayList<RaidSetGroup>();
        Trace.verbose((Object)((Object)this), (String)"addTrays", (String)("Before Creating the RaidSet List: Size of pbdlist is: " + this.pbdList.size()));
        for (int i = 0; i < this.pbdList.size(); ++i) {
            PoolBreakdownForTray pbd = (PoolBreakdownForTray)this.pbdList.get(i);
            int poolIndex = 0;
            try {
                RaidSetGroup rsg = new RaidSetGroup(pbd, poolIndex, this.profileHandle.getArrayType());
                if (Trace.isTraceEnabled((Object)((Object)this))) {
                    Trace.verbose((Object)((Object)this), (String)"addTrays", (String)("Adding RAIDSETGROUP to the list: TrayID: " + pbd.getTrayId() + "; PoolIndex: " + poolIndex + "; ArrayType: " + this.profileHandle.getArrayType()));
                }
                raidSetGroups.add(rsg);
                continue;
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)((Object)this), (String)"addTrays", (String)"Error creating RAIDSETGROUP");
                Trace.error((Object)((Object)this), (String)"addTrays", (ConfigMgmtException)cme);
            }
        }
        Trace.verbose((Object)((Object)this), (String)"addTrays", (String)("Before Calling addStorageToPool: Size of list is: " + raidSetGroups.size()));
        MethodCallStatus mcs = null;
        try {
            mcs = pool.addStorageToPool(raidSetGroups, this.numDisks);
        }
        catch (ConfigMgmtException cme) {
            this.transaction.addFailedOperation();
            Trace.error((Object)((Object)this), (String)"addTrays", (String)"Failed to add tray storage to pool.");
            Trace.error((Object)((Object)this), (String)"addTrays", (ConfigMgmtException)cme);
            this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
            return;
        }
        if (mcs.getReturnCode() == 4096) {
            Trace.verbose((Object)((Object)this), (String)"addTrays", (String)"MCS return code is : 4096, Job is submitted Succesfully");
            Iterator iter = mcs.getJobs().iterator();
            String jobID = "";
            while (iter.hasNext()) {
                JobInterface job = (JobInterface)iter.next();
                jobID = job.getId();
            }
            this.transaction.setSummary(UIUtil.getBUIString1Subst((String)ADDSTORAGE_SUCCESS_SUMMARY, (String)jobID));
        } else {
            Trace.error((Object)((Object)this), (String)"addTrays", (String)"Failed to add tray storage to pool.");
            Trace.error((Object)((Object)this), (String)"addTrays", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
            this.transaction.addFailedOperation(pool.getName(), "error.cim." + mcs.getReturnCode());
        }
    }

    private void addVDisks(StoragePoolInterface pool) {
        Trace.methodBegin((Object)((Object)this), (String)"addVDisks");
        if (this.wwnList.size() <= 0) {
            Trace.verbose((Object)((Object)this), (String)"addVDisks", (String)"VDisks List is empty..");
            return;
        }
        for (int i = 0; i < this.wwnList.size(); ++i) {
            String wwn = (String)this.wwnList.get(i);
            Trace.verbose((Object)((Object)this), (String)"addVDisks", (String)("Before Calling addStorageToPool for WWN: " + wwn));
            MethodCallStatus mcs = null;
            try {
                mcs = pool.addStorageToPool(wwn);
                if (!UIUtil.isMCSSuccess((MethodCallStatus)mcs)) {
                    Trace.error((Object)((Object)this), (String)"addVDisks", (String)("Failed to add storage to Pool for WWN: " + wwn));
                    Trace.error((Object)((Object)this), (String)"handleDeleteButtonRequest", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
                    this.transaction.addFailedOperation("se6x20ui.wizards.pool.CreatePoolSummaryPage.NoStorageText", "error.cim." + mcs.getReturnCode());
                    continue;
                }
                Trace.verbose((Object)((Object)this), (String)"addVDisks", (String)("Succesfully added storage to Pool for WWN: " + wwn));
                continue;
            }
            catch (ConfigMgmtException cme) {
                this.transaction.addFailedOperation("se6x20ui.wizards.pool.CreatePoolSummaryPage.NoStorageText", (Exception)((Object)cme));
                Trace.error((Object)((Object)this), (String)"addVDisks", (String)"Failed to add vdisk storage to pool.");
                Trace.error((Object)((Object)this), (String)"addVDisks", (ConfigMgmtException)cme);
                continue;
            }
            catch (ItemNotFoundException infe) {
                this.transaction.addFailedOperation("se6x20ui.wizards.pool.CreatePoolSummaryPage.NoStorageText", (Exception)((Object)infe));
                Trace.error((Object)((Object)this), (String)"addVDisks", (String)"Failed to add vdisk storage to pool.");
                Trace.error((Object)((Object)this), (String)"addVDisks", (Throwable)infe);
            }
        }
    }

    private void addAutomaticSize(StoragePoolInterface pool) {
        Trace.methodBegin((Object)((Object)this), (String)"addAutomaticSize");
        String sizeStr = (String)this.wizardModel.getValue("AvailableCapacityMenu");
        BigInteger sizeBI = new BigInteger(sizeStr);
        if (sizeBI.compareTo(BigInteger.ZERO) <= 0) {
            Trace.verbose((Object)((Object)this), (String)"addAutomaticSize", (String)"Storage Size is 0, so returning without adding to pool");
            return;
        }
        if (this.profileHandle == null) {
            Trace.verbose((Object)((Object)this), (String)"addAutomaticSize", (String)"Profile handle is null");
            return;
        }
        Trace.verbose((Object)((Object)this), (String)"addAutomaticSize", (String)("Before Calling addStorageToPool with Size: " + sizeStr));
        MethodCallStatus mcs = null;
        try {
            mcs = pool.addStorageToPool(sizeBI, this.numDisks);
            if (mcs.getReturnCode() == 4096) {
                Trace.verbose((Object)((Object)this), (String)"addAutomaticSize", (String)"MCS return code is : 4096, Job is submitted Succesfully");
                Iterator iter = mcs.getJobs().iterator();
                String jobID = "";
                while (iter.hasNext()) {
                    JobInterface job = (JobInterface)iter.next();
                    jobID = job.getId();
                }
                this.transaction.setSummary(UIUtil.getBUIString1Subst((String)ADDSTORAGE_SUCCESS_SUMMARY, (String)jobID));
            } else {
                Trace.error((Object)((Object)this), (String)"addAutomaticSize", (String)"Failed to add storage to pool.");
                Trace.error((Object)((Object)this), (String)"addAutomaticSize", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
                this.transaction.addFailedOperation("se6x20ui.wizards.pool.CreatePoolSummaryPage.NoStorageText", "error.cim." + mcs.getReturnCode());
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"addAutomaticSize", (String)"Failed to add storage to pool.");
            Trace.error((Object)((Object)this), (String)"addAutomaticSize", (ConfigMgmtException)cme);
            this.transaction.addFailedOperation("se6x20ui.wizards.pool.CreatePoolSummaryPage.NoStorageText", (Exception)((Object)cme));
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"addAutomaticSize", (String)"Failed to add storage to pool.");
            Trace.error((Object)((Object)this), (String)"addAutomaticSize", (Throwable)ex);
            this.transaction.addFailedOperation("se6x20ui.wizards.pool.CreatePoolSummaryPage.NoStorageText", ex);
        }
    }

    private boolean processProgressPage() {
        Trace.methodBegin((Object)((Object)this), (String)"processProgressPage");
        this.loadData();
        return true;
    }

    private boolean processAddStoragePage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processAddStoragePage");
        String addStorageSelection = (String)this.wizardModel.getValue("AddStorageRadio");
        if (addStorageSelection != null && addStorageSelection.equals("Yes")) {
            this.boolAddStorage = true;
        } else {
            this.boolAddStorage = false;
            this.configType = 0;
            this.wizardModel.setValue(CONFIG_TYPE, (Object)Integer.toString(this.configType));
        }
        Trace.verbose((Object)((Object)this), (String)"processAddStoragePage", (String)("setting hidden field for add storage = " + this.boolAddStorage));
        this.wizardModel.setValue("isCreatePool", (Object)new Boolean(this.boolAddStorage));
        return true;
    }

    private boolean processAvailableCapacityPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processAvailableCapacityPage");
        String capacityValueStr = (String)this.wizardModel.getValue("AvailableCapacityMenu");
        String capacityLabelStr = "";
        String traceStr = "";
        if (capacityValueStr == null) {
            capacityValueStr = "0";
            capacityLabelStr = "se6x20ui.wizards.pool.AddStoragePage1.AutomaticNoneText";
            traceStr = "None";
        } else {
            capacityLabelStr = SizeConvert.bytesStringToDisplayValue((String)capacityValueStr).toLocalizedString();
            traceStr = SizeConvert.bytesStringToDisplayValue((String)capacityValueStr).toString();
        }
        Trace.verbose((Object)((Object)this), (String)"processAvailableCapacityPage", (String)("Selected Automatic Configuration : " + traceStr));
        this.wizardModel.setValue("SelectionField", (Object)capacityLabelStr);
        return true;
    }

    private boolean processConfigPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processConfigPage");
        String configSelection = null;
        String previousSelection = null;
        String configManualTray = null;
        String configManualMove = null;
        String configAutomatic = null;
        configManualTray = (String)this.wizardModel.getValue("ConfigRadioButtonManualTray");
        configManualMove = (String)this.wizardModel.getValue("ConfigRadioButtonManualMove");
        configAutomatic = (String)this.wizardModel.getValue("ConfigRadioButtonAutomatic");
        configManualTray = !"0".equals(configManualTray) ? configManualTray : null;
        configManualMove = !"0".equals(configManualMove) ? configManualMove : null;
        configAutomatic = !"0".equals(configAutomatic) ? configAutomatic : null;
        previousSelection = (String)this.wizardModel.getValue("ConfigSelection");
        if (null == previousSelection) {
            previousSelection = PROGRESS_PAGE;
        }
        if (previousSelection.equals(PROGRESS_PAGE)) {
            this.wizardModel.setValue("ConfigRadioButtonManualTray", configSelection);
            configSelection = configManualTray;
            if (null != configManualMove) {
                configSelection = configManualMove;
            } else if (null != configAutomatic) {
                configSelection = configAutomatic;
            }
        } else if (previousSelection.equals(DOMAIN_PAGE)) {
            this.wizardModel.setValue("ConfigRadioButtonManualMove", (Object)configSelection);
            configSelection = configManualMove;
            if (null != configManualTray) {
                configSelection = configManualTray;
            } else if (null != configAutomatic) {
                configSelection = configAutomatic;
            }
        } else if (previousSelection.equals("3")) {
            this.wizardModel.setValue("ConfigRadioButtonAutomatic", (Object)configSelection);
            configSelection = configAutomatic;
            if (null != configManualTray) {
                configSelection = configManualTray;
            } else if (null != configManualMove) {
                configSelection = configManualMove;
            }
        }
        String configVal = "";
        if (null == configSelection) {
            configSelection = PROGRESS_PAGE;
        }
        this.wizardModel.setValue("ConfigSelection", (Object)configSelection);
        if (configSelection.equals(PROGRESS_PAGE)) {
            configVal = "se6x20ui.wizards.pool.AddStorageSummaryPage.configTraysText";
            this.configType = 1;
            this.wizardModel.setValue("ConfigRadioButtonManualTray", null);
            String numDisksStr = "";
            if (this.isNumDisksVariable) {
                numDisksStr = (String)this.wizardModel.getValue("NumDisksMenuManualTray");
                Trace.verbose((Object)((Object)this), (String)"processConfigPage", (String)("Num Disks Selected are : " + numDisksStr));
                if (null == numDisksStr || "".equals(numDisksStr)) {
                    Trace.verbose((Object)((Object)this), (String)"processConfigPage", (String)"Num Disks Selected is null or empty, defaulting to 3");
                    numDisksStr = "3";
                }
            } else {
                numDisksStr = Integer.toString(this.profileHandle.getNumberOfDisks());
            }
            this.wizardModel.setValue("NumDisksField", (Object)numDisksStr);
            this.numDisks = Integer.parseInt(numDisksStr);
        } else if (configSelection.equals(DOMAIN_PAGE)) {
            this.wizardModel.setValue("ConfigRadioButtonManualMove", null);
            configVal = "se6x20ui.wizards.pool.AddStorageSummaryPage.configVdisksText";
            this.configType = 2;
        } else {
            this.wizardModel.setValue("ConfigRadioButtonAutomatic", null);
            configVal = "se6x20ui.wizards.pool.AddStorageSummaryPage.configAutomaticText";
            this.configType = 3;
            String numDisksStr = "";
            if (this.isNumDisksVariable) {
                numDisksStr = (String)this.wizardModel.getValue("NumDisksMenuAutomatic");
                Trace.verbose((Object)((Object)this), (String)"processConfigPage", (String)("Num Disks Selected are : " + numDisksStr));
                if (null == numDisksStr || "".equals(numDisksStr)) {
                    Trace.verbose((Object)((Object)this), (String)"processConfigPage", (String)"Num Disks Selected is null or empty, defaulting to 3");
                    numDisksStr = "3";
                }
            } else {
                numDisksStr = Integer.toString(this.profileHandle.getNumberOfDisks());
            }
            this.wizardModel.setValue("NumDisksField", (Object)numDisksStr);
            this.numDisks = Integer.parseInt(numDisksStr);
        }
        this.wizardModel.setValue("ConfigField", (Object)configVal);
        this.wizardModel.setValue(CONFIG_TYPE, (Object)Integer.toString(this.configType));
        return true;
    }

    private boolean processTraysPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processConfigPage");
        CCActionTable traysTable = (CCActionTable)((AddStorageTraysView)((AddStoragePage3View)wizardEvent.getView()).getChild("AddStorageTraysView")).getChild("AddStorageTraysTable");
        this.pbdList = new ArrayList();
        try {
            traysTable.restoreStateData();
            AddStorageTraysModel traysModel = (AddStorageTraysModel)traysTable.getModel();
            Integer[] selectedRows = traysModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processTraysPage", (String)("[" + selectedRows.length + "] rows were selected"));
            String traysStr = "";
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                traysModel.setRowIndex(row);
                String key = (String)traysModel.getValue("Href");
                Trace.verbose((Object)((Object)this), (String)"processTraysPage", (String)("key for the Tray is : " + key));
                int tray_index = key.indexOf("|");
                String trayId = key.substring(0, tray_index);
                String t4Name = key.substring(tray_index + 1, key.length());
                Trace.verbose((Object)((Object)this), (String)"processTraysPage", (String)("TrayId: " + trayId));
                traysStr = traysStr + trayId + "<BR>";
                PoolBreakdownForTray pbd = traysModel.getPoolBreakdown(key);
                this.pbdList.add(pbd);
            }
            if (traysStr.length() <= 0) {
                traysStr = "se6x20ui.wizards.pool.CreatePoolSummaryPage.noneSelected";
            }
            this.wizardModel.setValue("SelectionField", (Object)traysStr);
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"processTraysPage", (Throwable)ex);
        }
        return true;
    }

    private boolean processVDisksPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processVDisksPage");
        this.wwnList = new ArrayList();
        String vdisksStr = "";
        VDisksSummaryView containerView = (VDisksSummaryView)((AddStoragePage4View)wizardEvent.getView()).getChild("VDisksForStealingView");
        CCActionTable vdisksTable = (CCActionTable)containerView.getChild("VDisksForStealingTable");
        try {
            vdisksTable.restoreStateData();
            VDisksSummaryModel vdisksModel = (VDisksSummaryModel)vdisksTable.getModel();
            Integer[] selectedRows = vdisksModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processVDisksPage", (String)("[" + selectedRows.length + "] rows were selected"));
            String wwn = null;
            String name = null;
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                vdisksModel.setRowIndex(row);
                wwn = (String)vdisksModel.getValue("HiddenWWN");
                name = (String)vdisksModel.getValue("HiddenName");
                Trace.verbose((Object)((Object)this), (String)"processVDisksPage", (String)("Selected VDisk WWN is: " + wwn));
                vdisksStr = vdisksStr + name + "<BR>";
                this.wwnList.add(wwn);
            }
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"processVDisksPage", (String)"Exception in getting WWN.");
            Trace.error((Object)((Object)this), (String)"processVDisksPage", (Throwable)ex);
        }
        if (vdisksStr.length() <= 0) {
            vdisksStr = "se6x20ui.wizards.pool.CreatePoolSummaryPage.noneSelected";
        }
        this.wizardModel.setValue("SelectionField", (Object)vdisksStr);
        return true;
    }

    private void initializeWizard() {
        Trace.methodBegin((Object)((Object)this), (String)"initializeWizard");
        this.wizardName = "CreatePoolImpl";
        this.wizardTitle = "se6x20ui.wizards.pool.CreatePool.Title";
        this.pageClass = CreatePoolWizardData.pageClass;
        this.stepText = CreatePoolWizardData.stepText;
        this.pageTitle = CreatePoolWizardData.pageTitle;
        this.stepHelp = CreatePoolWizardData.stepHelp;
        this.stepInstruction = CreatePoolWizardData.stepInstruction;
        this.initializePages(10);
    }

    private void loadData() {
        Trace.methodBegin((Object)((Object)this), (String)"loadData");
        HttpSession session = RequestManager.getSession();
        if (this.t4List != null) {
            this.wizardModel.setValue("WIZARD_T4S_HANDLE", (Object)this.t4List);
        } else {
            this.t4List = (List)this.wizardModel.getValue("WIZARD_T4S_HANDLE");
        }
        try {
            NewStorageFilter storageFilter = new NewStorageFilter(UIUtil.getConfigContext(), this.t4List);
            if (this.t4List == null) {
                this.t4List = storageFilter.getLoadedArrays();
                this.wizardModel.setValue("WIZARD_T4S_HANDLE", (Object)this.t4List);
                Trace.verbose((Object)((Object)this), (String)"loadData", (String)"Storing t4 first time");
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)"loadData", (ConfigMgmtException)cex);
        }
    }

    private boolean processProfilesPage(WizardEvent wizardEvent) {
        int maxNumDisks;
        Trace.methodBegin((Object)((Object)this), (String)"processProfilesPage");
        ProfilesSummaryView containerView = (ProfilesSummaryView)((CreatePoolPage3View)wizardEvent.getView()).getChild("ProfilesSummaryView");
        CCActionTable profilesTable = (CCActionTable)containerView.getChild("ProfilesSummaryTable");
        try {
            profilesTable.restoreStateData();
        }
        catch (ModelControlException mex) {
            Trace.error((Object)((Object)this), (String)"processProfilesPage", (Throwable)mex);
            return false;
        }
        ProfilesSummaryModel profilesModel = (ProfilesSummaryModel)profilesTable.getModel();
        Integer[] selectedRows = profilesModel.getSelectedRows();
        Trace.verbose((Object)((Object)this), (String)"processProfilesPage", (String)("[" + selectedRows.length + "] rows were selected"));
        if (selectedRows.length <= 0) {
            return false;
        }
        HashMap key_profile = (HashMap)this.wizardModel.getValue("WIZARD_M_KEY_PROF");
        if (key_profile != null) {
            Trace.verbose((Object)((Object)this), (String)"processProfiles", (String)"Key_Profile map not null");
            boolean found = false;
            maxNumDisks = 0;
            for (int i = 0; i < selectedRows.length && !found; ++i) {
                int row = selectedRows[i];
                profilesModel.setRowIndex(row);
                String profileKey = (String)profilesModel.getValue("HiddenKey");
                maxNumDisks = Integer.parseInt((String)profilesModel.getValue("HiddenStorageAvailableKey"));
                this.profileHandle = (StorageProfileInterface)key_profile.get(profileKey);
                if (this.profileHandle == null) continue;
                found = true;
            }
            if (this.profileHandle != null) {
                boolean bl = this.storageAvailableForProfile = maxNumDisks != 0;
                if (this.profileHandle.getNumberOfDisks() == 0) {
                    Trace.verbose((Object)((Object)this), (String)"processAddStoragePage", (String)"Num Disks in Actual Profile are variable");
                    HttpSession session = RequestManager.getSession();
                    session.setAttribute("disksVariable", (Object)"true");
                    this.isNumDisksVariable = true;
                } else {
                    HttpSession session = RequestManager.getSession();
                    session.setAttribute("disksVariable", (Object)"false");
                    this.isNumDisksVariable = false;
                }
            }
        } else {
            Trace.error((Object)((Object)this), (String)"processProfiles", (String)"ProfileAvail map is NULL");
            return false;
        }
        this.wizardModel.setValue("ProfileNameField", (Object)this.profileHandle.getName());
        this.wizardModel.setValue("WIZARD_PROFILE_HANDLE", (Object)this.profileHandle);
        this.wizardModel.setValue("WIZARD_PROFILE_MAXDISKS", (Object)new Integer(maxNumDisks));
        Trace.verbose((Object)((Object)this), (String)"processProfilesPage", (String)("PROFILE_SELECTION: name=" + this.profileHandle.getName()));
        Trace.verbose((Object)((Object)this), (String)"processProfilesPage", (String)("Storage Available= " + this.storageAvailableForProfile));
        Trace.verbose((Object)((Object)this), (String)"processProfilesPage", (String)("MaxNumberOfDisks= " + maxNumDisks));
        return true;
    }

    private boolean processDomainsPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processDomainsPage");
        SVSDSummaryView containerView = (SVSDSummaryView)((CreatePoolPage1View)wizardEvent.getView()).getChild("SVSDSummaryView");
        CCActionTable domainsTable = (CCActionTable)containerView.getChild("SVSDSummaryTable");
        try {
            domainsTable.restoreStateData();
            SVSDSummaryModel domainsModel = (SVSDSummaryModel)domainsTable.getModel();
            Integer[] selectedRows = domainsModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processDomainsPage", (String)("[" + selectedRows.length + "] rows were selected"));
            int i = 0;
            if (i < selectedRows.length) {
                int row = selectedRows[i];
                domainsModel.setRowIndex(row);
                String domainName = (String)domainsModel.getValue("HiddenName");
                this.wizardModel.setValue("DomainField", (Object)domainName);
                this.wizardModel.setValue("WIZARD_DOMAIN_NAME", (Object)domainName);
                Trace.verbose((Object)((Object)this), (String)"processDomainsPage", (String)("DOMAIN_SELECTION: name=" + domainName));
            }
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"processDomainsPage", (Throwable)ex);
        }
        return true;
    }
}

