/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardModel;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class AddStorageTraysModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_COLUMN = "Col";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_ARRAY = "Array";
    public static final String CHILD_NUM_DISKS = "NumDisks";
    public static final String CHILD_ROLE = "Role";
    public static final String CHILD_STATE = "State";
    public static final String CHILD_NUM_VDISKS = "NumVDisks";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String SEP_TAG = "|";
    private HashMap poolBreakMap;
    private SEWizardModel wizardModel;
    public static final String DEFAULT_XML = "/jsp/wizards/pool/AddStorageTraysTable.xml";

    public AddStorageTraysModel(String xmlFile, SEWizardModel wizardModel) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
        this.poolBreakMap = new HashMap();
        this.wizardModel = wizardModel;
    }

    public void populateData(StorageProfileInterface profile, int numDisks) throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"populateData");
        this.clear();
        this.clearModelData();
        this.poolBreakMap.clear();
        List t4List = (List)this.wizardModel.getValue("WIZARD_T4S_HANDLE");
        AvailableSpaceForRaidSets avail = new AvailableSpaceForRaidSets(UIUtil.getConfigContext(), profile.getArrayType(), profile.getSegmentSize(), profile.isReadAheadEnabled(), numDisks, profile.getRAIDLevel(), profile.dedicatedSpareExists(), t4List);
        t4List = avail.getArraysToConsider();
        this.wizardModel.setValue("WIZARD_T4S_HANDLE", (Object)t4List);
        if (avail != null) {
            List poolBreaks = avail.getRaidSetBreakdowns();
            Iterator it = poolBreaks.iterator();
            while (it.hasNext()) {
                PoolBreakdownForTray pbd = (PoolBreakdownForTray)it.next();
                this.appendRow();
                TrayInterface tray = pbd.getTray();
                String id = tray.getId();
                String t4Name = tray.getT4Name();
                String key = id + SEP_TAG + t4Name;
                this.setValue(CHILD_HREF, key);
                this.setValue(CHILD_HIDDENKEY, key);
                this.setValue(CHILD_NAME, id);
                this.setValue(CHILD_ARRAY, t4Name);
                this.setValue(CHILD_NUM_DISKS, Integer.toString(tray.getDisksAvailableForPool(false).size()));
                this.setValue(CHILD_ROLE, "se6920.trays.role." + tray.getRole());
                this.setValue(CHILD_STATE, "se6920.trays.state." + tray.getState());
                this.setValue(CHILD_NUM_VDISKS, Integer.toString(tray.getRaidGroups().size()));
                this.poolBreakMap.put(key, pbd);
            }
        } else {
            Trace.error((Object)((Object)this), (String)"populateData", (String)"Available is null");
        }
    }

    public PoolBreakdownForTray getPoolBreakdown(String key) {
        return (PoolBreakdownForTray)this.poolBreakMap.get(key);
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.bui.trays.summary.tableColName");
        this.setActionValue("ColArray", "se6920ui.bui.trays.summary.tableColArray");
        this.setActionValue("ColNumDisks", "se6920ui.bui.trays.summary.tableColNumDisks");
        this.setActionValue("ColRole", "se6920ui.bui.trays.summary.tableColRole");
        this.setActionValue("ColState", "se6920ui.bui.trays.summary.tableColState");
        this.setActionValue("ColNumVDisks", "se6920ui.bui.trays.summary.tableColNumVDisks");
    }
}

