/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.VDisksSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.VDisksSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddStoragePage3View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddStoragePage4View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddStorageTraysModel;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddStorageTraysView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddStorageWizardData;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.NewStorageFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.RaidSetGroup;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;

public class AddStorageImpl
extends SEWizardImpl {
    public static final String MODELNAME = "AddStorageWizard_ModelName";
    public static final String IMPLNAME = "AddStorageWizard_ImplName";
    public static final String DISKS_VARIABLE = "disksVariable";
    static final String CONFIG_TYPE = "AddStorage_ConfigType";
    static final int CONFIG_TRAYS = 1;
    static final int CONFIG_VDISKS = 2;
    static final int CONFIG_AUTO = 3;
    private static final String PROGRESS_PAGE = "1";
    private static final String CONFIG_PAGE = "2";
    private static final String SELECT_SIZE_PAGE = "3";
    private static final String TRAYS_PAGE = "4";
    private static final String VDISKS_PAGE = "5";
    private int configType = 1;
    private boolean isNumDisksVariable = false;
    private boolean firstPageStateSet = false;
    private ArrayList wwnList = null;
    private ArrayList pbdList = null;
    private static final String SUCCESS_SUMMARY = "se6x20ui.wizards.pool.AddStorage.success";
    private static final String FAILURE_SUMMARY = "se6x20ui.error.wizards.pool.AddStorage.failed";
    private StorageProfileInterface profileHandle;
    private StoragePoolInterface pool;
    private int numDisks = 0;
    private List t4List;

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.pool.AddStorage.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddStorageImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new AddStorageImpl(requestContext);
    }

    public AddStorageImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        Trace.constructor((Object)((Object)this));
        this.initializeWizard();
    }

    public String getNextPageId(String pageId) {
        Trace.methodBegin((Object)((Object)this), (String)"getNextPageId");
        int page = this.pageIdToPage(pageId);
        String nextPageId = Integer.toString(this.nextPages[page][0]);
        if (pageId.equals(CONFIG_PAGE)) {
            if (this.configType == 3) {
                nextPageId = Integer.toString(this.nextPages[page][0]);
            } else if (this.configType == 1) {
                nextPageId = Integer.toString(this.nextPages[page + 1][0]);
            } else if (this.configType == 2) {
                nextPageId = Integer.toString(this.nextPages[page + 2][0]);
            }
        } else if (pageId.equals(SELECT_SIZE_PAGE)) {
            nextPageId = Integer.toString(this.nextPages[page + 2][0]);
        } else if (pageId.equals(TRAYS_PAGE)) {
            nextPageId = Integer.toString(this.nextPages[page + 1][0]);
        }
        return nextPageId;
    }

    public String[] getFutureSteps(String currentPageId) {
        return new String[0];
    }

    public boolean previousStep(WizardEvent wizardEvent) {
        super.previousStep(wizardEvent);
        Trace.methodBegin((Object)((Object)this), (String)"previousStep");
        return true;
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"nextStep");
        if (wizardEvent.getPageId().equals(SELECT_SIZE_PAGE)) {
            this.processAvailableCapacityPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(PROGRESS_PAGE)) {
            this.processProgressPage();
        } else if (wizardEvent.getPageId().equals(CONFIG_PAGE)) {
            this.processConfigPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(TRAYS_PAGE)) {
            this.processTraysPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(VDISKS_PAGE)) {
            this.processVDisksPage(wizardEvent);
        }
        return true;
    }

    public boolean gotoStep(WizardEvent wizardEvent) {
        return !wizardEvent.getGotoPageId().equals(PROGRESS_PAGE);
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        super.finishStep(wizardEvent);
        Trace.methodBegin((Object)((Object)this), (String)"finishStep");
        switch (this.configType) {
            case 1: {
                this.addTrays();
                break;
            }
            case 2: {
                this.addVDisks();
                break;
            }
            case 3: {
                this.addAutomaticSize();
                break;
            }
            default: {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Config Type is None of the three types.. so quitting");
            }
        }
        HttpSession session = RequestManager.getSession();
        session.setAttribute("RELOAD_DATA", (Object)Boolean.FALSE);
        session.removeAttribute("showPI");
        this.wizardModel.clearWizardData();
        return true;
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"cancelStep");
        HttpSession session = RequestManager.getSession();
        session.setAttribute("RELOAD_DATA", (Object)Boolean.FALSE);
        this.wizardModel.clearWizardData();
        return true;
    }

    private void addTrays() {
        Trace.methodBegin((Object)((Object)this), (String)"addTrays");
        if (this.pbdList.size() <= 0) {
            Trace.error((Object)((Object)this), (String)"addTrays", (String)"Trays List is empty.");
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation();
            return;
        }
        try {
            ArrayList<RaidSetGroup> raidSetGroups = new ArrayList<RaidSetGroup>();
            Trace.verbose((Object)((Object)this), (String)"addTrays", (String)("Before Creating the RaidSet List: Size of pbdlist is: " + this.pbdList.size()));
            for (int i = 0; i < this.pbdList.size(); ++i) {
                PoolBreakdownForTray pbd = (PoolBreakdownForTray)this.pbdList.get(i);
                int poolIndex = 0;
                RaidSetGroup rsg = new RaidSetGroup(pbd, poolIndex, this.profileHandle.getArrayType());
                if (Trace.isTraceEnabled((Object)((Object)this))) {
                    Trace.verbose((Object)((Object)this), (String)"addTrays", (String)("Adding RAIDSETGROUP to the list: TrayID: " + pbd.getTrayId() + "; PoolIndex: " + poolIndex + "; ArrayType: " + this.profileHandle.getArrayType()));
                }
                raidSetGroups.add(rsg);
            }
            if (this.pool == null) {
                this.transaction.setSummary(FAILURE_SUMMARY);
                this.transaction.addFailedOperation();
                Trace.error((Object)((Object)this), (String)"addTrays", (String)"Pool reference is NULL");
                return;
            }
            Trace.verbose((Object)((Object)this), (String)"addTrays", (String)("Before Calling addStorageToPool: Size of list is: " + raidSetGroups.size()));
            MethodCallStatus mcs = this.pool.addStorageToPool(raidSetGroups, this.numDisks);
            if (mcs.getReturnCode() == 4096) {
                Trace.verbose((Object)((Object)this), (String)"addTrays", (String)"MCS return code is : 4096, Job is submitted Succesfully");
                Iterator iter = mcs.getJobs().iterator();
                String jobID = "";
                while (iter.hasNext()) {
                    JobInterface job = (JobInterface)iter.next();
                    jobID = job.getId();
                }
                this.transaction.setSummary(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.pool.AddStorage.success.job", (String)jobID));
                this.transaction.addSuccessfulOperation("se6x20ui.wizards.pool.AddStorage.success.job");
            } else {
                Trace.error((Object)((Object)this), (String)"addTrays", (String)"Error occurred while adding storage.");
                Trace.error((Object)((Object)this), (String)"addTrays", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
                this.transaction.setSummary(FAILURE_SUMMARY);
                this.transaction.addFailedOperation("se6x20ui.wizards.pool.AddStorage.trays", "error.cim." + mcs.getReturnCode());
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)"addTrays", (String)"Error occurred while adding storage.");
            Trace.error((Object)((Object)this), (String)"addTrays", (ConfigMgmtException)cex);
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation("se6x20ui.wizards.pool.AddStorage.trays", (Exception)((Object)cex));
        }
    }

    private void addVDisks() {
        Trace.methodBegin((Object)((Object)this), (String)"addVDisks");
        if (this.wwnList.size() <= 0) {
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation();
            Trace.error((Object)((Object)this), (String)"addVDisks", (String)"VDisks List is empty..");
            return;
        }
        for (int i = 0; i < this.wwnList.size(); ++i) {
            String wwn = (String)this.wwnList.get(i);
            try {
                MethodCallStatus mcs = this.pool.addStorageToPool(wwn);
                if (UIUtil.isMCSSuccess((MethodCallStatus)mcs)) {
                    Trace.verbose((Object)((Object)this), (String)"addVDisks", (String)("MCS return code is : " + mcs.getReturnCode() + ", Job is submitted Successfully"));
                    this.transaction.setSummary(SUCCESS_SUMMARY);
                    this.transaction.addSuccessfulOperation(SUCCESS_SUMMARY);
                    continue;
                }
                Trace.error((Object)((Object)this), (String)"addVDisks", (String)"Failed to add VDisks to pool.");
                Trace.error((Object)((Object)this), (String)"addVDisks", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
                this.transaction.setSummary(FAILURE_SUMMARY);
                this.transaction.addFailedOperation("se6x20ui.wizards.pool.AddStorage.vdisk", "error.cim." + mcs.getReturnCode());
                continue;
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)((Object)this), (String)"addVDisks", (ConfigMgmtException)cme);
                this.transaction.setSummary(FAILURE_SUMMARY);
                this.transaction.addFailedOperation("se6x20ui.wizards.pool.AddStorage.vdisk", (Exception)((Object)cme));
                continue;
            }
            catch (ItemNotFoundException infe) {
                Trace.error((Object)((Object)this), (String)"addVDisks", (Throwable)infe);
                this.transaction.setSummary(FAILURE_SUMMARY);
                this.transaction.addFailedOperation("se6x20ui.wizards.pool.AddStorage.vdisk", (Exception)((Object)infe));
            }
        }
    }

    private void addAutomaticSize() {
        Trace.methodBegin((Object)((Object)this), (String)"addAutomaticSize");
        String sizeStr = (String)this.wizardModel.getValue("AvailableCapacityMenu");
        BigInteger sizeBI = new BigInteger(sizeStr);
        if (this.profileHandle == null) {
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation();
            Trace.error((Object)((Object)this), (String)"addAutomaticSize", (String)"Profile handle is null");
            return;
        }
        try {
            MethodCallStatus mcs = this.pool.addStorageToPool(sizeBI, this.numDisks);
            if (mcs.getReturnCode() == 4096) {
                Trace.verbose((Object)((Object)this), (String)"addAutomaticSize", (String)"MCS return code is : 4096, Job is submitted Successfully");
                this.transaction.setSummary(SUCCESS_SUMMARY);
                Iterator iter = mcs.getJobs().iterator();
                String jobID = "";
                while (iter.hasNext()) {
                    JobInterface job = (JobInterface)iter.next();
                    jobID = job.getId();
                }
                this.transaction.setSummary(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.pool.AddStorage.success.job", (String)jobID));
                this.transaction.addSuccessfulOperation("se6x20ui.wizards.pool.AddStorage.success.job");
            } else {
                Trace.error((Object)((Object)this), (String)"addAutomaticSize", (String)"Failed to add storage with automatic size.");
                Trace.error((Object)((Object)this), (String)"addAutomaticSize", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
                this.transaction.setSummary(FAILURE_SUMMARY);
                this.transaction.addFailedOperation("se6x20ui.wizards.pool.AddStorage.automaticsize", "error.cim." + mcs.getReturnCode());
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"addAutomaticSize", (String)"Failed to add storage with automatic size.");
            Trace.error((Object)((Object)this), (String)"addAutomaticSize", (ConfigMgmtException)cme);
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation("se6x20ui.wizards.pool.AddStorage.automaticsize", (Exception)((Object)cme));
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"addAutomaticSize", (String)"Failed to add storage with automatic size.");
            Trace.error((Object)((Object)this), (String)"addAutomaticSize", (Throwable)ex);
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation("se6x20ui.wizards.pool.AddStorage.automaticsize", ex);
        }
    }

    private void initializeWizard() {
        Trace.methodBegin((Object)((Object)this), (String)"initializeWizard");
        this.wizardName = "AddStorageImpl";
        this.wizardTitle = "se6x20ui.wizards.pool.AddStorage.Title";
        this.pageClass = AddStorageWizardData.pageClass;
        this.stepText = AddStorageWizardData.stepText;
        this.pageTitle = AddStorageWizardData.pageTitle;
        this.stepHelp = AddStorageWizardData.stepHelp;
        this.stepInstruction = AddStorageWizardData.stepInstruction;
        this.initializePages(6);
        this.configType = 3;
    }

    private void loadData() {
        Trace.methodBegin((Object)((Object)this), (String)"loadData");
        HttpSession session = RequestManager.getSession();
        if (this.t4List != null) {
            this.wizardModel.setValue("WIZARD_T4S_HANDLE", (Object)this.t4List);
        } else {
            this.t4List = (List)this.wizardModel.getValue("WIZARD_T4S_HANDLE");
        }
        try {
            NewStorageFilter storageFilter = new NewStorageFilter(UIUtil.getConfigContext(), this.t4List);
            if (this.t4List == null) {
                this.t4List = storageFilter.getLoadedArrays();
                this.wizardModel.setValue("WIZARD_T4S_HANDLE", (Object)this.t4List);
                Trace.verbose((Object)((Object)this), (String)"loadData", (String)"Storing t4 first time");
            }
            this.pool = (StoragePoolInterface)session.getAttribute("PH");
            if (this.pool == null) {
                Trace.error((Object)((Object)this), (String)"loadData", (String)"Pool is null");
                return;
            }
            Trace.verbose((Object)((Object)this), (String)"loadData", (String)("got pool from model - name:" + this.pool.getName()));
            ManageStorageProfilesInterface mgr = ManageStorageProfilesFactory.getManager();
            mgr.init(UIUtil.getConfigContext(), null);
            this.profileHandle = mgr.getItemByName(this.pool.getProfileName());
            int maxNumDisks = storageFilter.getMaxDisksForProfile(this.profileHandle);
            if (this.profileHandle != null) {
                if (this.profileHandle.getNumberOfDisks() == 0) {
                    Trace.verbose((Object)((Object)this), (String)"loadData", (String)"Num Disks in Actual Profile are variable");
                    session.setAttribute(DISKS_VARIABLE, (Object)"true");
                    this.isNumDisksVariable = true;
                } else {
                    session.setAttribute(DISKS_VARIABLE, (Object)"false");
                    this.isNumDisksVariable = false;
                }
            }
            this.wizardModel.setValue("WIZARD_PROFILE_HANDLE", (Object)this.profileHandle);
            this.wizardModel.setValue("WIZARD_PROFILE_MAXDISKS", (Object)new Integer(maxNumDisks));
            this.wizardModel.setValue("WIZARD_DOMAIN_NAME", (Object)this.pool.getStorageDomainName());
            Trace.verbose((Object)((Object)this), (String)"loadData", (String)("PROFILE_SELECTION: name=" + this.profileHandle.getName()));
            Trace.verbose((Object)((Object)this), (String)"loadData", (String)("MaxNumberOfDisks= " + maxNumDisks));
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)"loadData", (ConfigMgmtException)cex);
        }
    }

    private boolean processAvailableCapacityPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processAvailableCapacityPage");
        String capacityValueStr = (String)this.wizardModel.getValue("AvailableCapacityMenu");
        String capacityLabelStr = "";
        String traceStr = "";
        if (capacityValueStr == null) {
            capacityValueStr = "0";
            capacityLabelStr = "se6x20ui.wizards.pool.AddStoragePage1.AutomaticNoneText";
            traceStr = "None";
        } else {
            capacityLabelStr = SizeConvert.bytesStringToDisplayValue((String)capacityValueStr).toLocalizedString();
            traceStr = SizeConvert.bytesStringToDisplayValue((String)capacityValueStr).toString();
        }
        Trace.verbose((Object)((Object)this), (String)"processAvailableCapacityPage", (String)("Selected Automatic Configuration : " + traceStr));
        this.wizardModel.setValue("SelectionField", (Object)capacityLabelStr);
        return true;
    }

    private boolean processProgressPage() {
        Trace.methodBegin((Object)((Object)this), (String)"processProgressPage");
        this.loadData();
        return true;
    }

    private boolean processConfigPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processConfigPage");
        HttpSession session = RequestManager.getSession();
        session.setAttribute("showPI", (Object)"false");
        String configSelection = null;
        String previousSelection = null;
        String configManualTray = null;
        String configManualMove = null;
        String configAutomatic = null;
        configManualTray = (String)this.wizardModel.getValue("ConfigRadioButtonManualTray");
        configManualMove = (String)this.wizardModel.getValue("ConfigRadioButtonManualMove");
        configAutomatic = (String)this.wizardModel.getValue("ConfigRadioButtonAutomatic");
        configManualTray = !"0".equals(configManualTray) ? configManualTray : null;
        configManualMove = !"0".equals(configManualMove) ? configManualMove : null;
        configAutomatic = !"0".equals(configAutomatic) ? configAutomatic : null;
        previousSelection = (String)this.wizardModel.getValue("ConfigSelection");
        if (null == previousSelection) {
            previousSelection = PROGRESS_PAGE;
        }
        if (previousSelection.equals(PROGRESS_PAGE)) {
            this.wizardModel.setValue("ConfigRadioButtonManualTray", configSelection);
            configSelection = configManualTray;
            if (null != configManualMove) {
                configSelection = configManualMove;
            } else if (null != configAutomatic) {
                configSelection = configAutomatic;
            }
        } else if (previousSelection.equals(CONFIG_PAGE)) {
            this.wizardModel.setValue("ConfigRadioButtonManualMove", (Object)configSelection);
            configSelection = configManualMove;
            if (null != configManualTray) {
                configSelection = configManualTray;
            } else if (null != configAutomatic) {
                configSelection = configAutomatic;
            }
        } else if (previousSelection.equals(SELECT_SIZE_PAGE)) {
            this.wizardModel.setValue("ConfigRadioButtonAutomatic", (Object)configSelection);
            configSelection = configAutomatic;
            if (null != configManualTray) {
                configSelection = configManualTray;
            } else if (null != configManualMove) {
                configSelection = configManualMove;
            }
        }
        String configVal = "";
        if (null == configSelection) {
            configSelection = PROGRESS_PAGE;
        }
        this.wizardModel.setValue("ConfigSelection", (Object)configSelection);
        if (configSelection.equals(PROGRESS_PAGE)) {
            configVal = "se6x20ui.wizards.pool.AddStorageSummaryPage.configTraysText";
            this.configType = 1;
            this.wizardModel.setValue("ConfigRadioButtonManualTray", null);
            String numDisksStr = "";
            if (this.isNumDisksVariable) {
                numDisksStr = (String)this.wizardModel.getValue("NumDisksMenuManualTray");
                Trace.verbose((Object)((Object)this), (String)"processConfigPage", (String)("Num Disks Selected are : " + numDisksStr));
                if (null == numDisksStr || "".equals(numDisksStr)) {
                    Trace.verbose((Object)((Object)this), (String)"processConfigPage", (String)"Num Disks Selected is null or empty, defaulting to 3");
                    numDisksStr = SELECT_SIZE_PAGE;
                }
            } else {
                numDisksStr = Integer.toString(this.profileHandle.getNumberOfDisks());
            }
            this.wizardModel.setValue("NumDisksField", (Object)numDisksStr);
            this.numDisks = Integer.parseInt(numDisksStr);
        } else if (configSelection.equals(CONFIG_PAGE)) {
            this.wizardModel.setValue("ConfigRadioButtonManualMove", null);
            configVal = "se6x20ui.wizards.pool.AddStorageSummaryPage.configVdisksText";
            this.configType = 2;
            this.wizardModel.setValue("NumDisksField", (Object)Integer.toString(this.profileHandle.getNumberOfDisks()));
            session.setAttribute("showPI", (Object)"true");
        } else {
            this.wizardModel.setValue("ConfigRadioButtonAutomatic", null);
            configVal = "se6x20ui.wizards.pool.AddStorageSummaryPage.configAutomaticText";
            this.configType = 3;
            String numDisksStr = "";
            if (this.isNumDisksVariable) {
                numDisksStr = (String)this.wizardModel.getValue("NumDisksMenuAutomatic");
                Trace.verbose((Object)((Object)this), (String)"processConfigPage", (String)("Num Disks Selected are : " + numDisksStr));
                if (null == numDisksStr || "".equals(numDisksStr)) {
                    Trace.verbose((Object)((Object)this), (String)"processConfigPage", (String)"Num Disks Selected is null or empty, defaulting to 3");
                    numDisksStr = SELECT_SIZE_PAGE;
                }
            } else {
                numDisksStr = Integer.toString(this.profileHandle.getNumberOfDisks());
            }
            this.wizardModel.setValue("NumDisksField", (Object)numDisksStr);
            this.numDisks = Integer.parseInt(numDisksStr);
        }
        this.wizardModel.setValue("ConfigField", (Object)configVal);
        this.wizardModel.setValue(CONFIG_TYPE, (Object)Integer.toString(this.configType));
        return true;
    }

    private boolean processTraysPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processTraysPage");
        CCActionTable traysTable = (CCActionTable)((AddStorageTraysView)((AddStoragePage3View)wizardEvent.getView()).getChild("AddStorageTraysView")).getChild("AddStorageTraysTable");
        this.pbdList = new ArrayList();
        try {
            traysTable.restoreStateData();
        }
        catch (ModelControlException mex) {
            Trace.error((Object)((Object)this), (String)"processTraysPage", (Throwable)mex);
        }
        AddStorageTraysModel traysModel = (AddStorageTraysModel)traysTable.getModel();
        Integer[] selectedRows = traysModel.getSelectedRows();
        Trace.verbose((Object)((Object)this), (String)"processTraysPage", (String)("[" + selectedRows.length + "] rows were selected"));
        String traysStr = "";
        for (int i = 0; i < selectedRows.length; ++i) {
            int row = selectedRows[i];
            traysModel.setRowIndex(row);
            String key = (String)traysModel.getValue("Href");
            Trace.verbose((Object)((Object)this), (String)"processTraysPage", (String)("key for the Tray is : " + key));
            int tray_index = key.indexOf("|");
            String trayId = key.substring(0, tray_index);
            String t4Name = key.substring(tray_index + 1, key.length());
            Trace.verbose((Object)((Object)this), (String)"processTraysPage", (String)("TrayId: " + trayId));
            traysStr = traysStr + trayId + "<BR>";
            PoolBreakdownForTray pbd = traysModel.getPoolBreakdown(key);
            this.pbdList.add(pbd);
        }
        if (traysStr.length() <= 0) {
            traysStr = "se6x20ui.wizards.pool.AddStorageSummaryPage.noneSelected";
        }
        this.wizardModel.setValue("SelectionField", (Object)traysStr);
        return true;
    }

    private boolean processVDisksPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processVDisksPage");
        this.wwnList = new ArrayList();
        String vdisksStr = "";
        VDisksSummaryView containerView = (VDisksSummaryView)((AddStoragePage4View)wizardEvent.getView()).getChild("VDisksForStealingView");
        CCActionTable vdisksTable = (CCActionTable)containerView.getChild("VDisksForStealingTable");
        try {
            vdisksTable.restoreStateData();
        }
        catch (ModelControlException mex) {
            Trace.error((Object)((Object)this), (String)"processVDisksPage", (Throwable)mex);
        }
        VDisksSummaryModel vdisksModel = (VDisksSummaryModel)vdisksTable.getModel();
        Integer[] selectedRows = vdisksModel.getSelectedRows();
        Trace.verbose((Object)((Object)this), (String)"processVDisksPage", (String)("[" + selectedRows.length + "] rows were selected"));
        String wwn = null;
        String name = null;
        int nDisks = 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            int row = selectedRows[i];
            vdisksModel.setRowIndex(row);
            wwn = (String)vdisksModel.getValue("HiddenWWN");
            name = (String)vdisksModel.getValue("HiddenName");
            Trace.verbose((Object)((Object)this), (String)"processVDisksPage", (String)("Selected VDisk WWN is: " + wwn));
            vdisksStr = vdisksStr + name + "<BR>";
            this.wwnList.add(wwn);
            ++nDisks;
        }
        if (vdisksStr.length() <= 0) {
            vdisksStr = "se6x20ui.wizards.pool.AddStorageSummaryPage.noneSelected";
        }
        this.wizardModel.setValue("SelectionField", (Object)vdisksStr);
        String numDisksStr = "";
        numDisksStr = Integer.toString(nDisks);
        this.wizardModel.setValue("NumDisksField", (Object)numDisksStr);
        return true;
    }
}

