/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.ExternalStorageSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.ExternalStorageSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.StoragePoolsSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.StoragePoolsSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEAction;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionOperands;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionParameters;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SETransaction;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddExtStoragePage1aView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddExtStoragePage2View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddExtStorageWizardData;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AddExtStorageImpl
extends SEWizardImpl {
    public static final String MODELNAME = "AddExtStorageWizard_ModelName";
    public static final String IMPLNAME = "AddExtStorageWizard_ImplName";
    static final String CONFIG_TYPE = "AddExtStorage_ConfigType";
    static final int CONFIG_VLV = 1;
    static final int CONFIG_RAW = 2;
    private static final String CONFIG_PAGE = "1";
    private static final String POOL_PAGE = "2";
    private static final String CREATE_LEGACY_VOLS_PAGE_ID = "3";
    private static final String REVIEW_PAGE_ID = "4";
    public ArrayList mainStepToNextPageIdSequence;
    int currentStep;
    private int[] stepSequence = AddExtStorageWizardData.mainStepSequence;
    private int[] pageIdToStepSequenceIndex = AddExtStorageWizardData.mainPageIdToStepSequenceIndex;
    final String firstPageId = "1";
    final String lastPageId = "4";
    private LinkedList extLunsList = null;
    private Hashtable newLegacyVolsTable = null;
    private String poolName = null;
    private String domainName = null;
    private int configType = -1;
    private static final String SUCCESS_SUMMARY = "se6x20ui.wizards.pool.AddExternalStorage.success";
    private static final String FAILURE_SUMMARY = "se6x20ui.wizards.pool.AddExternalStorage.failure";
    private static final String SUCCESS_SUMMARY_VLV = "se6x20ui.wizards.pool.AddExternalStorageVLV.success";
    private static final String FAILURE_SUMMARY_VLV = "se6x20ui.wizards.pool.AddExternalStorageVLV.failure";
    private static final String SUCCESS_SUMMARY_RAW = "se6x20ui.wizards.pool.AddExternalStorageRaw.success";
    private static final String FAILURE_SUMMARY_RAW = "se6x20ui.wizards.pool.AddExternalStorageRaw.failure";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$VDiskInterface;

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.pool.AddExternalStorage.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.pool.AddExtStorageImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        model.setValue("wizPassPageSession", (Object)"false");
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new AddExtStorageImpl(requestContext);
    }

    public AddExtStorageImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public String getNextPageId(String pageId) {
        String methodName = "getNextPageId";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ++this.currentStep;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("CURRENT STEP = " + this.currentStep));
        if (this.isFinishPageId(pageId)) {
            return null;
        }
        String id = null;
        try {
            id = ((Integer)this.mainStepToNextPageIdSequence.get(this.currentStep)).toString();
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)methodName, (Throwable)e);
        }
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Returning next page id = " + id));
        return id;
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        if (wizardEvent.getPageId().equals(CONFIG_PAGE)) {
            this.processConfigPage(wizardEvent);
        }
        if (wizardEvent.getPageId().equals(CREATE_LEGACY_VOLS_PAGE_ID)) {
            this.processCreateVolumesPage(wizardEvent);
        }
        if (wizardEvent.getPageId().equals(POOL_PAGE)) {
            this.processPoolsPage(wizardEvent);
        }
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"finishStep");
        VDiskInterface vdisk = null;
        String vlvName = null;
        boolean proceed = true;
        if (null == this.poolName || this.poolName.length() <= 0) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"no pool selected");
            proceed = false;
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation();
        }
        if (null == this.extLunsList || this.extLunsList.size() <= 0) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"no external luns/vdisks selected");
            proceed = false;
            this.transaction.addFailedOperation("finishStep", "no external luns/vdisks selected");
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        if (proceed) {
            ConfigContext context = UIUtil.getConfigContext();
            StoragePoolInterface pool = null;
            if (this.configType != 1) {
                try {
                    ManageStoragePoolsInterface mgr = ManageStoragePoolsFactory.getManager();
                    mgr.init(UIUtil.getConfigContext(), null);
                    pool = mgr.getItemByName(this.poolName, this.domainName);
                }
                catch (Exception cme) {
                    Trace.error((Object)((Object)this), (String)"finishStep", (Throwable)cme);
                    proceed = false;
                    this.transaction.addFailedOperation("finishStep", "Cannot initialize manager");
                    this.transaction.setSummary(FAILURE_SUMMARY);
                    return true;
                }
            }
            Class[] ots = null;
            ManageStorageVolumesInterface mgr = null;
            if (this.configType == 1) {
                mgr = ManageStorageVolumesFactory.getManager();
                ots = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AddExtStorageImpl.class$("java.lang.String")) : class$java$lang$String, class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$VDiskInterface == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$VDiskInterface = AddExtStorageImpl.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$VDiskInterface, class$java$lang$String == null ? (class$java$lang$String = AddExtStorageImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AddExtStorageImpl.class$("java.lang.String")) : class$java$lang$String};
            } else {
                mgr = pool;
                ots = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AddExtStorageImpl.class$("java.lang.String")) : class$java$lang$String};
            }
            ArrayList<Object[]> opList = new ArrayList<Object[]>();
            ArrayList<String> onList = new ArrayList<String>();
            ArrayList<Class[]> otList = new ArrayList<Class[]>();
            String methodName = this.configType == 1 ? "createVLV" : "addStorageToPool";
            Iterator it = this.extLunsList.iterator();
            while (it.hasNext()) {
                vdisk = (VDiskInterface)it.next();
                vlvName = (String)this.newLegacyVolsTable.get(vdisk.getName());
                if (this.configType == 1) {
                    Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Trying to get name for key = " + vdisk.getName()));
                    Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Legacy volume name will be:" + vlvName));
                    Object[] ops = new Object[]{vlvName, vdisk, this.poolName, this.domainName};
                    opList.add(ops);
                    onList.add(vlvName);
                    otList.add(ots);
                    continue;
                }
                String wwn = vdisk.getWWN();
                Object[] ops = new Object[]{wwn};
                opList.add(ops);
                onList.add(wwn);
                otList.add(ots);
            }
            this.invokeAction(mgr, opList, onList, otList, methodName);
        }
        this.wizardModel.clearWizardData();
        return true;
    }

    private void invokeAction(Object mgr, List opList, List onList, List tList, String mgrMethod) {
        String methodName = "invokeAction";
        int opThreshold = UIUtil.getInitParamInt((String)(mgr.getClass().getName() + "." + mgrMethod));
        if (opThreshold <= 0) {
            opThreshold = 2;
        }
        int nOps = opList.size();
        boolean requestAsync = opThreshold < 0 ? false : nOps >= opThreshold;
        ConfigContext context = (ConfigContext)RequestManager.getRequest().getSession().getAttribute("ConfigContext");
        SEActionOperands actionOperands = new SEActionOperands(mgr, mgrMethod, opList, onList, tList, true);
        SEActionParameters actionParams = new SEActionParameters(100);
        SEAction action = new SEAction(context, actionOperands, actionParams, requestAsync);
        if (requestAsync && !action.isAsync()) {
            Trace.error((Object)((Object)this), (String)"invokeAction", (String)"Failed to initialize job!");
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation("se6920.action.notinitiated", "se6920.action.jobnotinitiated");
            return;
        }
        Trace.verbose((Object)((Object)this), (String)"invokeAction", (String)"Execute action....");
        action.execute();
        if (requestAsync) {
            Trace.verbose((Object)((Object)this), (String)"invokeAction", (String)"Asynchronous execution....");
            String jobID = action.getJobID();
            if (jobID == null) {
                jobID = UIUtil.getBUIString((String)"se6920.action.jobunknown");
            }
            String jobInfo = UIUtil.getBUIString1Subst((String)"se6920.action.jobinitiated", (String)jobID);
            this.transaction.setSummary(jobInfo);
            this.transaction.addSuccessfulOperation(jobInfo);
        } else {
            Trace.verbose((Object)((Object)this), (String)"invokeAction", (String)"Synchronous execution - report results....");
            this.processSyncAction(action);
        }
    }

    private void processSyncAction(SEAction action) {
        String keyFailure;
        String methodName = "processSyncAction";
        Trace.methodBegin((Object)((Object)this), (String)"processSyncAction");
        SETransaction trans = action.getTransaction();
        String keySuccess = this.configType == 1 ? SUCCESS_SUMMARY : SUCCESS_SUMMARY_RAW;
        String string = keyFailure = this.configType == 1 ? FAILURE_SUMMARY : FAILURE_SUMMARY_RAW;
        if (trans.isAnyOperations()) {
            if (trans.isAnyFailure()) {
                if (trans.isAnySuccess()) {
                    String err = trans.getDelimitedFailureList();
                    Trace.error((Object)((Object)this), (String)"processSyncAction", (String)("Some actions failed: " + err));
                    this.transaction.setSummary(FAILURE_SUMMARY);
                    this.transaction.addFailedOperation(keyFailure, err);
                } else {
                    this.transaction.setSummary(FAILURE_SUMMARY);
                    this.transaction.addFailedOperation(keyFailure, trans.getSummary());
                }
            } else {
                Trace.verbose((Object)((Object)this), (String)"processSyncAction", (String)"All requested actions processed ok!");
                this.transaction.setSummary(SUCCESS_SUMMARY);
                this.transaction.addSuccessfulOperation(keySuccess);
            }
        }
    }

    private void initializeWizard() {
        Trace.methodBegin((Object)((Object)this), (String)"initializeWizard");
        this.wizardName = "AddExtStorageImpl";
        this.wizardTitle = "se6x20ui.wizards.pool.AddExternalStorage.Title";
        this.pageClass = AddExtStorageWizardData.pageClass;
        this.stepText = AddExtStorageWizardData.stepText;
        this.pageTitle = AddExtStorageWizardData.pageTitle;
        this.stepHelp = AddExtStorageWizardData.stepHelp;
        this.stepInstruction = AddExtStorageWizardData.stepInstruction;
        this.initializePages(4);
        this.currentStep = -1;
        this.mainStepToNextPageIdSequence = new ArrayList();
        this.extLunsList = new LinkedList();
        this.newLegacyVolsTable = new Hashtable();
    }

    private boolean processConfigPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processConfigPage");
        String configSelection = null;
        String previousSelection = null;
        configSelection = (String)this.wizardModel.getValue("ConfigRadioButton");
        Trace.verbose((Object)((Object)this), (String)"processConfigPage", (String)("Config selection = " + configSelection));
        previousSelection = (String)this.wizardModel.getValue("ConfigSelection");
        if (null == previousSelection) {
            previousSelection = CONFIG_PAGE;
        }
        this.wizardModel.setValue("ConfigRadioButton", (Object)configSelection);
        String configVal = "";
        if (null == configSelection) {
            configSelection = CONFIG_PAGE;
        }
        this.wizardModel.setValue("ConfigSelection", (Object)configSelection);
        if (configSelection.equals(CONFIG_PAGE)) {
            configVal = "se6x20ui.wizards.pool.AddExternalStoragePage1.createlv";
            this.configType = 1;
            this.mainStepToNextPageIdSequence.add(new Integer(CREATE_LEGACY_VOLS_PAGE_ID));
        } else {
            configVal = "se6x20ui.wizards.pool.AddExternalStoragePage1.rawstorage";
            this.configType = 2;
            this.mainStepToNextPageIdSequence.add(new Integer(POOL_PAGE));
        }
        this.wizardModel.setValue("PreservationField", (Object)configVal);
        this.wizardModel.setValue(CONFIG_TYPE, (Object)Integer.toString(this.configType));
        this.processSelectedExtLuns();
        return true;
    }

    private boolean processPoolsPage(WizardEvent wizardEvent) {
        this.mainStepToNextPageIdSequence.add(new Integer(REVIEW_PAGE_ID));
        StoragePoolsSummaryView view = (StoragePoolsSummaryView)((AddExtStoragePage2View)wizardEvent.getView()).getChild("StoragePoolsSummaryView");
        CCActionTable poolsTable = (CCActionTable)view.getChild("StoragePoolsSummaryTable");
        try {
            poolsTable.restoreStateData();
            StoragePoolsSummaryModel poolsModel = (StoragePoolsSummaryModel)poolsTable.getModel();
            Integer[] selectedRows = poolsModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)("[" + selectedRows.length + "] rows were selected"));
            int i = 0;
            if (i < selectedRows.length) {
                int row = selectedRows[i];
                poolsModel.setRowIndex(row);
                this.poolName = (String)poolsModel.getValue("HiddenName");
                this.domainName = (String)poolsModel.getValue("HiddenDomain");
                Trace.verbose((Object)((Object)this), (String)"processPoolsPage", (String)("POOL_SELECTION: name=" + this.poolName + "; Domain=" + this.domainName));
                this.wizardModel.setValue("PoolNameField", (Object)this.poolName);
            }
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)"processPoolsPage", (Throwable)e);
        }
        return true;
    }

    private boolean processCreateVolumesPage(WizardEvent wizardEvent) {
        String methodName = "processCreateVolumesPage";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        this.mainStepToNextPageIdSequence.add(new Integer(POOL_PAGE));
        ExternalStorageSummaryView view = (ExternalStorageSummaryView)((AddExtStoragePage1aView)wizardEvent.getView()).getChild("ExternalStorageSummaryView");
        CCActionTable volsTable = (CCActionTable)view.getChild("ExternalStorageSummaryTable");
        try {
            volsTable.restoreStateData();
            ExternalStorageSummaryModel extStorageModel = (ExternalStorageSummaryModel)volsTable.getModel();
            int index = 0;
            Iterator it = this.extLunsList.iterator();
            while (it.hasNext()) {
                VDiskInterface vdisk = (VDiskInterface)it.next();
                extStorageModel.setRowIndex(index);
                String volName = (String)extStorageModel.getValue("Name");
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("VOL_SELECTION : key=" + vdisk.getName()));
                this.newLegacyVolsTable.put(vdisk.getName(), volName);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("VOL_SELECTION: name=" + volName));
                ++index;
            }
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)methodName, (Throwable)e);
        }
        return true;
    }

    private void processSelectedExtLuns() {
        this.extLunsList.clear();
        LinkedList extLunsKeyList = (LinkedList)this.wizardModel.getDefaultContextValue("WIZARD_MULTIPLE_EXTLUN_KEYS");
        if (extLunsKeyList == null) {
            Trace.error((Object)((Object)this), (String)"processSelectedVolumes", (String)"Selected External Luns reference cannot be obtained");
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation();
            return;
        }
        Trace.verbose((Object)((Object)this), (String)"processSelectedExtLuns", (String)("Size of Selected Ext. Luns is: " + extLunsKeyList.size()));
        ConfigContext context = UIUtil.getConfigContext();
        ManageVDisksInterface manageVDIF = ManageVDisksFactory.getManager();
        try {
            manageVDIF.init(context, null);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"processSelectedExtLuns", (ConfigMgmtException)cme);
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation();
            return;
        }
        String vdiskStr = "";
        String vdiskKey = null;
        VDiskInterface vdisk = null;
        Iterator it = extLunsKeyList.iterator();
        while (it.hasNext()) {
            vdiskKey = (String)it.next();
            try {
                vdisk = manageVDIF.getByKey(KeyBuilder.createKeyFromString((String)vdiskKey));
                this.extLunsList.add(vdisk);
                String name = vdisk.getName();
                Trace.verbose((Object)((Object)this), (String)"processSelectedExtLuns", (String)("Ext. Lun reference obtained is: " + name));
                vdiskStr = vdiskStr + name + "<BR>";
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)((Object)this), (String)"processSelectedExtLuns", (String)("Ext. Lun reference cannot be obtained for " + vdiskKey));
                Trace.error((Object)((Object)this), (String)"processSelectedExtLuns", (ConfigMgmtException)cme);
                this.transaction.setSummary(FAILURE_SUMMARY);
                this.transaction.addFailedOperation();
            }
        }
        Trace.verbose((Object)((Object)this), (String)"processSelectedExtLuns", (String)("ExtLunField String is " + vdiskStr));
        this.wizardModel.setValue("SelectedVdiskList", (Object)this.extLunsList);
        this.wizardModel.setValue("ExtLunsField", (Object)vdiskStr);
    }

    public String[] getFuturePages(String currentPageId) {
        String methodName = "getFuturePages";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        if (currentPageId.equals(REVIEW_PAGE_ID)) {
            return null;
        }
        String[] futurePages = this.getFutureSteps(currentPageId, new StepUtil(){

            public String get(int i) {
                return Integer.toString(i + 1);
            }
        });
        return futurePages;
    }

    public String[] getFutureSteps(String currentPageId) {
        String methodName = "getFutureSteps";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        if (currentPageId.equals(REVIEW_PAGE_ID)) {
            return null;
        }
        String[] futureSteps = this.getFutureSteps(currentPageId, new StepUtil(){

            public String get(int i) {
                return AddExtStorageWizardData.stepText[i];
            }
        });
        return futureSteps;
    }

    private String[] getFutureSteps(String currentPageId, StepUtil stepUtil) {
        String methodName = "getFutureSteps";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        int i = 0;
        if (!currentPageId.equals(CONFIG_PAGE)) {
            int step = this.pageIdToStep(currentPageId);
            i = this.pageIdToStepSequenceIndex[step];
        }
        int howMany = this.stepSequence.length - i;
        String[] futureSteps = new String[howMany];
        int j = 0;
        while (i < this.stepSequence.length) {
            try {
                futureSteps[j] = stepUtil.get(this.stepSequence[i]);
            }
            catch (Exception e) {
                Trace.error((Object)((Object)this), (Throwable)e);
            }
            ++i;
            ++j;
        }
        return futureSteps;
    }

    protected int pageIdToStep(String pageId) {
        return Integer.parseInt(pageId) - 1;
    }

    public boolean canBeStepLink(String pageId) {
        return true;
    }

    public boolean previousStep(WizardEvent wizardEvent) {
        String methodName = "previousStep";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Current step = " + this.currentStep));
        for (int i = this.currentStep; i < this.mainStepToNextPageIdSequence.size(); ++i) {
            this.mainStepToNextPageIdSequence.remove(i);
        }
        --this.currentStep;
        super.previousStep(wizardEvent);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface StepUtil {
        public String get(int var1);
    }
}

