/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.MapVolumesData;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class MapVolumesModel
extends CCActionTableModel {
    static final String CHILD_NAME = "Name";
    public static final String CHILD_PERMISSION_MENU = "PermissionMenu";
    public static final String CHILD_LUN_MENU = "LUNMenu";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    private ArrayList availableLUNs = null;
    public static final String DEFAULT_XML = "/jsp/wizards/initiator/MapVolumesTable.xml";
    Integer[] rowsSel = null;
    String[] lunsSel = null;
    String[] permsSel = null;

    public MapVolumesModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initializeHeaders();
        this.availableLUNs = new ArrayList();
    }

    public ArrayList getAvailableLUNs() {
        return this.availableLUNs;
    }

    public Integer[] getUserSelectedRows() {
        return this.rowsSel;
    }

    public String[] getSelectedLuns() {
        return this.lunsSel;
    }

    public String[] getSelectedPerms() {
        return this.permsSel;
    }

    public void populateData(ContextFilter filter, Integer[] rows, String[] luns, String[] perms) throws ConfigMgmtException, ItemNotFoundException {
        this.rowsSel = rows;
        this.lunsSel = luns;
        this.permsSel = perms;
        this.populateData(filter);
    }

    public void populateData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin((Object)((Object)this), (String)"populateData");
        this.clear();
        MapVolumesData volData = new MapVolumesData();
        List volumesList = null;
        try {
            volumesList = volData.getData(filter);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"populateData", (String)"Unable to determine selected volumes.");
            throw cme;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)((Object)this), (String)"populateData", (String)"Unable to determine selected volumes.");
            throw infe;
        }
        this.availableLUNs = this.populateInitiatorAvailableLUNs(filter);
        Trace.verbose((Object)((Object)this), (String)"populateData", (String)("Available LUNs are : " + this.availableLUNs.size()));
        Iterator iter = volumesList.iterator();
        block3: while (iter.hasNext()) {
            this.appendRow();
            StorageVolumeInterface volume = (StorageVolumeInterface)iter.next();
            this.setValue(CHILD_NAME, volume.getName());
            this.setValue(CHILD_HIDDENKEY, KeyBuilder.createStringFromKey((Collection)volume.getKey()));
            if (this.rowsSel != null && this.permsSel != null) {
                for (int i = 0; i < this.rowsSel.length; ++i) {
                    if (this.rowsSel[i].intValue() == this.getRowIndex()) {
                        if (i < this.permsSel.length) {
                            this.setValue(CHILD_PERMISSION_MENU, this.permsSel[i]);
                            continue block3;
                        }
                        this.setValue(CHILD_PERMISSION_MENU, "ReadWrite");
                        continue;
                    }
                    this.setValue(CHILD_PERMISSION_MENU, "ReadWrite");
                }
                continue;
            }
            this.setValue(CHILD_PERMISSION_MENU, "ReadWrite");
        }
    }

    private void initializeHeaders() {
        this.setActionValue("ColName", "se6x20ui.wizards.initiator.MapVolumesPage1.ColName");
        this.setActionValue("ColLUN", "se6x20ui.wizards.initiator.MapVolumesPage1.ColLUN");
        this.setActionValue("ColPermission", "se6x20ui.wizards.initiator.MapVolumesPage1.ColPermission");
    }

    private ArrayList populateInitiatorAvailableLUNs(ContextFilter filter) {
        String initiatorName;
        Trace.methodBegin((Object)((Object)this), (String)"populateInitiatorAvailableLUNs");
        if (filter != null && filter.getType() == 14 && (initiatorName = (String)filter.getValue("INITIATOR_NAME")) != null) {
            Trace.verbose((Object)((Object)this), (String)"populateInitiatorAvailableLUNs", (String)("Initiator is not null - " + initiatorName));
            ConfigContext context = UIUtil.getConfigContext();
            ManageInitiatorsInterface initiatorMgr = ManageInitiatorsFactory.getManager();
            InitiatorInterface initiator = null;
            try {
                initiatorMgr.init(context, null);
                initiator = initiatorMgr.getItemByName(initiatorName);
                return initiator.getAllLUNs();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)((Object)this), (String)"createLunOptionList", (String)"Error initializing the initiator manager");
                Trace.error((Object)((Object)this), (String)"createLunOptionList", (ConfigMgmtException)cme);
            }
        }
        ArrayList<Integer> luns = new ArrayList<Integer>();
        for (int i = 0; i < 256; ++i) {
            luns.add(new Integer(i));
        }
        return luns;
    }
}

