/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator;

import com.iplanet.jato.RequestContext;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEAction;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionOperands;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionParameters;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.MapVolumesModel;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.MapVolumesPage1View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.MapVolumesView;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.MapVolumesWizardData;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.InitiatorVolumeMapping;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.HashSet;
import java.util.LinkedList;
import javax.wbem.cim.UnsignedInt16;

public class MapVolumesImpl
extends SEWizardImpl {
    public static final String MODELNAME = "MapVolumesWizard_ModelName";
    public static final String IMPLNAME = "MapVolumesWizard_ImplName";
    private static final String SUCCESS_SUMMARY = "se6x20ui.wizards.initiator.MapVolumes.success";
    private static final String FAILURE_SUMMARY = "se6x20ui.error.wizards.initiator.MapVolumes.failed";
    private static final String PARTIAL_SUMMARY = "se6x20ui.error.wizards.initiator.MapVolumes.partial";
    private static final String VOLUMES_PAGE = "1";
    private LinkedList mapObjList = null;
    public static String INITIATOR_NAME_FIELD = "CurrentInitiatorName";
    public static String INITIATOR_HANDLE = "InitiatorReference";

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.initiator.MapVolumes.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.MapVolumesImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        model.setValue("wizPassPageSession", (Object)"false");
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new MapVolumesImpl(requestContext);
    }

    public MapVolumesImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        if (wizardEvent.getPageId().equals(VOLUMES_PAGE)) {
            this.processVolumesPage(wizardEvent);
        }
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"finishStep");
        InitiatorInterface initiator = (InitiatorInterface)this.wizardModel.getDefaultContextValue("WIZARD_INITIATOR_HANDLE");
        if (initiator == null) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Selected Initiator reference cannot be obtained");
            this.transaction.setSummary(FAILURE_SUMMARY);
            this.transaction.addFailedOperation("se6x20ui.wizards.initiator.MapVolumes.initiator", "se6x20ui.error.wizards.initiator.MapVolumes.noninitiatorselected");
            return true;
        }
        LinkedList<InitiatorInterface> initiatorsList = new LinkedList<InitiatorInterface>();
        if (initiatorsList == null) {
            this.transaction.addFailedOperation();
            this.transaction.setSummary(UIUtil.getBUIString((String)"se6x20ui.error.error"));
            return true;
        }
        initiatorsList.add(initiator);
        SEActionOperands actionOperands = new SEActionOperands();
        if (actionOperands == null) {
            this.transaction.addFailedOperation();
            this.transaction.setSummary(UIUtil.getBUIString((String)"se6x20ui.error.error"));
            return true;
        }
        actionOperands.add(initiatorsList, this.mapObjList, UIUtil.getBUIString((String)"se6920.action.mapping.fromtoseperator"));
        int nOps = actionOperands.getSize();
        int actionType = 9;
        SEActionParameters actionParams = new SEActionParameters(actionType);
        if (actionParams != null) {
            int opThreshold = UIUtil.getInitParamInt((String)"INITIATOR_MAP_THRESHOLD");
            boolean requestAsync = opThreshold < 0 ? false : nOps >= opThreshold;
            ConfigContext context = UIUtil.getConfigContext();
            SEAction action = new SEAction(context, actionOperands, actionParams, requestAsync);
            if (requestAsync && !action.isAsync()) {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"failed job initiation");
                this.transaction.addFailedOperation();
                this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.notinitiated"));
            } else {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Successful job initiation, starting action");
                action.execute();
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Back from action initiation");
                if (requestAsync) {
                    String jobID = action.getJobID();
                    if (jobID == null) {
                        jobID = UIUtil.getBUIString((String)"se6920.action.jobunknown");
                    }
                    String jobInfo = UIUtil.getBUIString1Subst((String)"se6920.action.jobinitiated", (String)jobID);
                    Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Successful job initiation, job is:" + jobID));
                    this.transaction.addSuccessfulOperation("");
                    this.transaction.setSummary(jobInfo);
                    this.transaction.setSummaryIsJobRelated();
                } else {
                    this.transaction = action.getTransaction();
                    this.wizardModel.setDefaultContextValue("WIZARD_TRANSACTION", (Object)this.transaction);
                    this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, FAILURE_SUMMARY);
                }
            }
        } else {
            this.transaction.addFailedOperation();
            this.transaction.setSummary(UIUtil.getBUIString((String)"se6x20ui.error.error"));
        }
        return true;
    }

    private void initializeWizard() {
        this.wizardName = "MapVolumesImpl";
        this.wizardTitle = "se6x20ui.wizards.initiator.MapVolumes.Title";
        this.pageClass = MapVolumesWizardData.pageClass;
        this.stepText = MapVolumesWizardData.stepText;
        this.pageTitle = MapVolumesWizardData.pageTitle;
        this.stepHelp = MapVolumesWizardData.stepHelp;
        this.stepInstruction = MapVolumesWizardData.stepInstruction;
        this.initializePages(2);
        this.mapObjList = new LinkedList();
    }

    private boolean processVolumesPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processVolumesPage");
        this.mapObjList.clear();
        String mapValue = "";
        MapVolumesView containerView = (MapVolumesView)((MapVolumesPage1View)wizardEvent.getView()).getChild("MapVolumesView");
        CCActionTable volsTable = (CCActionTable)containerView.getChild("MapVolumesTable");
        try {
            volsTable.restoreStateData();
            MapVolumesModel mapVolumesModel = (MapVolumesModel)volsTable.getModel();
            ManageStorageVolumesInterface volumeMgr = ManageStorageVolumesFactory.getManager();
            ConfigContext context = UIUtil.getConfigContext();
            volumeMgr.init(context, null);
            Integer[] selectedRows = mapVolumesModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processVolumesPage", (String)("[" + selectedRows.length + "] rows were selected"));
            StorageVolumeInterface volume = null;
            String[] selectedLuns = new String[selectedRows.length];
            String[] selectedPerms = new String[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                String permStr;
                String lun;
                int row = selectedRows[i];
                mapVolumesModel.setRowIndex(row);
                String volKey = (String)mapVolumesModel.getValue("HiddenKey");
                selectedLuns[i] = lun = (String)mapVolumesModel.getValue("LUNMenu");
                volume = volumeMgr.getByKey(KeyBuilder.createKeyFromString((String)volKey));
                selectedPerms[i] = permStr = (String)mapVolumesModel.getValue("PermissionMenu");
                HashSet<UnsignedInt16> perm = new HashSet<UnsignedInt16>();
                perm.add(ConstantsEnt.LUNMappingPermissions.READ);
                String permDisplayStr = "se6x20ui.common.Mapping.ReadOnly";
                if (permStr.equals("ReadWrite")) {
                    permDisplayStr = "se6x20ui.common.Mapping.ReadWrite";
                    perm.add(ConstantsEnt.LUNMappingPermissions.WRITE);
                }
                permDisplayStr = UIUtil.getBUIString((String)permDisplayStr);
                InitiatorVolumeMapping map = new InitiatorVolumeMapping(lun, perm, (Object)volume);
                this.mapObjList.add(map);
                if (lun.equals("-1")) {
                    lun = UIUtil.getBUIString((String)"se6x20ui.common.Mapping.nextavailable");
                }
                String mapStr = UIUtil.getBUIString((String)"se6x20ui.wizards.initiator.MapVolumesSummaryPage.VolumesText", (String[])new String[]{volume.getName(), lun, permDisplayStr});
                mapValue = mapValue + mapStr + "<BR>";
            }
            this.wizardModel.setValue("selectedRows", (Object)selectedRows);
            this.wizardModel.setValue("selectedLuns", (Object)selectedLuns);
            this.wizardModel.setValue("selectedPerms", (Object)selectedPerms);
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"processVolumesPage", (Throwable)ex);
        }
        if (mapValue.equals("")) {
            mapValue = "se6x20ui.wizards.initiator.MapMultipleVolumesSummaryPage.NoneVolumesText";
        }
        Trace.verbose((Object)((Object)this), (String)"processVolumesPage", (String)UIUtil.getEnglishBUIString((String)mapValue));
        this.wizardModel.setValue("VolumesField", (Object)mapValue);
        return true;
    }
}

