/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class MapVolumesData {
    public List getData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin((Object)this, (String)"getData");
        ArrayList volList = null;
        ConfigContext context = UIUtil.getConfigContext();
        ManageStorageVolumesInterface volumeMgr = ManageStorageVolumesFactory.getManager();
        try {
            volumeMgr.init(context, null);
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"getData", (String)"Error initializing Volume Manager.");
            throw cex;
        }
        if (filter == null) {
            try {
                volList = volumeMgr.getItemsBySystem();
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)this, (String)"getData", (String)"Error getting Volumes.");
                throw cex;
            }
        }
        if (filter.getType() == 1) {
            try {
                String domainName = (String)filter.getValue("DOMAIN_NAME");
                if (domainName == null) {
                    Trace.verbose((Object)this, (String)"getData", (String)"Getting Volumes, filtered to system (No Domain)");
                    volList = volumeMgr.getItemsBySystem();
                }
                volList = volumeMgr.getItemsByStorageDomain(domainName);
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)this, (String)"getData", (String)"Error getting Volumes.");
                throw cex;
            }
        } else {
            if (filter.getType() == 14) {
                try {
                    String domainName = (String)filter.getValue("DOMAIN_NAME");
                    String initiatorName = (String)filter.getValue("INITIATOR_NAME");
                    InitiatorInterface initiator = (InitiatorInterface)filter.getValue("INITIATOR_HANDLE");
                    if (domainName == null) {
                        Trace.verbose((Object)this, (String)"getData", (String)"Getting Volumes, filtered to system (No Domain)");
                        volList = volumeMgr.getItemsBySystem();
                    } else {
                        volList = volumeMgr.getItemsByStorageDomain(domainName);
                    }
                    volList = this.getUnmappedVolumes(volList, initiator);
                }
                catch (ConfigMgmtException cex) {
                    Trace.error((Object)this, (String)"getData", (String)"Error getting Volumes.");
                    throw cex;
                }
            }
            try {
                volList = volumeMgr.getItemsBySystem();
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)this, (String)"getData", (String)"Error getting Volumes.");
                throw cex;
            }
        }
        Trace.verbose((Object)this, (String)"getData", (String)("Returning Volumes list, size: " + volList.size()));
        return volList;
    }

    private ArrayList getUnmappedVolumes(ArrayList volList, InitiatorInterface initiator) {
        Trace.methodBegin((Object)this, (String)"getUnmappedVolumes");
        StorageVolumeInterface volume = null;
        InitiatorVolumeMappingInterface mapIF = null;
        ArrayList mappedVolList = null;
        Trace.verbose((Object)this, (String)"getUnmappedVolumes", (String)"Getting list of mapped volumes");
        try {
            mappedVolList = initiator.getVolumeMappings();
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, (String)"getUnmappedVolumes", (String)"Error getting list of mapped volumes");
            Trace.error((Object)this, (String)"getUnmappedVolumes", (ConfigMgmtException)cme);
        }
        Trace.verbose((Object)this, (String)"getUnmappedVolumes", (String)"Getting list of WWN from mapped volumes");
        ArrayList<String> listWwn = new ArrayList<String>(mappedVolList.size());
        Iterator itMappedVol = mappedVolList.iterator();
        while (itMappedVol.hasNext()) {
            mapIF = (InitiatorVolumeMappingInterface)itMappedVol.next();
            volume = (StorageVolumeInterface)mapIF.getObject();
            if (null == volume) continue;
            listWwn.add(volume.getWwn());
        }
        Trace.verbose((Object)this, (String)"getUnmappedVolumes", (String)"Filtering list of volumes");
        Iterator it = volList.iterator();
        while (it.hasNext()) {
            volume = (StorageVolumeInterface)it.next();
            if (listWwn.indexOf(volume.getWwn()) == -1) continue;
            it.remove();
        }
        return volList;
    }
}

