/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator;

import com.iplanet.jato.RequestContext;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.SVSDSummaryModel;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.SVSDSummaryView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEAction;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionOperands;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEActionParameters;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardImpl;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.CreateInitiatorPage1View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.CreateInitiatorPage3View;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.CreateInitiatorWizardData;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.MapVolumesModel;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.MapVolumesView;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.InitiatorVolumeMapping;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.HashSet;
import java.util.LinkedList;
import javax.wbem.cim.UnsignedInt16;

public class CreateInitiatorImpl
extends SEWizardImpl {
    public static final String MODELNAME = "CreateInitiatorWizard_ModelName";
    public static final String IMPLNAME = "CreateInitiatorWizard_ImplName";
    private static String SUCCESS_SUMMARY = "se6x20ui.wizards.initiator.CreateInitiator.success";
    private static String FAILURE_SUMMARY = "se6x20ui.error.wizards.initiator.CreateInitiator.failed";
    private static String PARTIAL_SUMMARY = "se6x20ui.error.wizards.initiator.CreateInitiator.partial";
    private LinkedList mapObjects = null;
    static final String DOMAIN_PAGE = "1";
    static final String INFO_PAGE = "2";
    static final String VOLUMES_PAGE = "3";

    public static CCWizardWindowModel getWizardWindowModel(String fwdViewBeanName, String implName, String modelName) {
        CCWizardWindowModel model = SEWizardImpl.getWizardWindowModel((String)implName, (String)"se6x20ui.wizards.initiator.CreateInitiator.Title", (String)"com.sun.netstorage.array.mgmt.cfg.bui.wizards.initiator.CreateInitiatorImpl", (String)fwdViewBeanName);
        model.setValue(MODELNAME, (Object)modelName);
        model.setValue("wizPassPageSession", (Object)"false");
        return model;
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new CreateInitiatorImpl(requestContext);
    }

    public CreateInitiatorImpl(RequestContext requestContext) {
        super(requestContext, MODELNAME);
        this.initializeWizard();
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        if (wizardEvent.getPageId().equals(DOMAIN_PAGE)) {
            this.processDomainsPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(INFO_PAGE)) {
            this.processInfoPage(wizardEvent);
        } else if (wizardEvent.getPageId().equals(VOLUMES_PAGE)) {
            this.processVolumesPage(wizardEvent);
        }
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"finishStep");
        String domain = (String)this.wizardModel.getValue("DomainField");
        String wwn = (String)this.wizardModel.getValue("InitiatorWWNField");
        String name = (String)this.wizardModel.getValue("InitiatorNameField");
        String desc = (String)this.wizardModel.getValue("InitiatorDescField");
        int osType = Integer.parseInt((String)this.wizardModel.getValue("InitiatorOSTypeMenu"));
        if (name.length() <= 0) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Name is null");
            this.transaction.addFailedOperation("se6x20ui.wizards.initiator.CreateInitiator.Name", "se6x20ui.error.novalue");
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Initiator create: name=" + name + ", WWN=" + wwn + ", desc=" + desc + ", osType=" + osType + ", domain=" + domain));
        ConfigContext context = UIUtil.getConfigContext();
        if (context == null) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)"Configcontext is empty");
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        ManageInitiatorsInterface mgr = ManageInitiatorsFactory.getManager();
        try {
            mgr.init(context, null);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep", (ConfigMgmtException)cme);
            this.transaction.addFailedOperation();
            this.transaction.setSummary(FAILURE_SUMMARY);
            return true;
        }
        try {
            MethodCallStatus mcs = mgr.create(name, wwn, desc, osType, domain);
            if (UIUtil.isMCSSuccess((MethodCallStatus)mcs)) {
                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Initiator '" + name + "' created"));
                this.transaction.addSuccessfulOperation(UIUtil.getBUIString1Subst((String)"se6x20ui.wizards.initiator.CreateInitiator.specificsuccess", (String)name));
                InitiatorInterface initiator = mgr.getItemByName(name);
                if (null == initiator) {
                    Trace.error((Object)((Object)this), (String)"finishStep", (String)("Error retrieving the just created initiator " + name));
                    this.transaction.addFailedOperation(name, "se6x20ui.error.systemerror");
                    this.transaction.setSummary("se6x20ui.error.wizards.initiator.CreateInitiator.failed");
                } else if (this.mapObjects.size() > 0) {
                    Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Mapping initiator...");
                    LinkedList<InitiatorInterface> initiatorsList = new LinkedList<InitiatorInterface>();
                    if (initiatorsList == null) {
                        this.transaction.addFailedOperation();
                        this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.initiatorcreated.mapsystemerror"));
                        return true;
                    }
                    initiatorsList.add(initiator);
                    SEActionOperands actionOperands = new SEActionOperands();
                    if (actionOperands == null) {
                        this.transaction.addFailedOperation();
                        this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.initiatorcreated.mapsystemerror"));
                        return true;
                    }
                    actionOperands.add(initiatorsList, this.mapObjects, UIUtil.getBUIString((String)"se6920.action.mapping.fromtoseperator"));
                    int nOps = actionOperands.getSize();
                    int actionType = 9;
                    SEActionParameters actionParams = new SEActionParameters(actionType);
                    if (actionParams != null) {
                        int opThreshold = UIUtil.getInitParamInt((String)"INITIATOR_MAP_THRESHOLD");
                        boolean requestAsync = opThreshold < 0 ? false : nOps >= opThreshold;
                        SEAction action = new SEAction(context, actionOperands, actionParams, requestAsync);
                        if (requestAsync && !action.isAsync()) {
                            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"failed job initiation");
                            this.transaction.addFailedOperation();
                            this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.initiatorcreated.mapjobnotinitiated"));
                        } else {
                            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Successful job initiation, starting action");
                            action.execute();
                            Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"Back from action initiation");
                            if (requestAsync) {
                                String jobID = action.getJobID();
                                if (jobID == null) {
                                    jobID = UIUtil.getBUIString((String)"se6920.action.jobunknown");
                                }
                                String jobInfo = UIUtil.getBUIString1Subst((String)"se6920.action.initiatorcreated.mapjobinitiated", (String)jobID);
                                Trace.verbose((Object)((Object)this), (String)"finishStep", (String)("Initiator created, successful job initiation for mapping, job is:" + jobID));
                                this.transaction.addSuccessfulOperation("");
                                this.transaction.setSummary(jobInfo);
                                this.transaction.setSummaryIsJobRelated();
                            } else {
                                this.transaction = action.getTransaction();
                                this.wizardModel.setDefaultContextValue("WIZARD_TRANSACTION", (Object)this.transaction);
                                this.setTransactionSummary(SUCCESS_SUMMARY, PARTIAL_SUMMARY, PARTIAL_SUMMARY);
                            }
                        }
                    } else {
                        this.transaction.addFailedOperation();
                        this.transaction.setSummary(UIUtil.getBUIString((String)"se6920.action.initiatorcreated.mapsystemerror"));
                    }
                } else {
                    Trace.verbose((Object)((Object)this), (String)"finishStep", (String)"No mapping requested");
                    this.transaction.setSummary("se6x20ui.wizards.initiator.CreateInitiator.successNoMap");
                }
            } else {
                Trace.error((Object)((Object)this), (String)"finishStep", (String)("Error creating the initiator " + name));
                Trace.error((Object)((Object)this), (String)"finishStep", (String)UIUtil.getEnglishBUIString((String)("error.cim." + mcs.getReturnCode())));
                this.transaction.addFailedOperation(name, "error.cim." + mcs.getReturnCode());
                this.transaction.setSummary(FAILURE_SUMMARY);
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)("ConfigMgmt Exception creating the initiator " + name));
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.transaction.addFailedOperation(name, (Exception)((Object)cme));
            this.transaction.setSummary(FAILURE_SUMMARY);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)((Object)this), (String)"finishStep", (String)("ItemNotFound Exception creating the initiator " + name));
            Trace.error((Object)((Object)this), (Throwable)infe);
            this.transaction.addFailedOperation(name, (Exception)((Object)infe));
            this.transaction.setSummary(FAILURE_SUMMARY);
        }
        return true;
    }

    private void initializeWizard() {
        Trace.methodBegin((Object)((Object)this), (String)"initializeWizard");
        this.wizardName = "CreateInitiatorImpl";
        this.wizardTitle = "se6x20ui.wizards.initiator.CreateInitiator.Title";
        this.pageClass = CreateInitiatorWizardData.pageClass;
        this.stepText = CreateInitiatorWizardData.stepText;
        this.pageTitle = CreateInitiatorWizardData.pageTitle;
        this.stepHelp = CreateInitiatorWizardData.stepHelp;
        this.stepInstruction = CreateInitiatorWizardData.stepInstruction;
        this.initializePages(4);
        this.mapObjects = new LinkedList();
    }

    private boolean processVolumesPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processVolumesPage");
        String mapValue = "";
        MapVolumesView containerView = (MapVolumesView)((CreateInitiatorPage3View)wizardEvent.getView()).getChild("MapVolumesView");
        CCActionTable mapVolumesTable = (CCActionTable)containerView.getChild("MapVolumesTable");
        try {
            mapVolumesTable.restoreStateData();
            MapVolumesModel mapVolumesModel = (MapVolumesModel)mapVolumesTable.getModel();
            ManageStorageVolumesInterface volumeMgr = ManageStorageVolumesFactory.getManager();
            ConfigContext context = UIUtil.getConfigContext();
            volumeMgr.init(context, null);
            Integer[] selectedRows = mapVolumesModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processVolumesPage", (String)("[" + selectedRows.length + "] rows were selected"));
            StorageVolumeInterface volume = null;
            String[] selectedLuns = new String[selectedRows.length];
            String[] selectedPerms = new String[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                String permStr;
                String lun;
                int row = selectedRows[i];
                mapVolumesModel.setRowIndex(row);
                String volKey = (String)mapVolumesModel.getValue("HiddenKey");
                volume = volumeMgr.getByKey(KeyBuilder.createKeyFromString((String)volKey));
                selectedLuns[i] = lun = (String)mapVolumesModel.getValue("LUNMenu");
                selectedPerms[i] = permStr = (String)mapVolumesModel.getValue("PermissionMenu");
                HashSet<UnsignedInt16> perm = new HashSet<UnsignedInt16>();
                perm.add(ConstantsEnt.LUNMappingPermissions.READ);
                String permDisplayStr = "se6x20ui.common.Mapping.ReadOnly";
                if (permStr.equals("ReadWrite")) {
                    permDisplayStr = "se6x20ui.common.Mapping.ReadWrite";
                    perm.add(ConstantsEnt.LUNMappingPermissions.WRITE);
                }
                permDisplayStr = UIUtil.getBUIString((String)permDisplayStr);
                InitiatorVolumeMapping map = new InitiatorVolumeMapping(lun, perm, (Object)volume);
                this.mapObjects.add(map);
                if (lun.equals("-1")) {
                    lun = UIUtil.getBUIString((String)"se6x20ui.common.Mapping.nextavailable");
                }
                String mapStr = UIUtil.getBUIString((String)"se6x20ui.wizards.initiator.MapVolumesSummaryPage.VolumesText", (String[])new String[]{volume.getName(), lun, permDisplayStr});
                mapValue = mapValue + mapStr + "<BR>";
            }
            this.wizardModel.setValue("selectedRows", (Object)selectedRows);
            this.wizardModel.setValue("selectedLuns", (Object)selectedLuns);
            this.wizardModel.setValue("selectedPerms", (Object)selectedPerms);
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"processVolumesPage", (Throwable)ex);
        }
        if (mapValue.equals("")) {
            mapValue = "se6x20ui.wizards.initiator.CreateInitiatorSummaryPage.NoneVolumesText";
        }
        Trace.verbose((Object)((Object)this), (String)"processVolumesPage", (String)UIUtil.getEnglishBUIString((String)mapValue));
        this.wizardModel.setValue("MapVolumesField", (Object)mapValue);
        return true;
    }

    private boolean processDomainsPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processDomainsPage");
        SVSDSummaryView containerView = (SVSDSummaryView)((CreateInitiatorPage1View)wizardEvent.getView()).getChild("SVSDSummaryView");
        CCActionTable domainsTable = (CCActionTable)containerView.getChild("SVSDSummaryTable");
        try {
            domainsTable.restoreStateData();
            SVSDSummaryModel domainsModel = (SVSDSummaryModel)domainsTable.getModel();
            Integer[] selectedRows = domainsModel.getSelectedRows();
            Trace.verbose((Object)((Object)this), (String)"processDomainsPage", (String)("[" + selectedRows.length + "] rows were selected"));
            int i = 0;
            if (i < selectedRows.length) {
                int row = selectedRows[i];
                domainsModel.setRowIndex(row);
                String domainName = (String)domainsModel.getValue("HiddenName");
                this.wizardModel.setValue("DomainField", (Object)domainName);
                Trace.verbose((Object)((Object)this), (String)"processDomainsPage", (String)("DOMAIN_SELECTION: name=" + domainName));
            }
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"processDomainsPage", (Throwable)ex);
        }
        return true;
    }

    private boolean processInfoPage(WizardEvent wizardEvent) {
        Trace.methodBegin((Object)((Object)this), (String)"processInfoPage");
        String osType = (String)this.wizardModel.getValue("InitiatorOSTypeMenu");
        this.wizardModel.setValue("InitiatorOSTypeField", (Object)("se6920.initiator.ostype." + osType));
        return true;
    }
}

