/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.VolumesSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEContainerView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class VolumesSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_STATE = "State";
    public static final String CHILD_STATE_HREF = "StateHref";
    public static final String CHILD_STATE_HREF_VALUE = "StateHrefValue";
    public static final String CHILD_CONDITION = "Condition";
    public static final String CHILD_VOLUMETYPE = "VolumeType";
    public static final String CHILD_DOMAIN = "Domain";
    public static final String CHILD_DOMAINHIDDEN = "DomainHidden";
    public static final String CHILD_CAPACITY = "Capacity";
    public static final String CHILD_WWN = "WWN";
    public static final String CHILD_USAGE = "Usage";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String CHILD_HIDDENNAME = "HiddenName";
    public static final String CHILD_HIDDENREDUNDANCY = "HiddenRedundancy";
    public static final String DEFAULT_XML = "/jsp/reports/VolumesSummaryTable.xml";
    private static final String ourResBundle = "com.sun.netstorage.array.mgmt.cfg.bui.resources.Resources";

    public VolumesSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public VolumesSummaryModel() {
        this(DEFAULT_XML);
    }

    public void initModelRows(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        String domainFilter;
        this.clear();
        this.clearModelData();
        VolumesSummaryData summaryData = new VolumesSummaryData();
        if (this.isChildSupported("FilterMenu") && (domainFilter = SEContainerView.getDomainQuickFilter()) != null) {
            filter = new ContextFilter(1);
            filter.addValue("DOMAIN_NAME", (Object)domainFilter);
        }
        ArrayList volumesList = summaryData.getData(filter);
        Iterator it = volumesList.iterator();
        while (it.hasNext()) {
            MirrorComponentEnt1Interface mc;
            this.appendRow();
            this.setRowSelected(false);
            StorageVolumeEnt1Interface volume = (StorageVolumeEnt1Interface)it.next();
            String str_key = KeyBuilder.createStringFromKey((Collection)volume.getKey());
            this.setValue(CHILD_HREF, str_key);
            this.setValue(CHILD_HIDDENKEY, str_key);
            String name = volume.getName();
            this.setValue(CHILD_NAME, name);
            this.setValue(CHILD_HIDDENNAME, name);
            String StateStr = "se6920.volume.state." + volume.getState();
            this.setValue(CHILD_STATE, StateStr);
            this.setValue(CHILD_STATE_HREF, StateStr);
            this.setValue(CHILD_STATE_HREF_VALUE, StateStr);
            this.setValue(CHILD_CONDITION, "se6920.volume.condition." + volume.getCondition());
            String redundancy = "se6920.volume.redundancy." + volume.getRedundancyType();
            if (volume.isMirrorComponent() && (mc = (MirrorComponentEnt1Interface)volume).isSplit()) {
                redundancy = "se6920.volume.redundancy.3";
            }
            this.setValue(CHILD_HIDDENREDUNDANCY, redundancy);
            this.setValue(CHILD_VOLUMETYPE, UIUtil.ConstantListToStringList((String)ourResBundle, (String)"se6920.volume.summary.type.", (Set)volume.getSummaryTypeInfo(), (String)"se6920ui.stringlistdelimiter"));
            this.setValue(CHILD_DOMAIN, volume.getStorageDomainName());
            this.setValue(CHILD_DOMAINHIDDEN, volume.getStorageDomainName());
            this.setValue(CHILD_CAPACITY, SizeConvert.bytesStringToDisplayValue((String)volume.getSize().toString()).toLocalizedString());
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(ConstantsEnt.StorageVolumeProperties.MAX_VOLUME_SIZE.toString().length());
            StringBuffer buf = new StringBuffer();
            buf = nf.format(volume.getSize(), buf, new FieldPosition(NumberFormat.Field.INTEGER));
            this.setValue("CapacityHidden", buf.toString());
            this.setValue(CHILD_WWN, volume.getWwn());
            if (filter == null || filter.getValue("VDISK_KEY") == null && filter.getValue("ARRAY_ARRAYID") == null && filter.getValue("TRAY_TRAYID") == null && filter.getValue("DISK_DISKID") == null) continue;
            this.handleUsageColumn(volume);
        }
        this.setUsageColumnText(filter);
    }

    private void handleUsageColumn(StorageVolumeEnt1Interface vol) {
        String methodName = "handleUsageColumn";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Set usageList = vol.getUsageByVolume();
        StringBuffer buf = new StringBuffer();
        boolean isFirst = true;
        Iterator it = usageList.iterator();
        while (it.hasNext()) {
            String usageStr = (String)it.next();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Usage string = " + usageStr));
            if (!isFirst) {
                buf.append(UIUtil.getBUIString((String)"se6920ui.stringlistdelimiter"));
            }
            buf.append(UIUtil.getBUIString((String)usageStr));
            isFirst = false;
        }
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Setting usage field = " + buf));
        this.setValue(CHILD_USAGE, buf.toString());
    }

    private void setUsageColumnText(ContextFilter filter) {
        if (filter == null) {
            this.setActionValue("ColUsage", "se6920ui.reports.volumesSummary.tableColUsage");
        } else if (filter.getValue("VDISK_KEY") != null) {
            this.setActionValue("ColUsage", "se6920ui.reports.volumesSummary.tableColUsage.vdisk");
        } else if (filter.getValue("ARRAY_ARRAYID") != null) {
            this.setActionValue("ColUsage", "se6920ui.reports.volumesSummary.tableColUsage.array");
        } else if (filter.getValue("TRAY_TRAYID") != null) {
            this.setActionValue("ColUsage", "se6920ui.reports.volumesSummary.tableColUsage.tray");
        } else if (filter.getValue("DISK_DISKID") != null) {
            this.setActionValue("ColUsage", "se6920ui.reports.volumesSummary.tableColUsage.disk");
        } else {
            this.setActionValue("ColUsage", "se6920ui.reports.volumesSummary.tableColUsage");
        }
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.reports.volumesSummary.tableColName");
        this.setActionValue("ColState", "se6920ui.reports.volumesSummary.tableColState");
        this.setActionValue("ColCondition", "se6920ui.reports.volumesSummary.tableColCondition");
        this.setActionValue("ColVolumeType", "se6920ui.reports.volumesSummary.tableColVolumeType");
        this.setActionValue("ColDomain", "se6920ui.reports.volumesSummary.tableColDomain");
        this.setActionValue("ColCapacity", "se6920ui.reports.volumesSummary.tableColCapacity");
        this.setActionValue("ColWWN", "se6920ui.reports.volumesSummary.tableColWWN");
        this.setActionValue("ColUsage", "se6920ui.reports.volumesSummary.tableColUsage");
    }
}

