/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class VolumesSummaryData {
    public ArrayList getData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        ArrayList volumeList = null;
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        ManageStorageVolumesInterface msv = ManageStorageVolumesFactory.getManager();
        HttpSession session = httprq.getSession();
        ConfigContext cfgctx = (ConfigContext)session.getAttribute("ConfigContext");
        try {
            msv.init(cfgctx, null);
            if (filter == null) {
                volumeList = msv.getItemsBySystem();
            } else {
                switch (filter.getType()) {
                    case 0: {
                        volumeList = msv.getItemsBySystem();
                        break;
                    }
                    case 1: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems volumes, filtered to DOMAIN: " + (String)filter.getValue("DOMAIN_NAME")));
                        volumeList = msv.getItemsByStorageDomain((String)filter.getValue("DOMAIN_NAME"));
                        break;
                    }
                    case 2: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems volumes, filtered to PROFILE: " + (String)filter.getValue("DOMAIN_NAME")));
                        volumeList = msv.getItemsByStorageProfile((String)filter.getValue("PROFILE_NAME"));
                        break;
                    }
                    case 3: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems volumes, filtered to POOL: " + (String)filter.getValue("DOMAIN_NAME")));
                        volumeList = msv.getItemsByStoragePool((String)filter.getValue("POOL_NAME"), (String)filter.getValue("POOL_DOMAIN_NAME"));
                        break;
                    }
                    case 4: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems volumes, filtered to VDISK: " + (String)filter.getValue("DOMAIN_NAME")));
                        volumeList = msv.getItemsByVDisk((String)filter.getValue("VDISK_NAME"));
                        break;
                    }
                    case 7: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting System's volumes, filtered to ARRAY: " + (String)filter.getValue("ARRAY_ARRAYID")));
                        volumeList = msv.getItemsByArray((String)filter.getValue("ARRAY_ARRAYID"));
                        break;
                    }
                    case 8: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting System's volumes, filtered to ARRAY:TRAY: " + (String)filter.getValue("TRAY_ARRAYID") + ":" + (String)filter.getValue("TRAY_TRAYID")));
                        volumeList = msv.getItemsByTray((String)filter.getValue("TRAY_ARRAYID"), (String)filter.getValue("TRAY_TRAYID"));
                        break;
                    }
                    case 9: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting System's volumes, filtered to ARRAY:TRAY:DISK: " + (String)filter.getValue("DISK_ARRAYID") + ":" + (String)filter.getValue("DISK_TRAYID") + ":" + (String)filter.getValue("DISK_DISKID")));
                        volumeList = msv.getItemsByDisk((String)filter.getValue("DISK_ARRAYID"), (String)filter.getValue("DISK_TRAYID"), Integer.parseInt((String)filter.getValue("DISK_DISKID")));
                        break;
                    }
                    default: {
                        volumeList = msv.getItemsBySystem();
                    }
                }
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.verbose((Object)this, (String)"getData", (String)"Error getting items from volume.");
            throw cex;
        }
        catch (ItemNotFoundException iex) {
            Trace.verbose((Object)this, (String)"getData", (String)"Error getting filter context.");
            throw iex;
        }
        Trace.verbose((Object)this, (String)"getData", (String)("Returning volume list, size: " + volumeList.size()));
        return volumeList;
    }
}

