/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SESubReportsModel;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirroredVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import java.util.ArrayList;

public final class VolumeSubReportsModel
extends SESubReportsModel {
    private int numMappings = -1;
    private int numSnapshots = -1;
    private int numVDisks = -1;
    private int numReplicationSets = -1;

    public void initModelRows(Object obj) throws ConfigMgmtException {
        int nItems;
        this.clear();
        StorageVolumeInterface volume = (StorageVolumeInterface)obj;
        try {
            nItems = this.getNumMappings(volume);
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (String)"ConfigMgmtException getting # Mappings");
            nItems = -1;
        }
        this.addItem("se6920ui.bui.volume.details.subreport.row.initiators", nItems);
        if (!(volume instanceof MirrorComponentEnt1Interface)) {
            try {
                nItems = this.getNumSnapshots(volume);
            }
            catch (ConfigMgmtException ex) {
                Trace.error((Object)((Object)this), (String)"initModelRows", (String)"ConfigMgmtException getting # Snapshots");
                nItems = -1;
            }
            this.addItem("se6920ui.bui.volume.details.subreport.row.snapshots", nItems);
        }
        try {
            nItems = this.getNumVDisks(volume);
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (String)"ConfigMgmtException getting # VDisks");
            nItems = -1;
        }
        this.addItem("se6920ui.bui.volume.details.subreport.row.vdisks", nItems);
        if (!(volume instanceof MirroredVolumeEnt1Interface) && !(volume instanceof MirrorComponentEnt1Interface)) {
            try {
                nItems = this.getNumReplicationSets(volume);
            }
            catch (ConfigMgmtException ex) {
                Trace.error((Object)((Object)this), (String)"initModelRows", (String)"ConfigMgmtException getting # Replication Sets");
                nItems = -1;
            }
            this.addItem("se6920ui.bui.volume.details.subreport.row.replicationsets", nItems);
        }
    }

    public int getNumMappings() {
        return this.numMappings;
    }

    public int getNumSnapshots() {
        return this.numSnapshots;
    }

    public int getNumVDisks() {
        return this.numVDisks;
    }

    public int getNumReplicationSets() {
        return this.numReplicationSets;
    }

    private int getNumMappings(StorageVolumeInterface volume) throws ConfigMgmtException {
        ArrayList mappings = volume.getInitiatorMappings();
        this.numMappings = mappings.size();
        return this.numMappings;
    }

    private int getNumSnapshots(StorageVolumeInterface volume) throws ConfigMgmtException {
        ArrayList snapshots = volume.getAssociatedSnapShots();
        this.numSnapshots = snapshots.size();
        return this.numSnapshots;
    }

    private int getNumVDisks(StorageVolumeInterface volume) throws ConfigMgmtException {
        ArrayList vDisks = volume.getAssociatedVDisks();
        this.numVDisks = vDisks.size();
        return this.numVDisks;
    }

    private int getNumReplicationSets(StorageVolumeInterface volume) throws ConfigMgmtException {
        StorageVolume vol = (StorageVolume)volume;
        ArrayList replicationSets = vol.getAssociatedReplicationSets();
        this.numReplicationSets = replicationSets == null ? 0 : replicationSets.size();
        return this.numReplicationSets;
    }
}

