/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.VDisksSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEContainerView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageArrayEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class VDisksSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_COLUMN = "Col";
    public static final String NO_STORAGE_POOL = "se6920.bui.storage.pool.unassigned";
    public static final String NO_STORAGE_DOMAIN = "se6920.bui.storage.domain.unassigned";
    public static final String NO_STORAGE_PROFILE = "se6920.bui.storage.profile.unassigned";
    public static final String NO_ARRAY = "se6920.bui.array.unassigned";
    public static final String MANAGEMENT_INTERNAL = "se6920ui.reports.vdisks.management.internal";
    public static final String MANAGEMENT_EXTERNAL = "se6920ui.reports.vdisks.management.external";
    public static final String CHILD_NAME_VALUE = "nameValue";
    public static final String CHILD_STORAGE_DOMAIN_VALUE = "storagedomainValue";
    public static final String CHILD_STORAGE_POOL_VALUE = "storagepoolValue";
    public static final String CHILD_STORAGE_PROFILE_VALUE = "storageprofileValue";
    public static final String CHILD_MANAGEMENT_VALUE = "managementValue";
    public static final String CHILD_PARTITIONS_VALUE = "partitionsValue";
    public static final String CHILD_CONF_VALUE = "confcapacityValue";
    public static final String CHILD_AVAIL_CAPA_VALUE = "availcapacityValue";
    public static final String CHILD_TRAY_VALUE = "trayValue";
    public static final String CHILD_STATUS_VALUE = "statusValue";
    public static final String CHILD_ARRAY_VALUE = "arrayValue";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String CHILD_HIDDENNAME = "HiddenName";
    public static final String CHILD_HIDDENWWN = "HiddenWWN";
    public static final String DEFAULT_XML = "/jsp/reports/VDisksSummaryTable.xml";

    public VDisksSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public VDisksSummaryModel() {
        this(DEFAULT_XML);
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.bui.vdisks.summary.tableColName");
        this.setActionValue("ColDomain", "se6920ui.bui.vdisks.summary.tableColDomain");
        this.setActionValue("ColPool", "se6920ui.bui.vdisks.summary.tableColPool");
        this.setActionValue("ColProfile", "se6920ui.bui.vdisks.summary.tableColProfile");
        this.setActionValue("ColManagement", "se6920ui.bui.vdisks.summary.tableColManagement");
        this.setActionValue("ColPartitions", "se6920ui.bui.vdisks.summary.tableColPartitions");
        this.setActionValue("ColConfiguredCapacity", "se6920ui.bui.vdisks.summary.tableColConfiguredCapacity");
        this.setActionValue("ColAvailCapacity", "se6920ui.bui.vdisks.summary.tableColAvailCapacity");
        this.setActionValue("ColStatus", "se6920ui.bui.vdisks.summary.tableColStatus");
        this.setActionValue("ColArray", "se6920ui.bui.vdisks.summary.tableColArray");
    }

    public void initModelRows(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        String domainFilter;
        this.clear();
        this.clearModelData();
        VDisksSummaryData summaryData = new VDisksSummaryData();
        if (this.isChildSupported("FilterMenu") && (domainFilter = SEContainerView.getDomainQuickFilter()) != null) {
            filter = new ContextFilter(1);
            filter.addValue("DOMAIN_NAME", (Object)domainFilter);
        }
        List list = summaryData.getData(filter);
        String filterPoolName = null;
        boolean hasPoolFilter = false;
        if (null != filter && filter.getType() == 16) {
            filterPoolName = (String)filter.getValue("POOL_NAME");
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            boolean appendRow = true;
            VDiskEnt1Interface vdisk = (VDiskEnt1Interface)it.next();
            if (null != filterPoolName && filterPoolName.length() > 0 && vdisk.getStoragePoolName().length() > 0 && vdisk.getStoragePoolName().equals(filterPoolName)) {
                appendRow = false;
            }
            if (!appendRow) continue;
            this.appendRow();
            this.setRowSelected(false);
            String str_key = KeyBuilder.createStringFromKey((Collection)vdisk.getKeyAsCollection());
            this.setValue(CHILD_HREF, str_key);
            this.setValue(CHILD_HIDDENKEY, str_key);
            this.setValue(CHILD_HIDDENWWN, vdisk.getWWN());
            String name = vdisk.getName();
            this.setValue(CHILD_NAME_VALUE, name);
            this.setValue(CHILD_HIDDENNAME, name);
            String sdName = vdisk.getStorageDomainName();
            sdName = !sdName.equals("") ? sdName : NO_STORAGE_DOMAIN;
            this.setValue(CHILD_STORAGE_DOMAIN_VALUE, sdName);
            String poolName = vdisk.getStoragePoolName();
            poolName = !poolName.equals("") ? poolName : NO_STORAGE_POOL;
            this.setValue(CHILD_STORAGE_POOL_VALUE, poolName);
            StorageArrayEnt1Interface arrayController = vdisk.getArrayController();
            String arrayName = null;
            if (arrayController != null) {
                arrayName = arrayController.getName();
            }
            arrayName = arrayName != null && !arrayName.equals("") ? arrayName : NO_ARRAY;
            this.setValue(CHILD_ARRAY_VALUE, arrayName);
            String profName = vdisk.getStorageProfileName();
            profName = !profName.equals("") ? profName : NO_STORAGE_PROFILE;
            this.setValue(CHILD_STORAGE_PROFILE_VALUE, profName);
            this.setValue(CHILD_MANAGEMENT_VALUE, vdisk.isExternal() ? MANAGEMENT_EXTERNAL : MANAGEMENT_INTERNAL);
            this.setValue(CHILD_PARTITIONS_VALUE, Integer.toString(vdisk.getNumUsedPartitions()));
            this.setValue(CHILD_CONF_VALUE, SizeConvert.bytesStringToDisplayValue((String)vdisk.getConfiguredCapacity().toString()).toLocalizedString());
            this.setValue(CHILD_AVAIL_CAPA_VALUE, SizeConvert.bytesStringToDisplayValue((String)vdisk.getAvailableCapacity().toString()).toLocalizedString());
            this.setValue(CHILD_STATUS_VALUE, "se6920.vdisk.status." + vdisk.getStatus());
        }
    }
}

