/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class VDisksSummaryData {
    public List getData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        List vDiskList = null;
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        ManageVDisksInterface mgr = ManageVDisksFactory.getManager();
        HttpSession session = httprq.getSession();
        ConfigContext cfgctx = (ConfigContext)session.getAttribute("ConfigContext");
        try {
            mgr.init(cfgctx, null);
            if (filter == null) {
                vDiskList = mgr.getItemsBySystem();
            } else {
                switch (filter.getType()) {
                    case 0: {
                        vDiskList = mgr.getItemsBySystem();
                        break;
                    }
                    case 1: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems VDisks, filtered to DOMAIN: " + (String)filter.getValue("DOMAIN_NAME")));
                        vDiskList = mgr.getItemsByStorageDomain((String)filter.getValue("DOMAIN_NAME"));
                        break;
                    }
                    case 3: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems VDisks, filtered to POOL: " + (String)filter.getValue("POOL_NAME") + " in DOMAIN: " + (String)filter.getValue("POOL_DOMAIN_NAME")));
                        vDiskList = mgr.getItemsByStoragePool((String)filter.getValue("POOL_NAME"), (String)filter.getValue("POOL_DOMAIN_NAME"));
                        break;
                    }
                    case 5: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems VDisks, filtered to VOLUME: " + (String)filter.getValue("VOLUME_NAME")));
                        vDiskList = mgr.getItemsByVolume((String)filter.getValue("VOLUME_NAME"));
                        break;
                    }
                    case 7: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting System's volumes, filtered to ARRAY: " + (String)filter.getValue("ARRAY_ARRAYID")));
                        vDiskList = mgr.getItemsByArray((String)filter.getValue("ARRAY_ARRAYID"));
                        break;
                    }
                    case 8: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting System's volumes, filtered to ARRAY:TRAY: " + (String)filter.getValue("TRAY_ARRAYID") + ":" + (String)filter.getValue("TRAY_TRAYID")));
                        vDiskList = mgr.getItemsByTray((String)filter.getValue("TRAY_ARRAYID"), (String)filter.getValue("TRAY_TRAYID"));
                        break;
                    }
                    case 16: {
                        Trace.verbose((Object)this, (String)"getData", (String)"Getting unused VDISKS in the same domain");
                        vDiskList = this.getUnUsedVDisksInDomain(filter);
                        break;
                    }
                    default: {
                        vDiskList = mgr.getItemsBySystem();
                    }
                }
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"getData", (String)"Error getting items from vdisk.");
            throw cex;
        }
        catch (ItemNotFoundException iex) {
            Trace.error((Object)this, (String)"getData", (String)"Error getting filter context.");
            throw iex;
        }
        Trace.verbose((Object)this, (String)"getData", (String)("Returning VDisks list, size: " + vDiskList.size()));
        return vDiskList;
    }

    public List getUnassignedVDisks() throws ConfigMgmtException {
        Trace.methodBegin((Object)this, (String)"getUnassignedVDisks");
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        ManageVDisksInterface mngVDisks = ManageVDisksFactory.getManager();
        if (mngVDisks == null) {
            Trace.error((Object)this, (String)"getUnassignedVDisks", (String)"ManageVDisksInterface is null");
            ArrayList dataList = new ArrayList();
            return dataList;
        }
        HttpSession session = httprq.getSession();
        ConfigContext cfgctx = (ConfigContext)session.getAttribute("ConfigContext");
        Trace.verbose((Object)this, (String)"getUnassignedVDisks", (String)("ConfigContext is null= " + (cfgctx == null)));
        mngVDisks.init(cfgctx, null);
        ArrayList dataList = mngVDisks.getUnassignedVDisks();
        return dataList;
    }

    public List getUnUsedVDisksInDomain(ContextFilter filter) throws ConfigMgmtException {
        Trace.methodBegin((Object)this, (String)"getUnassignedVDisks");
        String domainName = (String)filter.getValue("DOMAIN_NAME");
        String profileName = (String)filter.getValue("PROFILE_NAME");
        String noDomainEnforce = null;
        noDomainEnforce = (String)filter.getValue("DOMAIN_NO_ENFORCE");
        Trace.verbose((Object)this, (String)"getUnUsedVDisksInDomain", (String)("DomainEnforce: " + noDomainEnforce));
        ConfigContext context = UIUtil.getConfigContext();
        ManageStoragePoolsInterface poolsMgr = ManageStoragePoolsFactory.getManager();
        try {
            poolsMgr.init(context, null);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, (String)"getUnUsedVDisksInDomain", (String)"Exception in initializing pool manager");
            throw cme;
        }
        if (noDomainEnforce == null) {
            Trace.verbose((Object)this, (String)"getUnUsedVDisksInDomain", (String)"Getting VDisks WITH domain match");
            return poolsMgr.findVDisksForStealing(true, profileName, domainName);
        }
        Trace.verbose((Object)this, (String)"getUnUsedVDisksInDomain", (String)"Getting VDisks WITHOUT domain match");
        return poolsMgr.findVDisksForStealing(false, profileName, domainName);
    }
}

