/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SESubReportsModel;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;

public final class VDiskSubReportsModel
extends SESubReportsModel {
    public void initModelRows(Object obj) throws ConfigMgmtException {
        int nItems;
        this.clear();
        VDiskEnt1Interface vdisk = (VDiskEnt1Interface)obj;
        try {
            nItems = this.getNumDisks(vdisk);
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (String)"ConfigMgmtException getting # Disks");
            nItems = -1;
        }
        this.addItem("se6920ui.bui.vdisk.details.subreport.row.disks", nItems);
        boolean hasMany = false;
        try {
            hasMany = vdisk.doesVDiskHaveVolumes();
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (String)"ConfigMgmtException getting # Volumes");
            nItems = -1;
            this.addItem("se6920ui.bui.vdisk.details.subreport.row.volumes", nItems);
        }
        this.addItem("se6920ui.bui.vdisk.details.subreport.row.volumes", hasMany ? "se6920ui.bui.generic.details.subreport.many" : "0");
        try {
            this.addItem("se6920ui.bui.vdisk.details.subreport.row.repsets", this.haveRepSets(vdisk) ? "se6920ui.bui.generic.details.subreport.many" : "0");
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (String)"ConfigMgmtException getting # RepSets");
            nItems = -1;
            this.addItem("se6920ui.bui.vdisk.details.subreport.row.repsets", nItems);
        }
        catch (ItemNotFoundException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (Throwable)ex);
            nItems = -1;
            this.addItem("se6920ui.bui.vdisk.details.subreport.row.repsets", nItems);
        }
    }

    private int getNumDisks(VDiskEnt1Interface vdisk) throws ConfigMgmtException {
        ArrayList[] arr_disks = vdisk.getAssociatedDisks();
        return arr_disks[0].size();
    }

    private boolean haveRepSets(VDiskEnt1Interface vdisk) throws ConfigMgmtException, ItemNotFoundException {
        ManageReplicationServicesEnt1Interface repMgr = (ManageReplicationServicesEnt1Interface)ManageDataServicesFactory.getReplicationServicesManager();
        repMgr.init(UIUtil.getConfigContext(), null, null);
        return repMgr.doesVDiskHaveRepSets(vdisk.getName());
    }
}

