/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.TraysSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class TraysSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_ARRAY = "Array";
    public static final String CHILD_TYPE = "Type";
    public static final String CHILD_ROLE = "Role";
    public static final String CHILD_STATE = "State";
    public static final String CHILD_STATUS = "Status";
    public static final String CHILD_NUMVDISKS = "NumVdisks";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String SEP_TAG = "|";
    public static final String DEFAULT_XML = "/jsp/reports/TraysSummaryTable.xml";
    private HashMap raidsetMap = new HashMap();

    public TraysSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
        this.raidsetMap.clear();
    }

    public TraysSummaryModel() {
        this(DEFAULT_XML);
    }

    public void initModelRows(ContextFilter filter) throws ConfigMgmtException {
        this.clear();
        this.clearModelData();
        TraysSummaryData traysData = new TraysSummaryData();
        List list = traysData.getData(filter);
        ManageVDisksInterface mv = ManageVDisksFactory.getManager();
        mv.init(UIUtil.getConfigContext(), null);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.appendRow();
            this.setRowSelected(false);
            TrayInterface tray = (TrayInterface)it.next();
            String id = tray.getId();
            String name = tray.getT4Name();
            String key = id + SEP_TAG + name;
            this.setValue(CHILD_HREF, key);
            this.setValue(CHILD_HIDDENKEY, key);
            this.setValue(CHILD_NAME, id);
            this.setValue(CHILD_ARRAY, name);
            this.setValue(CHILD_TYPE, "se6920.trays.type." + tray.getTrayType());
            this.setValue(CHILD_ROLE, "se6920.trays.role." + tray.getRole());
            this.setValue(CHILD_STATE, "se6920.trays.state." + tray.getState());
            this.setValue(CHILD_STATUS, "se6920.trays.status." + tray.getStatus());
            this.setValue(CHILD_NUMVDISKS, new Integer(this.getNumVdisks(mv, tray)));
        }
    }

    private int getNumVdisks(ManageVDisksInterface mgr, TrayInterface tray) {
        int result = -1;
        try {
            ArrayList vdisks = mgr.getItemsByTray(tray.getT4Name(), tray.getId());
            result = vdisks != null ? vdisks.size() : 0;
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)((Object)this), (String)"Config Exception getting number of vdisks for tray", (Throwable)cme);
        }
        catch (ItemNotFoundException inf) {
            Trace.verbose((Object)((Object)this), (String)"Exception getting number of vdisks for tray", (Throwable)inf);
        }
        return result;
    }

    public void initModelRows(String profile, int a) throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"populateData Filtered by profile");
        TraysSummaryData traysData = new TraysSummaryData();
        this.clear();
        this.clearModelData();
        List list = traysData.getData(profile, a);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.appendRow();
            this.setRowSelected(false);
            TrayInterface tray = (TrayInterface)it.next();
            String key = tray.getId() + SEP_TAG + tray.getT4Name();
            this.setValue(CHILD_HREF, key);
            this.setValue(CHILD_HIDDENKEY, key);
            this.setValue(CHILD_NAME, tray.getId());
            this.setValue(CHILD_ARRAY, tray.getT4Name());
            this.setValue(CHILD_TYPE, "se6920.trays.type." + tray.getTrayType());
            this.setValue(CHILD_ROLE, "se6920.trays.role." + tray.getRole());
            this.setValue(CHILD_STATE, "se6920.trays.state." + tray.getState());
            this.setValue(CHILD_STATUS, "se6920.trays.status." + tray.getStatus());
            this.raidsetMap.put(key, tray.getRaidGroups());
        }
    }

    public List getRaidGroups(String key) {
        return (List)this.raidsetMap.get(key);
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.bui.trays.summary.tableColName");
        this.setActionValue("ColArray", "se6920ui.bui.trays.summary.tableColArray");
        this.setActionValue("ColType", "se6920ui.bui.trays.summary.tableColType");
        this.setActionValue("ColRole", "se6920ui.bui.trays.summary.tableColRole");
        this.setActionValue("ColState", "se6920ui.bui.trays.summary.tableColState");
        this.setActionValue("ColStatus", "se6920ui.bui.trays.summary.tableColStatus");
        this.setActionValue("ColNumVdisks", "se6920ui.bui.trays.summary.tableColNumVDisks");
    }
}

