/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SESubReportsModel;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.TooManyCIMInstanceException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;

public final class TraySubReportsModel
extends SESubReportsModel {
    private int nRepSets = -1;

    public void initModelRows(Object obj) {
        int nItems;
        String methodName = "initModelRows";
        this.clear();
        TrayInterface tray = (TrayInterface)obj;
        try {
            nItems = this.getNumVDisks(tray);
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (ConfigMgmtException)cex);
            nItems = -1;
        }
        catch (ItemNotFoundException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (Throwable)ex);
            nItems = -1;
        }
        this.addItem("se6920ui.bui.tray.details.subreport.row.vdisks", nItems);
        try {
            nItems = this.getNumDisks(tray);
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (ConfigMgmtException)cex);
            nItems = -1;
        }
        this.addItem("se6920ui.bui.tray.details.subreport.row.disks", nItems);
        try {
            this.addItem("se6920ui.bui.tray.details.subreport.row.volumes", this.haveVolumes(tray) ? "se6920ui.bui.generic.details.subreport.many" : "0");
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (ConfigMgmtException)cex);
            nItems = -1;
            this.addItem("se6920ui.bui.tray.details.subreport.row.volumes", nItems);
        }
        catch (ItemNotFoundException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (Throwable)ex);
            nItems = -1;
            this.addItem("se6920ui.bui.tray.details.subreport.row.volumes", nItems);
        }
        try {
            this.addItem("se6920ui.bui.tray.details.subreport.row.repsets", this.haveRepSets(tray) ? "se6920ui.bui.generic.details.subreport.many" : "0");
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)methodName, (ConfigMgmtException)cex);
            this.addItem("se6920ui.bui.tray.details.subreport.row.repsets", -1);
        }
        catch (ItemNotFoundException ex) {
            Trace.error((Object)((Object)this), (String)methodName, (Throwable)ex);
            this.addItem("se6920ui.bui.tray.details.subreport.row.repsets", -1);
        }
    }

    private boolean haveVolumes(TrayInterface tray) throws ConfigMgmtException, ItemNotFoundException {
        ManageStorageVolumesInterface msv = ManageStorageVolumesFactory.getManager();
        msv.init(UIUtil.getConfigContext(), null);
        ManageStorageVolumes mgr = (ManageStorageVolumes)msv;
        return mgr.doesTrayHaveVolumes(tray.getT4Name(), tray.getId());
    }

    private int getNumVDisks(TrayInterface tray) throws ConfigMgmtException, ItemNotFoundException {
        ManageVDisksInterface mv = ManageVDisksFactory.getManager();
        mv.init(UIUtil.getConfigContext(), null);
        Trace.verbose((Object)((Object)this), (String)"getNumVDisks", (String)("Getting vdisks for Array: " + tray.getT4Name()));
        ArrayList vdisks = mv.getItemsByTray(tray.getT4Name(), tray.getId());
        int size = vdisks.size();
        Trace.verbose((Object)((Object)this), (String)"getNumVolumes", (String)("Got # vdisks: " + size));
        return size;
    }

    private int getNumDisks(TrayInterface tray) throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        return tray.getNumberOfDrives();
    }

    private boolean haveRepSets(TrayInterface tray) throws ConfigMgmtException, ItemNotFoundException {
        ManageReplicationServicesEnt1Interface repMgr = (ManageReplicationServicesEnt1Interface)ManageDataServicesFactory.getReplicationServicesManager();
        repMgr.init(UIUtil.getConfigContext(), null, null);
        return repMgr.doesTrayHaveRepSets(tray.getT4Name(), tray.getId());
    }
}

