/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.StoragePoolsSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEContainerView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class StoragePoolsSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_HIDDEN_KEY = "Hiddenkey";
    public static final String CHILD_HIDDEN_NAME = "HiddenName";
    public static final String CHILD_HIDDEN_DOMAIN = "HiddenDomain";
    public static final String CHILD_HIDDEN_PROFILE = "HiddenProfileName";
    public static final String CHILD_NAME = "Name";
    private static final String CHILD_PROFILE = "Profile";
    private static final String CHILD_STRIPESIZE = "StripeSize";
    public static final String CHILD_HIDDEN_STRIPESIZE = "HiddenStripeSize";
    private static final String CHILD_DOMAIN = "Domain";
    private static final String CHILD_STATE = "State";
    private static final String CHILD_TOTALCAPACITY = "TotalCapacity";
    private static final String CHILD_CONFIGUREDCAPACITY = "ConfiguredCapacity";
    private static final String CHILD_AVAILABLECAPACITY = "AvailableCapacity";
    public static final String DEFAULT_XML = "/jsp/reports/StoragePoolsSummaryTable.xml";
    private ManageStorageProfilesInterface mgr = null;
    private String defaultKey = null;
    private String defaultValue = null;
    private int rowToSelect = -1;

    public StoragePoolsSummaryModel() {
        this(DEFAULT_XML);
    }

    public StoragePoolsSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initializeHeaders();
    }

    private void initializeHeaders() {
        this.setActionValue("DeleteButton", "se6920ui.reports.storagePoolsSummary.ButtonDelete");
        this.setActionValue("NewButton", "se6920ui.reports.storagePoolsSummary.ButtonNew");
        this.setActionValue("ColName", "se6920ui.reports.storagePoolsSummary.tableColName");
        this.setActionValue("ColMirrorComponents", "se6920ui.reports.storagePoolsSummary.tableColMirrorComponents");
        this.setActionValue("ColStripeSize", "se6920ui.reports.storagePoolsSummary.tableColStripeSize");
        this.setActionValue("ColProfile", "se6920ui.reports.storagePoolsSummary.tableColProfile");
        this.setActionValue("ColDomain", "se6920ui.reports.storagePoolsSummary.tableColDomain");
        this.setActionValue("ColState", "se6920ui.reports.storagePoolsSummary.tableColState");
        this.setActionValue("ColTotalCapacity", "se6920ui.reports.storagePoolsSummary.tableColTotalCapacity");
        this.setActionValue("ColConfiguredCapacity", "se6920ui.reports.storagePoolsSummary.tableColConfiguredCapacity");
        this.setActionValue("ColAvailableCapacity", "se6920ui.reports.storagePoolsSummary.tableColAvailableCapacity");
    }

    public void setDefaultSelectedItem(String key, String value) {
        this.defaultKey = key;
        this.defaultValue = value;
    }

    public void populateData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        String domainFilter;
        this.clear();
        StoragePoolsSummaryData poolsData = new StoragePoolsSummaryData();
        ArrayList poolsList = null;
        if (this.isChildSupported("FilterMenu") && (domainFilter = SEContainerView.getDomainQuickFilter()) != null) {
            filter = new ContextFilter(1);
            filter.addValue("DOMAIN_NAME", (Object)domainFilter);
        }
        try {
            poolsList = poolsData.getData(filter);
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)"populateData", (String)"Error getting Pools.");
            throw cex;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)((Object)this), (String)"populateData", (String)"Error getting Pools.");
            throw infe;
        }
        boolean populateMirrorField = this.checkFilter(filter);
        int currentRow = 0;
        Iterator it = poolsList.iterator();
        while (it.hasNext()) {
            StoragePoolInterface storagePool = (StoragePoolInterface)it.next();
            this.appendRow();
            this.setRowSelected(false);
            String keyString = KeyBuilder.createStringFromKey((Collection)storagePool.getKey());
            this.setValue(CHILD_HREF, keyString);
            this.setValue(CHILD_HIDDEN_KEY, keyString);
            String name = storagePool.getName();
            this.setValue(CHILD_NAME, name);
            this.setValue(CHILD_HIDDEN_NAME, name);
            String profileName = storagePool.getProfileName();
            this.setValue(CHILD_PROFILE, profileName);
            this.setValue(CHILD_HIDDEN_PROFILE, profileName);
            if (populateMirrorField) {
                String stripeSize = this.getStripeSize(profileName);
                this.setValue(CHILD_STRIPESIZE, stripeSize);
                this.setValue(CHILD_HIDDEN_STRIPESIZE, stripeSize);
            }
            String sdName = storagePool.getStorageDomainName();
            this.setValue(CHILD_DOMAIN, sdName);
            this.setValue(CHILD_HIDDEN_DOMAIN, sdName);
            this.setValue(CHILD_STATE, storagePool.getAllocatedCapacity().signum() == 0 ? "se6920.storagepool.inusestate.0" : "se6920.storagepool.inusestate.1");
            this.setValue(CHILD_TOTALCAPACITY, SizeConvert.bytesStringToDisplayValue((String)storagePool.getStorageCapacity().toString()).toLocalizedString());
            this.setValue(CHILD_CONFIGUREDCAPACITY, SizeConvert.bytesStringToDisplayValue((String)storagePool.getAllocatedCapacity().toString()).toLocalizedString());
            this.setValue(CHILD_AVAILABLECAPACITY, SizeConvert.bytesStringToDisplayValue((String)storagePool.getUnAllocatedCapacity().toString()).toLocalizedString());
            this.isDefaultRow(currentRow++);
        }
        if (this.rowToSelect != -1) {
            this.setRowSelected(this.rowToSelect, true);
        } else if (currentRow == 1) {
            this.setRowSelected(0, true);
        }
    }

    private boolean checkFilter(ContextFilter filter) {
        int virtStrategy;
        boolean retValue = false;
        if (filter != null && filter.getType() == 19 && (virtStrategy = new Integer((String)filter.getValue("PROFILE_VIRTUALIZATION")).intValue()) == 1) {
            retValue = true;
            try {
                this.mgr = ManageStorageProfilesFactory.getManager();
                this.mgr.init(UIUtil.getConfigContext(), null);
            }
            catch (Exception e) {
                Trace.error((Object)((Object)this), (String)"StoragePoolsSummaryModel", (Throwable)e);
            }
        }
        return retValue;
    }

    private String getStripeSize(String profileName) {
        String stripeSize = "";
        try {
            StorageProfileInterface profileHandle = this.mgr.getItemByName(profileName);
            if (profileHandle != null) {
                stripeSize = profileHandle.getVirtualizationStrategy() == 1 ? "se6920.profile.stripesize." + profileHandle.getStripeSize() : "--";
            }
        }
        catch (Exception e) {
            Trace.error((Object)((Object)this), (String)"StoragePoolsSummaryModel", (Throwable)e);
        }
        return stripeSize;
    }

    private boolean isDefaultRow(int row) {
        String value;
        boolean def = false;
        if (this.rowToSelect == -1 && this.defaultKey != null && this.defaultValue != null && this.defaultValue.equals(value = (String)this.getValue(this.defaultKey))) {
            def = true;
            this.rowToSelect = row;
        }
        return def;
    }
}

