/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;

public final class StoragePoolsSummaryData {
    public ArrayList getData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        ArrayList poolList = null;
        ConfigContext cfgctx = UIUtil.getConfigContext();
        ManageStoragePoolsInterface mgr = ManageStoragePoolsFactory.getManager();
        try {
            mgr.init(cfgctx, null);
            ManageStoragePools msp = (ManageStoragePools)mgr;
            if (filter == null) {
                poolList = mgr.getItemsBySystem();
            } else {
                switch (filter.getType()) {
                    case 0: {
                        poolList = mgr.getItemsBySystem();
                        break;
                    }
                    case 1: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems pools, filtered to DOMAIN: " + (String)filter.getValue("DOMAIN_NAME")));
                        poolList = mgr.getItemsByStorageDomain((String)filter.getValue("DOMAIN_NAME"));
                        break;
                    }
                    case 2: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems pools, filtered to PROFILE: " + (String)filter.getValue("DOMAIN_NAME")));
                        poolList = mgr.getItemsByStorageProfile((String)filter.getValue("PROFILE_NAME"));
                        break;
                    }
                    case 15: {
                        Trace.verbose((Object)this, (String)"getData", (String)"Getting systems pools with available storage");
                        poolList = mgr.getItemsBySystem();
                        poolList = this.filterPoolsWithStorage(poolList);
                        break;
                    }
                    case 21: {
                        Trace.verbose((Object)this, (String)"getData", (String)"Getting pools by domain, with available storage");
                        poolList = msp.getItemsForVolumeSpace((String)filter.getValue("DOMAIN_NAME"));
                        break;
                    }
                    case 17: {
                        Trace.verbose((Object)this, (String)"getData", (String)"Getting only vlv legacy pools");
                        poolList = mgr.getVLVItemsBySystem();
                        break;
                    }
                    case 18: {
                        Trace.verbose((Object)this, (String)"getData", (String)"Getting non vlv legacy pools");
                        poolList = mgr.getNonVLVItemsBySystem();
                        break;
                    }
                    case 19: {
                        Trace.verbose((Object)this, (String)"getData", (String)"Getting pools for mirror creation");
                        Integer virtStrategy = new Integer((String)filter.getValue("PROFILE_VIRTUALIZATION"));
                        int tmpInt = virtStrategy;
                        poolList = msp.getItemsForMirroring((String)filter.getValue("DOMAIN_NAME"), tmpInt);
                        break;
                    }
                    case 20: {
                        Trace.verbose((Object)this, (String)"getData", (String)"Getting pools for remote replication creation");
                        poolList = msp.getItemsForVolumeSpace((String)filter.getValue("DOMAIN_NAME"));
                        break;
                    }
                    default: {
                        poolList = mgr.getItemsBySystem();
                    }
                }
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"getData", (String)"Error getting items from pool.");
            throw cex;
        }
        catch (ItemNotFoundException iex) {
            Trace.error((Object)this, (String)"getData", (String)"Error getting filter context.");
            throw iex;
        }
        Trace.verbose((Object)this, (String)"getData", (String)("Returning pool list, size: " + poolList.size()));
        return poolList;
    }

    private ArrayList filterPoolsWithStorage(ArrayList poolList) {
        Iterator iter = poolList.iterator();
        StoragePoolInterface pool = null;
        while (iter.hasNext()) {
            pool = (StoragePoolInterface)iter.next();
            if (pool == null || pool.getUnAllocatedCapacity().compareTo(BigInteger.ZERO) > 0) continue;
            Trace.verbose((Object)this, (String)"filterPoolsWithStorage", (String)("Unallocated Capacity is ZERO for pool : " + pool.getName()));
            iter.remove();
        }
        return poolList;
    }
}

