/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.StoragePoolsByArraySummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEContainerView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageArrayEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class StoragePoolsByArraySummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_HIDDEN_KEY = "Hiddenkey";
    public static final String CHILD_HIDDEN_NAME = "HiddenName";
    public static final String CHILD_HIDDEN_DOMAIN = "HiddenDomain";
    public static final String CHILD_NAME = "Name";
    private static final String CHILD_ARRAY = "Array";
    private static final String CHILD_DOMAIN = "Domain";
    private static final String CHILD_STATE = "State";
    private static final String CHILD_TOTALCAPACITY = "TotalCapacity";
    private static final String CHILD_CONFIGUREDCAPACITY = "ConfiguredCapacity";
    private static final String CHILD_AVAILABLECAPACITY = "AvailableCapacity";
    public static final String DEFAULT_XML = "/jsp/reports/StoragePoolsByArraySummaryTable.xml";
    private ManageStorageProfilesInterface mgr = null;

    public StoragePoolsByArraySummaryModel() {
        this(DEFAULT_XML);
    }

    public StoragePoolsByArraySummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initializeHeaders();
    }

    private void initializeHeaders() {
        this.setActionValue("ColName", "se6920ui.reports.storagePoolsSummary.tableColName");
        this.setActionValue("ColArray", "se6920ui.reports.storagePoolsSummary.tableColArray");
        this.setActionValue("ColDomain", "se6920ui.reports.storagePoolsSummary.tableColDomain");
        this.setActionValue("ColState", "se6920ui.reports.storagePoolsSummary.tableColState");
        this.setActionValue("ColTotalCapacity", "se6920ui.reports.storagePoolsSummary.tableColTotalCapacity");
        this.setActionValue("ColConfiguredCapacity", "se6920ui.reports.storagePoolsSummary.tableColConfiguredCapacity");
        this.setActionValue("ColAvailableCapacity", "se6920ui.reports.storagePoolsSummary.tableColAvailableCapacity");
    }

    public void populateData() throws ConfigMgmtException, ItemNotFoundException {
        String domainFilter;
        this.clear();
        StoragePoolsByArraySummaryData poolsData = new StoragePoolsByArraySummaryData();
        ArrayList poolsList = null;
        ContextFilter filter = null;
        if (this.isChildSupported("FilterMenu") && (domainFilter = SEContainerView.getDomainQuickFilter()) != null) {
            filter = new ContextFilter(1);
            filter.addValue("DOMAIN_NAME", (Object)domainFilter);
        }
        try {
            poolsList = poolsData.getData(filter);
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)"populateData", (String)"Error getting Pools.");
            throw cex;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)((Object)this), (String)"populateData", (String)"Error getting Pools.");
            throw infe;
        }
        Iterator it = poolsList.iterator();
        while (it.hasNext()) {
            StoragePoolInterface storagePool = (StoragePoolInterface)it.next();
            List arrCtls = storagePool.getArrayControllers();
            for (int j = 0; arrCtls != null && j < arrCtls.size(); ++j) {
                this.appendRow();
                this.setRowSelected(false);
                String keyString = KeyBuilder.createStringFromKey((Collection)storagePool.getKey());
                this.setValue(CHILD_HREF, keyString);
                this.setValue(CHILD_HIDDEN_KEY, keyString);
                String name = storagePool.getName();
                this.setValue(CHILD_NAME, name);
                this.setValue(CHILD_HIDDEN_NAME, name);
                String sdName = storagePool.getStorageDomainName();
                this.setValue(CHILD_DOMAIN, sdName);
                this.setValue(CHILD_HIDDEN_DOMAIN, sdName);
                this.setValue(CHILD_STATE, storagePool.getAllocatedCapacity().signum() == 0 ? "se6920.storagepool.inusestate.0" : "se6920.storagepool.inusestate.1");
                StorageArrayEnt1Interface array = (StorageArrayEnt1Interface)arrCtls.get(j);
                this.setValue(CHILD_ARRAY, array.getName());
                this.setValue(CHILD_TOTALCAPACITY, SizeConvert.bytesStringToDisplayValue((String)array.getRawTotalCapacity(storagePool).toString()).toLocalizedString());
                this.setValue(CHILD_AVAILABLECAPACITY, SizeConvert.bytesStringToDisplayValue((String)array.getRawAvailableCapacity(storagePool).toString().toString()).toLocalizedString());
                this.setValue(CHILD_CONFIGUREDCAPACITY, SizeConvert.bytesStringToDisplayValue((String)array.getRawConfiguredCapacity(storagePool).toString().toString()).toLocalizedString());
            }
        }
    }
}

