/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;

public final class StoragePoolsByArraySummaryData {
    public ArrayList getData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        ArrayList poolList = null;
        ConfigContext cfgctx = UIUtil.getConfigContext();
        ManageStoragePoolsInterface mgr = ManageStoragePoolsFactory.getManager();
        try {
            mgr.init(cfgctx, null);
            ManageStoragePools msp = (ManageStoragePools)mgr;
            if (filter == null) {
                poolList = mgr.getItemsBySystem();
            } else {
                switch (filter.getType()) {
                    case 0: {
                        poolList = mgr.getItemsBySystem();
                        break;
                    }
                    case 1: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems pools, filtered to DOMAIN: " + (String)filter.getValue("DOMAIN_NAME")));
                        poolList = mgr.getItemsByStorageDomain((String)filter.getValue("DOMAIN_NAME"));
                    }
                }
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)this, (String)"getData", (String)"Error getting items from pool.");
            throw cex;
        }
        catch (ItemNotFoundException iex) {
            Trace.error((Object)this, (String)"getData", (String)"Error getting filter context.");
            throw iex;
        }
        Trace.verbose((Object)this, (String)"getData", (String)("Returning pool list, size: " + poolList.size()));
        return poolList;
    }
}

