/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.SnapshotsSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEContainerView;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.SnapShotVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class SnapshotsSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_HREF_PARENT = "Href_parent";
    public static final String CHILD_COLUMN = "Col";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_PARENTVOL = "ParentVolume";
    public static final String CHILD_DOMAIN = "Domain";
    public static final String CHILD_CREATED = "Created";
    public static final String CHILD_STATE = "State";
    public static final String CHILD_CONDITION = "Condition";
    public static final String CHILD_WWN = "WWN";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String CHILD_HIDDENNAME = "HiddenName";
    public static final String CHILD_HIDDEN_PARENTKEY = "HiddenParentKey";
    public static final String CHILD_HIDDEN_PARENTNAME = "HiddenParentName";
    public static final String CHILD_HIDDEN_PARENTREDUNDANCY = "HiddenParentRedundancy";
    public static final String CHILD_HIDDENDOMAIN = "HiddenDomain";
    public static final String DEFAULT_XML = "/jsp/reports/SnapshotsSummaryTable.xml";
    private static final String ourResBundle = "com.sun.netstorage.array.mgmt.cfg.bui.resources.Resources";

    public SnapshotsSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public SnapshotsSummaryModel() {
        this(DEFAULT_XML);
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.reports.snapshotSummary.tableColName");
        this.setActionValue("ColParentVolume", "se6920ui.reports.snapshotSummary.tableColParentVolume");
        this.setActionValue("ColDomain", "se6920ui.reports.snapshotSummary.tableColDomain");
        this.setActionValue("ColCreated", "se6920ui.reports.snapshotSummary.tableColCreated");
        this.setActionValue("ColState", "se6920ui.reports.snapshotSummary.tableColState");
        this.setActionValue("ColCondition", "se6920ui.reports.snapshotSummary.tableColCondition");
        this.setActionValue("ColWWN", "se6920ui.reports.snapshotSummary.tableColWWN");
    }

    public void initModelRows(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        String domainFilter;
        this.clear();
        this.clearModelData();
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        HttpSession session = httprq.getSession();
        SnapshotsSummaryData tableData = new SnapshotsSummaryData();
        if (this.isChildSupported("FilterMenu") && (domainFilter = SEContainerView.getDomainQuickFilter()) != null) {
            filter = new ContextFilter(1);
            filter.addValue("DOMAIN_NAME", (Object)domainFilter);
        }
        List snapshotList = tableData.getData(filter);
        Iterator it = snapshotList.iterator();
        while (it.hasNext()) {
            SnapShotVolumeEnt1Interface snapshot = (SnapShotVolumeEnt1Interface)it.next();
            if (snapshot == null) {
                Trace.error((Object)((Object)this), (String)"initModelRows", (String)"snapshot is null");
                return;
            }
            this.appendRow();
            this.setRowSelected(false);
            String str_key = KeyBuilder.createStringFromKey((Collection)snapshot.getKey());
            this.setValue(CHILD_HREF, str_key);
            this.setValue(CHILD_HIDDENKEY, str_key);
            this.setValue(CHILD_NAME, snapshot.getName());
            StorageVolumeEnt1Interface parentVolume = snapshot.getParentVolume();
            if (parentVolume != null) {
                this.setValue(CHILD_PARENTVOL, parentVolume.getName());
                String parent_str_key = KeyBuilder.createStringFromKey((Collection)parentVolume.getKey());
                this.setValue(CHILD_HREF_PARENT, parent_str_key);
                this.setValue(CHILD_HIDDEN_PARENTKEY, parent_str_key);
                this.setValue(CHILD_HIDDEN_PARENTNAME, parentVolume.getName());
                this.setValue(CHILD_HIDDEN_PARENTREDUNDANCY, "se6920.volume.redundancy." + parentVolume.getRedundancyType());
            }
            String domainName = snapshot.getStorageDomainName();
            this.setValue(CHILD_DOMAIN, domainName);
            this.setValue(CHILD_HIDDENDOMAIN, domainName);
            this.setValue(CHILD_HIDDENNAME, snapshot.getName());
            this.setValue(CHILD_CREATED, snapshot.getCreationDate());
            this.setValue(CHILD_STATE, "se6920.volume.state." + snapshot.getState());
            if (snapshot.isRollbackInProgress()) {
                this.setValue(CHILD_CONDITION, "se6920.volume.condition.rollback");
            } else {
                this.setValue(CHILD_CONDITION, "se6920.volume.condition." + snapshot.getCondition());
            }
            this.setValue(CHILD_WWN, snapshot.getWwn());
        }
    }
}

