/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.SVSDSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.web.ui.model.CCActionTableModel;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class SVSDSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_TOTAL_CAPACITY = "TotalCapacity";
    public static final String CHILD_ALLOC_CAPACITY = "AllocatedCapacity";
    public static final String CHILD_UNALLOC_CAPACITY = "UnallocatedCapacity";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String CHILD_HIDDENNAME = "HiddenName";
    public static final String DEFAULT_XML = "/jsp/reports/SVSDSummaryTable.xml";

    public SVSDSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public SVSDSummaryModel() {
        this(DEFAULT_XML);
    }

    public void populateData() throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"populateData");
        SVSDSummaryData tableData = new SVSDSummaryData();
        this.clear();
        this.clearModelData();
        List svsdList = tableData.getData();
        boolean i = false;
        Iterator it = svsdList.iterator();
        while (it.hasNext()) {
            this.appendRow();
            this.setRowSelected(false);
            StorageDomainInterface svsd = (StorageDomainInterface)it.next();
            String str_key = KeyBuilder.createStringFromKey((Collection)svsd.getKeys());
            this.setValue(CHILD_HREF, str_key);
            this.setValue(CHILD_HIDDENKEY, str_key);
            BigInteger tcap = svsd.getStorageCapacity();
            BigInteger acap = svsd.getAllocatedCapacity();
            BigInteger ucap = tcap.subtract(acap);
            String name = svsd.getName();
            this.setValue(CHILD_NAME, name);
            this.setValue(CHILD_HIDDENNAME, name);
            this.setValue(CHILD_TOTAL_CAPACITY, SizeConvert.bytesStringToDisplayValue((String)tcap.toString()).toLocalizedString());
            this.setValue(CHILD_ALLOC_CAPACITY, SizeConvert.bytesStringToDisplayValue((String)acap.toString()).toLocalizedString());
            this.setValue(CHILD_UNALLOC_CAPACITY, SizeConvert.bytesStringToDisplayValue((String)ucap.toString()).toLocalizedString());
        }
    }

    private void initHeaders() {
        this.setActionValue("ColName", "svsd.name");
        this.setActionValue("ColTotalCapacity", "svsd.storageCapacity");
        this.setActionValue("ColAllocatedCapacity", "svsd.allocatedCapacity");
        this.setActionValue("ColUnallocatedCapacity", "svsd.unallocatedCapacity");
    }
}

