/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.SRCPortsSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.TooManyCIMInstanceException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.EthernetPortEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.PortEnt1Interface;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class SRCPortsSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_TYPE = "Type";
    public static final String CHILD_STATE = "State";
    public static final String CHILD_REPLICATION = "Replication";
    public static final String CHILD_SPEED = "Speed";
    public static final String CHILD_WWN = "WWN";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String CHILD_HIDDENTYPE = "HiddenType";
    private static final String ENABLED = "se6920.srcport.replication.enabled";
    private static final String DISABLED = "se6920.srcport.replication.disabled";
    public static final String DEFAULT_XML = "/jsp/reports/SRCPortsSummaryTable.xml";

    public SRCPortsSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public SRCPortsSummaryModel() {
        this(DEFAULT_XML);
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.reports.SRCPortsSummary.tableColName");
        this.setActionValue("ColType", "se6920ui.reports.SRCPortsSummary.tableColType");
        this.setActionValue("ColState", "se6920ui.reports.SRCPortsSummary.tableColState");
        this.setActionValue("ColReplication", "se6920ui.reports.SRCPortsSummary.tableColReplication");
        this.setActionValue("ColSpeed", "se6920ui.reports.SRCPortsSummary.tableColSpeed");
        this.setActionValue("ColWWN", "se6920ui.reports.SRCPortsSummary.tableColWWN");
    }

    public void initModelRows() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        SRCPortsSummaryData tableData = new SRCPortsSummaryData();
        List portList = tableData.getData();
        this.clear();
        this.clearModelData();
        String nodeWWN = null;
        int nNodeWWNs = 0;
        Iterator it = portList.iterator();
        while (it.hasNext()) {
            PortEnt1Interface port = (PortEnt1Interface)it.next();
            this.appendRow();
            String str_key = KeyBuilder.createStringFromKey((Collection)port.getKey());
            this.setValue(CHILD_HREF, str_key);
            this.setValue(CHILD_HIDDENKEY, str_key);
            this.setValue(CHILD_NAME, port.getPortName());
            this.setValue(CHILD_TYPE, "se6920.srcport.link.type." + port.getPortStyle());
            this.setValue(CHILD_HIDDENTYPE, "se6920.srcport.link.type." + port.getPortStyle());
            this.setValue(CHILD_REPLICATION, port.isReplicationEnabled() ? ENABLED : DISABLED);
            this.setValue(CHILD_SPEED, "se6920.srcport.speed." + port.getSpeedOperational());
            FiberChannelPortEnt1Interface fcPort = null;
            EthernetPortEnt1Interface gbPort = null;
            if (port.getPortStyle() == 1) {
                fcPort = (FiberChannelPortEnt1Interface)port;
                this.setValue(CHILD_STATE, "se6920.srcport.link.state." + fcPort.getLinkState());
                this.setValue(CHILD_WWN, fcPort.getPortWWN());
                String nWWN = fcPort.getNodeWWN();
                if (nodeWWN != null && nWWN.compareTo(nodeWWN) == 0) continue;
                ++nNodeWWNs;
                nodeWWN = nWWN;
                continue;
            }
            gbPort = (EthernetPortEnt1Interface)port;
            this.setValue(CHILD_STATE, "se6920.srcport.hardware.state." + gbPort.getHardwareState());
            if (gbPort != null && gbPort.isReplicationEnabled()) {
                this.setValue(CHILD_WWN, gbPort.getMACAddress());
                continue;
            }
            this.setValue(CHILD_WWN, "se6920ui.reports.SRCPortsSummary.noreplication");
        }
        if (nNodeWWNs == 1) {
            this.setTitle(UIUtil.getBUIString1Subst((String)"se6920ui.reports.SRCPortsSummary.tableTitleNWWN", nodeWWN));
        }
    }
}

