/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.RepSetDetailsViewBean;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.RepSetsSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationGroupEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationParametersEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationSetEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.alarm.CCAlarmObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class RepSetsSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_REPGROUP = "RepGroup";
    public static final String CHILD_NOREPGROUP = "NoRepGroup";
    public static final String CHILD_HREFGROUP = "HrefGroup";
    public static final String CHILD_MODE = "Mode";
    public static final String CHILD_ROLE = "Role";
    public static final String CHILD_REP_PEER = "RepPeer";
    public static final String CHILD_REMOTE_VOL = "RemoteVolume";
    public static final String CHILD_SYNC_PROGRESS_ICON = "SyncProgressIcon";
    public static final String CHILD_SYNC_PROGRESS = "SyncProgress";
    public static final String CHILD_SYNC_PROGRESS_SORT = "SyncProgressHidden";
    public static final String CHILD_USAGE = "Usage";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String CHILD_HIDDENNAME = "HiddenName";
    public static final String DEFAULT_XML = "/jsp/reports/RepSetsSummaryTable.xml";

    public RepSetsSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public RepSetsSummaryModel() {
        this(DEFAULT_XML);
    }

    public void populateData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        this.clear();
        this.clearModelData();
        RepSetsSummaryData summaryData = new RepSetsSummaryData();
        ArrayList repSetsList = summaryData.getData(filter);
        if (repSetsList != null) {
            Iterator it = repSetsList.iterator();
            while (it.hasNext()) {
                this.appendRow();
                this.setRowSelected(false);
                ReplicationSetEnt1Interface repSet = (ReplicationSetEnt1Interface)it.next();
                String str_key = KeyBuilder.createStringFromKey((Collection)repSet.getKey());
                this.setValue(CHILD_HREF, str_key);
                this.setValue(CHILD_HIDDENKEY, str_key);
                String name = repSet.getName();
                this.setValue(CHILD_NAME, name);
                this.setValue(CHILD_HIDDENNAME, name);
                String repGroupName = "";
                String noRepGroupName = UIUtil.getBUIString((String)"se6920ui.reports.repSetsSummary.RepGroup.none");
                try {
                    ReplicationGroupEnt1Interface repGroup = repSet.getReplicationGroup();
                    if (repGroup != null) {
                        repGroupName = repGroup.getName();
                        noRepGroupName = "";
                        str_key = KeyBuilder.createStringFromKey((Collection)repGroup.getKey());
                        this.setValue(CHILD_HREFGROUP, str_key);
                    }
                }
                catch (ConfigMgmtException cex) {
                    Trace.error((Object)((Object)this), (String)"populateData", (String)"Error retrieving repset group name");
                    Trace.error((Object)((Object)this), (String)"populateData", (ConfigMgmtException)cex);
                    repGroupName = UIUtil.getBUIString((String)"se6920ui.reports.repSetsSummary.RepGroup.error");
                }
                this.setValue(CHILD_REPGROUP, repGroupName);
                this.setValue(CHILD_NOREPGROUP, noRepGroupName);
                this.setValue(CHILD_REP_PEER, repSet.getPeerWwn());
                this.setValue(CHILD_REMOTE_VOL, repSet.getRemoteVolumeWwn());
                int role = 2;
                ReplicationParametersEnt1Interface params = repSet.getReplicationParameters();
                if (params != null) {
                    this.setValue(CHILD_MODE, "se6920ui.reports.repSets.mode." + params.getSyncMode());
                    this.setValue(CHILD_ROLE, "se6920ui.reports.repSets.role." + params.getRole());
                    role = params.getRole();
                }
                int syncState = repSet.getState();
                this.setValue(CHILD_SYNC_PROGRESS, RepSetDetailsViewBean.getRepSetSyncProgress(role, syncState, repSet.getSyncProgress()));
                this.setValue(CHILD_SYNC_PROGRESS_SORT, "se6920ui.reports.repSets.state.hiddensort." + syncState);
                this.setValue(CHILD_SYNC_PROGRESS_ICON, repSet.isErrorStatusOn() ? new CCAlarmObject(2) : new CCAlarmObject(5));
                if (filter == null || filter.getValue("VDISK_KEY") == null && filter.getValue("ARRAY_ARRAYID") == null && filter.getValue("TRAY_TRAYID") == null && filter.getValue("DISK_DISKID") == null) continue;
                this.handleUsageColumn(repSet);
            }
            this.setUsageColumnText(filter);
        }
    }

    private void setUsageColumnText(ContextFilter filter) {
        if (filter == null) {
            this.setActionValue("ColUsage", "se6920ui.reports.repSetsSummary.tableColUsage");
        } else if (filter.getValue("VDISK_KEY") != null) {
            this.setActionValue("ColUsage", "se6920ui.reports.repSetsSummary.tableColUsage.vdisk");
        } else if (filter.getValue("ARRAY_ARRAYID") != null) {
            this.setActionValue("ColUsage", "se6920ui.reports.repSetsSummary.tableColUsage.array");
        } else if (filter.getValue("TRAY_TRAYID") != null) {
            this.setActionValue("ColUsage", "se6920ui.reports.repSetsSummary.tableColUsage.tray");
        } else if (filter.getValue("DISK_DISKID") != null) {
            this.setActionValue("ColUsage", "se6920ui.reports.repSetsSummary.tableColUsage.disk");
        } else {
            this.setActionValue("ColUsage", "se6920ui.reports.repSetsSummary.tableColUsage");
        }
    }

    private void handleUsageColumn(ReplicationSetEnt1Interface repSet) {
        String methodName = "handleUsageColumn";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Set usageList = repSet.getUsageByRepSet();
        StringBuffer buf = new StringBuffer();
        boolean isFirst = true;
        Iterator it = usageList.iterator();
        while (it.hasNext()) {
            String usageStr = (String)it.next();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Usage string = " + usageStr));
            if (!isFirst) {
                buf.append(UIUtil.getBUIString((String)"se6920ui.stringlistdelimiter"));
            }
            buf.append(UIUtil.getBUIString((String)usageStr));
            isFirst = false;
        }
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Setting usage field = " + buf));
        this.setValue(CHILD_USAGE, buf.toString());
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.reports.repSetsSummary.tableColName");
        this.setActionValue("ColRepGroup", "se6920ui.reports.repSetsSummary.tableColRepGroup");
        this.setActionValue("ColMode", "se6920ui.reports.repSetsSummary.tableColMode");
        this.setActionValue("ColRole", "se6920ui.reports.repSetsSummary.tableColRole");
        this.setActionValue("ColRepPeer", "se6920ui.reports.repSetsSummary.tableColRepPeer");
        this.setActionValue("ColRemoteVolume", "se6920ui.reports.repSetsSummary.tableColRemoteVolume");
        this.setActionValue("ColSyncProgress", "se6920ui.reports.repSetsSummary.tableColSyncProgress");
        this.setActionValue("ColUsage", "se6920ui.reports.repSetsSummary.tableColUsage");
    }
}

