/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Collection;

public final class RepSetsSummaryData {
    public ArrayList getData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        ArrayList repSetList = null;
        ConfigContext context = UIUtil.getConfigContext();
        ManageReplicationServicesEnt1Interface repMgr = (ManageReplicationServicesEnt1Interface)ManageDataServicesFactory.getReplicationServicesManager();
        try {
            repMgr.init(context, null, null);
            repSetList = (ArrayList)repMgr.getReplicationSetList();
            if (filter == null) {
                repSetList = (ArrayList)repMgr.getReplicationSetList();
            } else {
                switch (filter.getType()) {
                    case 0: {
                        repSetList = (ArrayList)repMgr.getReplicationSetList();
                        break;
                    }
                    case 5: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems replication sets, filtered to VOLUME: " + (String)filter.getValue("VOLUME_NAME")));
                        repSetList = (ArrayList)repMgr.getReplicationSetListByVolume((Collection)filter.getValue("VOLUME_KEY"));
                        break;
                    }
                    case 9: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting System's replication,sets filtered to ARRAY:TRAY:DISK: " + (String)filter.getValue("DISK_ARRAYID") + ":" + (String)filter.getValue("DISK_TRAYID") + ":" + (String)filter.getValue("DISK_DISKID")));
                        repSetList = (ArrayList)repMgr.getItemsByDisk((String)filter.getValue("DISK_ARRAYID"), (String)filter.getValue("DISK_TRAYID"), Integer.parseInt((String)filter.getValue("DISK_DISKID")));
                        break;
                    }
                    case 8: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting System's volumes, filtered to ARRAY:TRAY: " + (String)filter.getValue("TRAY_ARRAYID") + ":" + (String)filter.getValue("TRAY_TRAYID")));
                        repSetList = (ArrayList)repMgr.getItemsByTray((String)filter.getValue("TRAY_ARRAYID"), (String)filter.getValue("TRAY_TRAYID"));
                        break;
                    }
                    case 4: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems repsets, filtered to VDISK: " + (String)filter.getValue("VDISK_NAME")));
                        repSetList = (ArrayList)repMgr.getItemsByVDisk((String)filter.getValue("VDISK_NAME"));
                        break;
                    }
                    case 7: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting System's replication sets, filtered to ARRAY: " + (String)filter.getValue("ARRAY_ARRAYID")));
                        repSetList = (ArrayList)repMgr.getItemsByArray((String)filter.getValue("ARRAY_ARRAYID"));
                        break;
                    }
                    default: {
                        repSetList = (ArrayList)repMgr.getReplicationSetList();
                    }
                }
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.verbose((Object)this, (String)"getData", (String)"Error getting items from rep set.");
            throw cex;
        }
        return repSetList;
    }
}

