/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.RepSetDetailsViewBean;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationGroupEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationSetEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.alarm.CCAlarmObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class RepGrpSubReportsModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "RepSetHref";
    public static final String CHILD_REPSET_NAME = "repSetName";
    public static final String CHILD_LOCALVOLUME_NAME = "localVolumeName";
    public static final String CHILD_REMOTEVOLUME_NAME = "remoteVolumeName";
    public static final String CHILD_SYNCPROGRESS_ICON = "syncProgressIcon";
    public static final String CHILD_SYNCPROGRESS_NAME = "syncProgressName";
    public static final String CHILD_SYNCPROGRESS_SORT = "syncProgressSort";
    public static final String DEFAULT_XML = "/jsp/reports/RepGrpRepSetsTable.xml";
    private String domainName = null;

    public RepGrpSubReportsModel() {
        super(RequestManager.getRequestContext().getServletContext(), DEFAULT_XML);
        this.initHeaders();
    }

    public void initModelRows(ReplicationGroupEnt1Interface repGrp) throws ConfigMgmtException {
        this.clear();
        this.clearModelData();
        List repSets = null;
        try {
            repSets = repGrp.getReplicationSets();
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)((Object)this), (String)"initModelRows", (String)"Unable to retreive rep sets from rep group");
        }
        int role = repGrp.getRole();
        Iterator it = repSets.iterator();
        while (it.hasNext()) {
            this.appendRow();
            this.setRowSelected(false);
            ReplicationSetEnt1Interface repSet = (ReplicationSetEnt1Interface)it.next();
            this.setValue(CHILD_REPSET_NAME, repSet.getName());
            this.setValue(CHILD_HREF, KeyBuilder.createStringFromKey((Collection)repSet.getKey()));
            this.setValue(CHILD_REMOTEVOLUME_NAME, repSet.getRemoteVolumeWwn());
            int syncState = repSet.getState();
            this.setValue(CHILD_SYNCPROGRESS_NAME, RepSetDetailsViewBean.getRepSetSyncProgress(role, syncState, repSet.getSyncProgress()));
            this.setValue(CHILD_SYNCPROGRESS_SORT, "se6920ui.reports.repSets.state.hiddensort." + syncState);
            this.setValue(CHILD_SYNCPROGRESS_ICON, repSet.isErrorStatusOn() ? new CCAlarmObject(2) : new CCAlarmObject(5));
            if (this.domainName != null) continue;
            StorageVolumeInterface localVol = repSet.getLocalVolume();
            this.domainName = localVol.getStorageDomainName();
        }
    }

    private void initHeaders() {
        this.setActionValue("colRepSetName", "se6920ui.reports.repSetsSummary.tableColName");
        this.setActionValue("colRemoteVolumeName", "se6920ui.reports.repSetsSummary.tableColRemoteVolume");
        this.setActionValue("colSyncProgressName", "se6920ui.reports.repSetsSummary.tableColSyncProgress");
    }

    public String getDomainName() {
        return this.domainName;
    }
}

