/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.ProfilesSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.bui.wizards.common.SEWizardModel;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.NewStorageFilter;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;

public final class ProfilesSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_STATE = "State";
    public static final String CHILD_TYPE = "Type";
    public static final String CHILD_RAIDLEVEL = "RaidLevel";
    public static final String CHILD_SEGSIZE = "SegSize";
    public static final String CHILD_READAHEAD = "ReadAhead";
    public static final String CHILD_NUMDRIVES = "NumberOfDrives";
    public static final String CHILD_ARRAYTYPE = "ArrayType";
    public static final String CHILD_DEDICATEDHOTSPARE = "DedicatedHotSpare";
    public static final String CHILD_VIRTSTRATEGY = "VirtStrategy";
    public static final String CHILD_STRIPESIZE = "StripeSize";
    public static final String CHILD_DESCRIPTION = "Description";
    public static final String CHILD_STORAGE_AVAILABLE = "StorageAvailable";
    public static final String CHILD_HIDDENNAME = "HiddenName";
    public static final String CHILD_HIDDENINUSE = "HiddenInuse";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String CHILD_HIDDEN_STORAGE_AVAILABLE_KEY = "HiddenStorageAvailableKey";
    public static final String DEFAULT_XML = "/jsp/reports/ProfilesSummaryTable.xml";
    private SEWizardModel createPoolWizardModel;
    private List t4List;
    private HashMap key_profile;

    public ProfilesSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public ProfilesSummaryModel() {
        this(DEFAULT_XML);
    }

    public void setCreatePoolWizardModel(SEWizardModel wizardModel) {
        this.createPoolWizardModel = wizardModel;
    }

    public void initModelRows() throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"initModelRows");
        this.clear();
        this.clearModelData();
        if (this.createPoolWizardModel == null) {
            this.loadForProfilesSummary();
        } else {
            this.loadForCreatePoolWizard();
        }
    }

    private void loadForProfilesSummary() throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"loadForProfilesSummary");
        List profileList = null;
        ProfilesSummaryData tableData = new ProfilesSummaryData();
        profileList = tableData.getData();
        Trace.verbose((Object)((Object)this), (String)"loadForProfilesSummary", (String)"Got Profile summary data");
        int size = profileList.size();
        for (int i = 0; i < size; ++i) {
            StorageProfileInterface profile = (StorageProfileInterface)profileList.get(i);
            String str_key = KeyBuilder.createStringFromKey((Collection)profile.getKey());
            this.commonLoad(str_key, profile);
            this.setValue(CHILD_HREF, str_key);
            boolean inUse = profile.isInUse();
            this.setValue(CHILD_STATE, inUse ? "se6920.profile.inusestate.1" : "se6920.profile.inusestate.0");
            this.setValue(CHILD_HIDDENINUSE, Boolean.toString(inUse));
            this.setValue(CHILD_TYPE, profile.isFactoryProfile() ? "se6920.profile.type.factory" : "se6920.profile.type.user");
            int vStrategy = profile.getVirtualizationStrategy();
            this.setValue(CHILD_VIRTSTRATEGY, "se6920.profile.virtstrategy." + vStrategy);
            if (vStrategy != 2) {
                this.setValue(CHILD_RAIDLEVEL, "se6920.profile.raidlevel." + profile.getRAIDLevel());
                this.setValue(CHILD_SEGSIZE, "se6920.profile.segmentsize." + profile.getSegmentSize());
                this.setValue(CHILD_READAHEAD, profile.isReadAheadEnabled() ? "se6920.profile.readahead.true" : "se6920.profile.readahead.false");
                this.setValue(CHILD_NUMDRIVES, "se6920.profile.numberofdrives." + profile.getNumberOfDisks());
                this.setValue(CHILD_ARRAYTYPE, "se6920.profile.arraytype." + profile.getArrayType());
                this.setValue(CHILD_DEDICATEDHOTSPARE, profile.dedicatedSpareExists() ? "se6920.profile.dedicatedspare.true" : "se6920.profile.dedicatedspare.false");
                this.setValue(CHILD_STRIPESIZE, "se6920.profile.stripesize." + profile.getStripeSize());
                continue;
            }
            String na = UIUtil.getBUIString((String)"se6920ui.notapplicable");
            this.setValue(CHILD_RAIDLEVEL, na);
            this.setValue(CHILD_SEGSIZE, na);
            this.setValue(CHILD_READAHEAD, na);
            this.setValue(CHILD_NUMDRIVES, na);
            this.setValue(CHILD_ARRAYTYPE, na);
            this.setValue(CHILD_DEDICATEDHOTSPARE, na);
            this.setValue(CHILD_STRIPESIZE, na);
        }
    }

    private void loadForCreatePoolWizard() throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"loadForCreatePoolWizard");
        HttpSession session = RequestManager.getSession();
        this.t4List = (List)session.getAttribute("PP");
        Trace.verbose((Object)((Object)this), (String)"loadForCreatePoolWizard", (String)("[Bob] session t4array contains: " + (this.t4List == null ? "nothing" : "something")));
        if (this.t4List != null) {
            this.createPoolWizardModel.setValue("WIZARD_T4S_HANDLE", (Object)this.t4List);
        } else {
            this.t4List = (List)this.createPoolWizardModel.getValue("WIZARD_T4S_HANDLE");
        }
        this.key_profile = (HashMap)this.createPoolWizardModel.getValue("WIZARD_M_KEY_PROF");
        ConfigContext context = UIUtil.getConfigContext();
        NewStorageFilter storageFilter = new NewStorageFilter(context, this.t4List);
        if (this.t4List == null) {
            this.t4List = storageFilter.getLoadedArrays();
            this.createPoolWizardModel.setValue("WIZARD_T4S_HANDLE", (Object)this.t4List);
            Trace.verbose((Object)((Object)this), (String)"loadForCreatePoolWizard", (String)"Storing t4 first time");
        }
        if (this.key_profile == null) {
            this.key_profile = new HashMap();
            List profileList = null;
            ProfilesSummaryData tableData = new ProfilesSummaryData();
            profileList = tableData.getData();
            Trace.verbose((Object)((Object)this), (String)"loadForCreatePoolWizard", (String)"Got Profile summary data");
            int size = profileList.size();
            for (int i = 0; i < size; ++i) {
                StorageProfileInterface profile = (StorageProfileInterface)profileList.get(i);
                String str_key = KeyBuilder.createStringFromKey((Collection)profile.getKey());
                this.commonLoad(str_key, profile);
                int maxNumDisks = storageFilter.getMaxDisksForProfile(profile);
                this.setValue(CHILD_STORAGE_AVAILABLE, maxNumDisks != 0 ? "se6920ui.bui.profile.summary.yes" : "se6920ui.bui.profile.summary.none");
                this.setValue(CHILD_HIDDEN_STORAGE_AVAILABLE_KEY, Integer.toString(maxNumDisks));
                this.setValue(CHILD_DESCRIPTION, profile.getDescription());
                this.key_profile.put(str_key, profile);
            }
            if (this.createPoolWizardModel != null) {
                this.createPoolWizardModel.setValue("WIZARD_M_KEY_PROF", (Object)this.key_profile);
            }
        } else {
            Trace.verbose((Object)((Object)this), (String)"loadForCreatePoolWizard", (String)"Loading from Map");
            Set keys = this.key_profile.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String str_key = (String)it.next();
                StorageProfileInterface profile = (StorageProfileInterface)this.key_profile.get(str_key);
                int maxNumDisks = storageFilter.getMaxDisksForProfile(profile);
                this.commonLoad(str_key, profile);
                this.setValue(CHILD_STORAGE_AVAILABLE, maxNumDisks != 0 ? "se6920ui.bui.profile.summary.yes" : "se6920ui.bui.profile.summary.none");
                this.setValue(CHILD_HIDDEN_STORAGE_AVAILABLE_KEY, Integer.toString(maxNumDisks));
                this.setValue(CHILD_DESCRIPTION, profile.getDescription());
            }
        }
    }

    private void commonLoad(String str_key, StorageProfileInterface profile) {
        this.appendRow();
        this.setRowSelected(false);
        String name = profile.getName();
        this.setValue(CHILD_NAME, name);
        this.setValue(CHILD_HIDDENKEY, str_key);
        this.setValue(CHILD_HIDDENNAME, name);
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.reports.profilesSummary.tableColname");
        this.setActionValue("ColState", "se6920ui.reports.profilesSummary.tableColstate");
        this.setActionValue("ColType", "se6920ui.reports.profilesSummary.tableColtype");
        this.setActionValue("ColRaidLevel", "se6920ui.reports.profilesSummary.tableColraidlevel");
        this.setActionValue("ColSegSize", "se6920ui.reports.profilesSummary.tableColsegsize");
        this.setActionValue("ColReadAhead", "se6920ui.reports.profilesSummary.tableColreadahead");
        this.setActionValue("ColNumberOfDrives", "se6920ui.reports.profilesSummary.tableColnumberofdrives");
        this.setActionValue("ColArrayType", "se6920ui.reports.profilesSummary.tableColarraytype");
        this.setActionValue("ColDedicatedHotSpare", "se6920ui.reports.profilesSummary.tableColdedicatedhotspare");
        this.setActionValue("ColVirtStrategy", "se6920ui.reports.profilesSummary.tableColvirtstrategy");
        this.setActionValue("ColStripeSize", "se6920ui.reports.profilesSummary.tableColstripesize");
        this.setActionValue("ColDescription", "se6920ui.reports.profilesSummary.tableColDescription");
        this.setActionValue("ColStorageAvailable", "se6920ui.reports.profilesSummary.tableColStorageAvailable");
    }
}

