/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.MirrorComponentsData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;

public final class MirrorComponentsModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "ComponentHref";
    public static final String CHILD_NAME = "ComponentName";
    public static final String CHILD_STATE = "ComponentState";
    public static final String CHILD_CONDITION = "ComponentCondition";
    public static final String CHILD_POOL = "ComponentPool";
    public static final String CHILD_PCTRESILVERED = "ComponentPctResilvered";
    public static final String CHILD_SPLIT = "ComponentSplit";
    public static final String CHILD_CAPACITY = "ComponentCapacity";
    public static final String CHILD_HIDDENKEY = "HiddenComponentKey";
    public static final String CHILD_HIDDENNAME = "HiddenComponentName";
    public static final String CHILD_HIDDENSPLIT = "HiddenSplitValue";
    public static final String CHILD_HIDDENSNAPHOST = "HiddenSnapComponent";
    public static final String CHILD_HIDDENRESILVER = "HiddenResilveringValue";
    public static final String CHILD_CAN_SPLIT = "HiddenCanSplit";
    public static final String CHILD_CAN_REJOIN = "HiddenCanRejoin";
    public static final String CHILD_CAN_REV_REJOIN = "HiddenCanRevRejoin";
    public static final String CHILD_CAN_BREAK = "HiddenCanBreak";
    public static final String CHILD_CAN_FORCE_BREAK = "HiddenCanForceBreak";
    public static final String DEFAULT_XML = "/jsp/reports/MirrorComponentsTable.xml";
    private boolean foundLegacyVolume = false;
    private boolean foundSplitComponent = false;
    private static final String ourResBundle = "com.sun.netstorage.array.mgmt.cfg.bui.resources.Resources";

    public MirrorComponentsModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public MirrorComponentsModel() {
        this(DEFAULT_XML);
    }

    public void initModelRows(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        ArrayList<Integer> intactComponents = new ArrayList<Integer>();
        this.clear();
        this.clearModelData();
        MirrorComponentsData componentsData = new MirrorComponentsData();
        ArrayList componentsList = componentsData.getData(key);
        int numberOfComponents = componentsList.size();
        Iterator it = componentsList.iterator();
        while (it.hasNext()) {
            this.appendRow();
            this.setRowSelected(false);
            MirrorComponentEnt1Interface volume = (MirrorComponentEnt1Interface)it.next();
            String str_key = KeyBuilder.createStringFromKey((Collection)volume.getKey());
            this.setValue(CHILD_HREF, str_key);
            this.setValue(CHILD_HIDDENKEY, str_key);
            String volumeType = volume.getType();
            if (volumeType != null && volumeType.equals("Legacy")) {
                this.foundLegacyVolume = true;
            }
            boolean componentSplit = false;
            if (volume.isSplit()) {
                this.setValue(CHILD_SPLIT, "se6920.label.yes");
                this.foundSplitComponent = true;
                componentSplit = true;
            } else {
                this.setValue(CHILD_SPLIT, "se6920.label.no");
            }
            int pctResilvered = volume.getResilverProgress();
            this.setValue(CHILD_PCTRESILVERED, String.valueOf(pctResilvered) + "%");
            boolean componentResilvering = false;
            boolean componentSnapShotHost = false;
            boolean componentLastIntact = false;
            boolean componentDegraded = false;
            boolean componentMapped = false;
            try {
                SortedSet conditions = volume.getConditionInfo();
                componentResilvering = conditions.contains(new Integer(15));
                componentSnapShotHost = volume.isSnapComponent();
                componentDegraded = conditions.contains(new Integer(1));
                componentMapped = volume.getState() == 6;
            }
            catch (ClassCastException cce) {
                Trace.error((Object)((Object)this), (String)"MirrorComponentsModel: ClassCastException", (Throwable)cce);
            }
            catch (NullPointerException npe) {
                Trace.error((Object)((Object)this), (String)"MirrorComponentsModel: NullPointer", (Throwable)npe);
            }
            if (!(componentSplit || componentResilvering || componentDegraded)) {
                intactComponents.add(new Integer(this.getRowIndex()));
            }
            if (componentResilvering || componentSplit || componentSnapShotHost || componentDegraded) {
                this.setValue(CHILD_CAN_SPLIT, "F");
            } else {
                this.setValue(CHILD_CAN_SPLIT, "T");
            }
            if (componentSplit && !componentMapped && !componentDegraded) {
                this.setValue(CHILD_CAN_REJOIN, "T");
            } else {
                this.setValue(CHILD_CAN_REJOIN, "F");
            }
            if (componentSplit && !componentMapped && !componentDegraded) {
                this.setValue(CHILD_CAN_REV_REJOIN, "T");
            } else {
                this.setValue(CHILD_CAN_REV_REJOIN, "F");
            }
            if (componentResilvering || componentSnapShotHost || componentDegraded) {
                this.setValue(CHILD_CAN_BREAK, "F");
            } else {
                this.setValue(CHILD_CAN_BREAK, "T");
            }
            if (componentSnapShotHost) {
                this.setValue(CHILD_CAN_FORCE_BREAK, "F");
            } else {
                this.setValue(CHILD_CAN_FORCE_BREAK, "T");
            }
            this.setValue(CHILD_NAME, volume.getName());
            this.setValue(CHILD_HIDDENNAME, volume.getName());
            this.setValue(CHILD_STATE, "se6920.volume.state." + volume.getState());
            this.setValue(CHILD_POOL, volume.getStoragePoolName());
            this.setValue(CHILD_CAPACITY, SizeConvert.bytesStringToDisplayValue((String)volume.getSize().toString()).toString());
            String conditionsString = UIUtil.ConstantListToStringList((String)ourResBundle, (String)"se6920.volume.condition.", (Set)volume.getConditionInfo(), (String)"se6920ui.stringlistdelimiter");
            if (componentSnapShotHost) {
                conditionsString = conditionsString + UIUtil.getBUIString((String)"se6920ui.stringlistdelimiter") + UIUtil.getBUIString((String)"se6920.volume.condition.snapshotHost");
            }
            this.setValue(CHILD_CONDITION, conditionsString);
        }
        this.initClientSideRules(intactComponents, numberOfComponents);
    }

    private void initClientSideRules(ArrayList intactComponents, int numberOfComponents) {
        if (intactComponents.size() == 1) {
            int intactComponentRow = (Integer)intactComponents.get(0);
            try {
                this.first();
                for (int i = 0; i < this.getNumRows(); ++i) {
                    if (i == intactComponentRow) {
                        this.setValue(CHILD_CAN_SPLIT, "F");
                        if (numberOfComponents == 1) {
                            this.setValue(CHILD_CAN_BREAK, "T");
                            this.setValue(CHILD_CAN_FORCE_BREAK, "T");
                        } else {
                            this.setValue(CHILD_CAN_BREAK, "F");
                            this.setValue(CHILD_CAN_FORCE_BREAK, "F");
                        }
                    }
                    this.next();
                }
            }
            catch (ModelControlException mce) {
                return;
            }
        }
    }

    public boolean hasLegacyVolume() {
        return this.foundLegacyVolume;
    }

    public boolean hasSplitComponent() {
        return this.foundSplitComponent;
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.reports.volumesSummary.tableColName");
        this.setActionValue("ColState", "se6920ui.reports.volumesSummary.tableColState");
        this.setActionValue("ColCondition", "se6920ui.reports.volumesSummary.tableColCondition");
        this.setActionValue("ColPool", "se6920ui.reports.volumesSummary.tableColPool");
        this.setActionValue("ColPctResilvered", "se6920ui.reports.mirrorComponent.tableColPctResilvered");
        this.setActionValue("ColSplit", "se6920ui.reports.mirrorComponent.tableColSplit");
        this.setActionValue("ColCapacity", "se6920ui.reports.volumesSummary.tableColCapacity");
    }
}

