/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.InitiatorsSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEContainerView;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class InitiatorsSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_OSTYPE = "OSType";
    public static final String CHILD_DOMAIN = "Domain";
    public static final String CHILD_STATE = "State";
    public static final String CHILD_STATUS = "Status";
    public static final String CHILD_WWN = "WWN";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String CHILD_HIDDENNAME = "HiddenName";
    public static final String CHILD_HIDDENDOMAIN = "HiddenDomain";
    public static final String DEFAULT_XML = "/jsp/reports/InitiatorsSummaryTable.xml";

    public InitiatorsSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public InitiatorsSummaryModel() {
        this(DEFAULT_XML);
    }

    public void initModelRows(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        String domainFilter;
        this.clear();
        this.clearModelData();
        InitiatorsSummaryData tableData = new InitiatorsSummaryData();
        if (this.isChildSupported("FilterMenu") && (domainFilter = SEContainerView.getDomainQuickFilter()) != null) {
            filter = new ContextFilter(1);
            filter.addValue("DOMAIN_NAME", (Object)domainFilter);
        }
        ArrayList initiatorList = tableData.getData(filter);
        Iterator it = initiatorList.iterator();
        while (it.hasNext()) {
            this.appendRow();
            this.setRowSelected(false);
            InitiatorInterface initiator = (InitiatorInterface)it.next();
            String str_key = KeyBuilder.createStringFromKey((Collection)initiator.getKey());
            this.setValue(CHILD_HREF, str_key);
            this.setValue(CHILD_HIDDENKEY, str_key);
            String name = initiator.getName();
            this.setValue(CHILD_NAME, name);
            this.setValue(CHILD_HIDDENNAME, name);
            this.setValue(CHILD_OSTYPE, "se6920.initiator.ostype." + initiator.getOSType());
            String domainName = initiator.getStorageDomain();
            this.setValue(CHILD_DOMAIN, domainName);
            this.setValue(CHILD_HIDDENDOMAIN, domainName);
            this.setValue(CHILD_STATE, "se6920.initiator.state." + initiator.getState());
            this.setValue(CHILD_STATUS, "se6920.initiator.status." + initiator.getStatus());
            this.setValue(CHILD_WWN, initiator.getWWN());
        }
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.reports.initiatorsSummary.tableColName");
        this.setActionValue("ColOSType", "se6920ui.reports.initiatorsSummary.tableColOSType");
        this.setActionValue("ColDomain", "se6920ui.reports.initiatorsSummary.tableColDomain");
        this.setActionValue("ColState", "se6920ui.reports.initiatorsSummary.tableColState");
        this.setActionValue("ColStatus", "se6920ui.reports.initiatorsSummary.tableColStatus");
        this.setActionValue("ColWWN", "se6920ui.reports.initiatorsSummary.tableColWWN");
    }
}

