/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class InitiatorsSummaryData {
    public ArrayList getData(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        ArrayList initiatorList = null;
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        ManageInitiatorsInterface mgr = ManageInitiatorsFactory.getManager();
        HttpSession session = httprq.getSession();
        ConfigContext cfgctx = (ConfigContext)session.getAttribute("ConfigContext");
        try {
            mgr.init(cfgctx, null);
            if (filter == null) {
                initiatorList = mgr.getItemsBySystem();
            } else {
                switch (filter.getType()) {
                    case 0: {
                        initiatorList = mgr.getItemsBySystem();
                        break;
                    }
                    case 1: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems initiators, filtered to DOMAIN: " + (String)filter.getValue("DOMAIN_NAME")));
                        initiatorList = mgr.getItemsByStorageDomain((String)filter.getValue("DOMAIN_NAME"));
                        break;
                    }
                    case 11: {
                        Trace.verbose((Object)this, (String)"getData", (String)"Getting systems unmapped initiators");
                        initiatorList = mgr.getItemsBySystem();
                        InitiatorsSummaryData.removeMappedInitiators(initiatorList);
                        break;
                    }
                    case 6: {
                        Trace.verbose((Object)this, (String)"getData", (String)("Getting systems initiators, filtered to FCPORT: " + (String)filter.getValue("FCPORT_NAME")));
                        initiatorList = mgr.getItemsByFCPort((String)filter.getValue("FCPORT_NAME"));
                        break;
                    }
                    default: {
                        initiatorList = mgr.getItemsBySystem();
                    }
                }
            }
        }
        catch (ConfigMgmtException cex) {
            Trace.verbose((Object)this, (String)"getData", (String)"Error getting items from volume.");
            throw cex;
        }
        catch (ItemNotFoundException iex) {
            Trace.verbose((Object)this, (String)"getData", (String)"Error getting filter context.");
            throw iex;
        }
        Trace.verbose((Object)this, (String)"getData", (String)("Returning initiator list, size: " + initiatorList.size()));
        return initiatorList;
    }

    private static void removeMappedInitiators(ArrayList initiatorList) {
        InitiatorInterface initiator = null;
        Iterator it = initiatorList.iterator();
        while (it.hasNext()) {
            initiator = (InitiatorInterface)it.next();
            if (initiator.getState() != 1) continue;
            it.remove();
        }
    }
}

