/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.ExternalStorageSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.KeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEContainerView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageArrayEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ExternalStorageSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_POOL = "Pool";
    public static final String CHILD_CAPACITY = "Capacity";
    public static final String CHILD_WWN = "WWN";
    public static final String CHILD_MODEL = "Model";
    public static final String CHILD_ARRAY = "Array";
    public static final String CHILD_VENDOR = "Vendor";
    public static final String CHILD_STATUS = "Status";
    public static final String CHILD_LEGACY_VOL = "Legacy";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String CHILD_HIDDENNAME = "HiddenName";
    public static final String CHILD_NO_LEGACY = "NoLegacy";
    public static final String CHILD_HIDDEN_VOLUMEKEY = "HiddenVolumeKey";
    public static final String NO_STORAGE_POOL = "se6920.bui.storage.pool.unassigned";
    public static final String NO_LEGACY_VOL = "se6920ui.reports.externalStorageSummary.noLegacyVolumeName";
    public static final String DEFAULT_XML = "/jsp/reports/ExternalStorageSummaryTable.xml";
    private LinkedList selections = null;

    public ExternalStorageSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public ExternalStorageSummaryModel(String xmlFile, LinkedList externalStorageList) {
        this(xmlFile);
        this.selections = externalStorageList;
    }

    public ExternalStorageSummaryModel() {
        this(DEFAULT_XML);
    }

    public void initModelRows(ContextFilter filter) throws ConfigMgmtException, ItemNotFoundException {
        this.clear();
        this.clearModelData();
        boolean isCreate = false;
        List externalStorageList = new ArrayList();
        if (this.selections != null) {
            externalStorageList = this.selections;
            isCreate = true;
        } else {
            String domainFilter;
            ExternalStorageSummaryData summaryData = new ExternalStorageSummaryData();
            if (this.isChildSupported("FilterMenu") && (domainFilter = SEContainerView.getDomainQuickFilter()) != null) {
                filter = new ContextFilter(1);
                filter.addValue("DOMAIN_NAME", (Object)domainFilter);
            }
            externalStorageList = summaryData.getData(filter);
        }
        Iterator it = externalStorageList.iterator();
        while (it.hasNext()) {
            this.appendRow();
            this.setRowSelected(false);
            VDiskEnt1Interface vdisk = (VDiskEnt1Interface)it.next();
            String str_key = KeyBuilder.createStringFromKey((Collection)vdisk.getKeyAsCollection());
            this.setValue(CHILD_HIDDENKEY, str_key);
            String name = vdisk.getName();
            if (isCreate) {
                name = UIUtil.getBUIString((String)"se6x20ui.wizards.pool.AddExternalStorage.lvname.prefix") + name.substring(4);
                name = name.replaceAll("/", "_");
            }
            this.setValue(CHILD_NAME, name);
            this.setValue(CHILD_HIDDENNAME, name);
            this.setValue(CHILD_MODEL, vdisk.getModel());
            String arrayName = null;
            try {
                StorageArrayEnt1Interface array = vdisk.getArrayController();
                arrayName = array.getName();
            }
            catch (ConfigMgmtException cme) {
                arrayName = "se6920ui.bui.notavailable";
                Trace.error((Object)((Object)this), (String)"initModelRows", (String)"Error getting VDisk's Array name...");
                Trace.error((Object)((Object)this), (String)"initModelRows", (ConfigMgmtException)cme);
            }
            this.setValue(CHILD_ARRAY, arrayName);
            this.setValue(CHILD_VENDOR, vdisk.getVendor());
            this.setValue(CHILD_STATUS, "se6920.vdisk.status." + vdisk.getStatus());
            this.setValue(CHILD_CAPACITY, SizeConvert.bytesStringToDisplayValue((String)vdisk.getTotalCapacity().toString()).toLocalizedString());
            this.setValue(CHILD_WWN, vdisk.getWWN());
            String poolName = vdisk.getStoragePoolName();
            StorageVolumeInterface asvi = vdisk.getAssociatedVLV();
            if ((poolName == null || poolName.equals("")) && asvi == null) {
                this.setSelectionVisible(true);
            } else {
                this.setSelectionVisible(false);
            }
            poolName = !poolName.equals("") ? poolName : NO_STORAGE_POOL;
            this.setValue(CHILD_POOL, poolName);
            if (null != asvi) {
                this.setValue(CHILD_NO_LEGACY, "");
                this.setValue(CHILD_LEGACY_VOL, asvi.getName());
                this.setValue(CHILD_HREF, KeyBuilder.createStringFromKey((Collection)asvi.getKey()));
                this.setValue(CHILD_HIDDEN_VOLUMEKEY, KeyBuilder.createStringFromKey((Collection)asvi.getKey()));
                continue;
            }
            this.setValue(CHILD_NO_LEGACY, NO_LEGACY_VOL);
            this.setValue(CHILD_LEGACY_VOL, "");
            this.setValue(CHILD_HREF, "");
            this.setValue(CHILD_HIDDEN_VOLUMEKEY, "");
        }
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.reports.externalStorageSummary.tableColName");
        this.setActionValue("ColArray", "se6920ui.reports.externalStorageSummary.tableColArray");
        this.setActionValue("ColVendor", "se6920ui.reports.externalStorageSummary.tableColVendor");
        this.setActionValue("ColModel", "se6920ui.reports.externalStorageSummary.tableColModel");
        this.setActionValue("ColStatus", "se6920ui.bui.vdisks.summary.tableColStatus");
        this.setActionValue("ColPool", "se6920ui.reports.externalStorageSummary.tableColPool");
        this.setActionValue("ColLegacyVolume", "se6920ui.reports.externalStorageSummary.tableColLegacyVolume");
        this.setActionValue("ColCapacity", "se6920ui.reports.externalStorageSummary.tableColCapacity");
        this.setActionValue("ColWWN", "se6920ui.reports.externalStorageSummary.tableColWWN");
    }
}

