/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.DisksSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DisksSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_ARRAY = "Array";
    public static final String CHILD_TRAY = "Tray";
    public static final String CHILD_ROLE = "Role";
    public static final String CHILD_STATE = "State";
    public static final String CHILD_STATUS = "Status";
    public static final String CHILD_CAPACITY = "Capacity";
    public static final String DEFAULT_XML = "/jsp/reports/DisksSummaryTable.xml";
    public static final String SEP_TAG = "|";

    public DisksSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public DisksSummaryModel() {
        this(DEFAULT_XML);
    }

    public void initModelRows(ContextFilter filter) throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"initModelRows");
        this.clear();
        this.clearModelData();
        DisksSummaryData disksData = new DisksSummaryData();
        List disksList = disksData.getData(filter);
        Iterator disks_it = disksList.iterator();
        while (disks_it.hasNext()) {
            ArrayList list = (ArrayList)disks_it.next();
            DiskInterface disk = (DiskInterface)list.get(0);
            String t4Name = (String)list.get(1);
            this.appendRow();
            int trayId = disk.getTrayId();
            this.setValue(CHILD_HREF, disk.getSlotNumber() + SEP_TAG + trayId + SEP_TAG + t4Name);
            this.setValue(CHILD_NAME, disk.getName());
            this.setValue(CHILD_TRAY, Integer.toString(trayId));
            this.setValue(CHILD_ARRAY, t4Name);
            this.setValue(CHILD_ROLE, "se6920.disk.role." + disk.getRole());
            this.setValue(CHILD_STATE, "se6920.disk.state." + disk.getState());
            this.setValue(CHILD_STATUS, "se6920.disk.status." + disk.getStatus());
            this.setValue(CHILD_CAPACITY, SizeConvert.bytesStringToDisplayValue((String)disk.getCapacity().toString()).toLocalizedString());
        }
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.bui.disks.summary.tableColName");
        this.setActionValue("ColArray", "se6920ui.bui.disks.summary.tableColArray");
        this.setActionValue("ColTray", "se6920ui.bui.disks.summary.tableColTray");
        this.setActionValue("ColRole", "se6920ui.bui.disks.summary.tableColRole");
        this.setActionValue("ColState", "se6920ui.bui.disks.summary.tableColState");
        this.setActionValue("ColStatus", "se6920ui.bui.disks.summary.tableColStatus");
        this.setActionValue("ColCapacity", "se6920ui.bui.disks.summary.tableColCapacity");
    }
}

