/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.ContextFilter;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class DisksSummaryData {
    private ConfigContext cfgctx;

    public List getData(ContextFilter filter) throws ConfigMgmtException {
        Trace.methodBegin((Object)this, (String)"getData");
        ArrayList dataList = null;
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        ManageDisksInterface mngDisks = ManageDisksFactory.getManager();
        if (mngDisks == null) {
            Trace.error((Object)this, (String)"getData", (String)"ManageDisksInterface is null");
            return dataList;
        }
        HttpSession session = httprq.getSession();
        this.cfgctx = (ConfigContext)session.getAttribute("ConfigContext");
        if (filter == null) {
            dataList = this.getAll();
        } else {
            switch (filter.getType()) {
                case 7: {
                    Trace.verbose((Object)this, (String)"getData", (String)("Getting systems disks, filtered to ARRAY: " + (String)filter.getValue("ARRAY_ARRAYID")));
                    String t4Name = (String)filter.getValue("ARRAY_ARRAYID");
                    dataList = this.getByArrayTray(mngDisks, t4Name, null);
                    break;
                }
                case 8: {
                    Trace.verbose((Object)this, (String)"getData", (String)("Getting systems disks, filtered to TRAYID: " + (String)filter.getValue("TRAY_TRAYID")));
                    Trace.verbose((Object)this, (String)"getData", (String)("                               of ARRAYID: " + (String)filter.getValue("TRAY_ARRAYID")));
                    String trayId = (String)filter.getValue("TRAY_TRAYID");
                    String t4Name = (String)filter.getValue("TRAY_ARRAYID");
                    dataList = this.getByArrayTray(mngDisks, t4Name, trayId);
                    break;
                }
                case 4: {
                    Trace.verbose((Object)this, (String)"getData", (String)("Getting system vdisk, filtered to VDISK: " + (String)filter.getValue("VDISK_NAME")));
                    dataList = this.getByVDisk((String)filter.getValue("VDISK_NAME"));
                    break;
                }
                default: {
                    dataList = this.getAll();
                }
            }
        }
        Trace.verbose((Object)this, (String)"getData", (String)("Returning disk list, size: " + dataList.size()));
        return dataList;
    }

    private ArrayList getAll() throws ConfigMgmtException {
        ArrayList list = new ArrayList();
        Trace.verbose((Object)this, (String)"getData", (String)"Scope by All arrays: ");
        ManageT4sInterface mngT4s = ManageT4sFactory.getManager();
        mngT4s.init(this.cfgctx, null);
        List arraysList = mngT4s.getItemList();
        Iterator array_it = arraysList.iterator();
        while (array_it.hasNext()) {
            T4Interface t4 = (T4Interface)array_it.next();
            List traysList = t4.getTrays();
            Iterator tray_it = traysList.iterator();
            while (tray_it.hasNext()) {
                TrayInterface tray = (TrayInterface)tray_it.next();
                List disksList = tray.getDiskList();
                Iterator disk_it = disksList.iterator();
                while (disk_it.hasNext()) {
                    ArrayList<Object> l = new ArrayList<Object>(2);
                    DiskInterface disk = (DiskInterface)disk_it.next();
                    l.add(0, disk);
                    l.add(1, t4.getName());
                    list.add(l);
                }
            }
        }
        return list;
    }

    private ArrayList getByArrayTray(ManageDisksInterface mngDisks, String arName, String trayId) throws ConfigMgmtException {
        ArrayList list = new ArrayList();
        T4Interface scope = null;
        if (arName != null) {
            T4Interface t4;
            Trace.verbose((Object)this, (String)"getDataByArrayTray", (String)("Scope by array: " + arName));
            ManageT4sInterface mngT4s = ManageT4sFactory.getManager();
            mngT4s.init(this.cfgctx, null);
            scope = t4 = mngT4s.getT4ByName(arName);
            if (trayId != null) {
                ManageTraysInterface mngTrays = ManageTraysFactory.getManager();
                mngTrays.setScope((InstanceWrapper)t4);
                mngTrays.init(this.cfgctx, null);
                List trays = mngTrays.getItemList();
                boolean found = false;
                TrayInterface tray = null;
                Iterator it = trays.iterator();
                while (it.hasNext() && !found) {
                    tray = (TrayInterface)it.next();
                    if (!tray.getId().equals(trayId)) continue;
                    found = true;
                }
                if (found) {
                    Trace.verbose((Object)this, (String)"getData", (String)("Scope by Tray: " + trayId));
                    scope = tray;
                }
            }
            mngDisks.setScope((InstanceWrapper)scope);
            mngDisks.init(this.cfgctx, null);
            List disks = mngDisks.getItemList();
            Iterator it = disks.iterator();
            while (it.hasNext()) {
                ArrayList<Object> l = new ArrayList<Object>(2);
                DiskInterface disk = (DiskInterface)it.next();
                l.add(0, disk);
                l.add(1, arName);
                list.add(l);
            }
        }
        return list;
    }

    private ArrayList getByVDisk(String vdiskName) throws ConfigMgmtException {
        ArrayList list = new ArrayList();
        ManageVDisksInterface mgr = ManageVDisksFactory.getManager();
        mgr.init(this.cfgctx, null);
        VDiskEnt1Interface vdisk = (VDiskEnt1Interface)mgr.getItemByName(vdiskName);
        ArrayList[] arr_disks = vdisk.getAssociatedDisks();
        int size = arr_disks[0].size();
        for (int i = 0; i < size; ++i) {
            ArrayList<Object> l = new ArrayList<Object>(2);
            DiskInterface disk = (DiskInterface)arr_disks[0].get(i);
            l.add(0, disk);
            l.add(1, arr_disks[1].get(0));
            list.add(l);
        }
        return list;
    }
}

