/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.reports.ArraysSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.Iterator;
import java.util.List;

public final class ArraysSummaryModel
extends CCActionTableModel {
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_COLUMN = "Col";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_HEALTH = "Health";
    public static final String CHILD_HOTSPARE = "HotSpare";
    public static final String CHILD_SEGMENTSIZE = "SegmentSize";
    public static final String CHILD_READAHEAD = "ReadAhead";
    public static final String CHILD_HIDDENKEY = "HiddenKey";
    public static final String DEFAULT_XML = "/jsp/reports/ArraysSummaryTable.xml";

    public ArraysSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public ArraysSummaryModel() {
        this(DEFAULT_XML);
    }

    public void initModelRows() throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"initModelRows");
        ArraysSummaryData arraysData = new ArraysSummaryData();
        this.clear();
        this.clearModelData();
        List list = arraysData.getData();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.appendRow();
            this.setRowSelected(false);
            T4Interface t4 = (T4Interface)it.next();
            this.setValue(CHILD_HIDDENKEY, t4.getName());
            String name = t4.getName();
            this.setValue(CHILD_HREF, name);
            this.setValue(CHILD_NAME, name);
            int t4Status = t4.getHealthStatus();
            this.setValue(CHILD_HEALTH, "se6920.arrays.status." + t4Status);
            if (t4Status == 2) {
                this.setValue(CHILD_NAME, name);
                this.setValue(CHILD_HOTSPARE, Integer.toString(t4.getAhsPoolSize()));
                this.setValue(CHILD_SEGMENTSIZE, SizeConvert.bytesStringToDisplayValue((String)Integer.toString(t4.getBlockSize())).toLocalizedString());
                int readahead = t4.getReadaheadMode();
                String str_readahead = "";
                switch (readahead) {
                    case 0: {
                        str_readahead = "On";
                        break;
                    }
                    case 2: {
                        str_readahead = "Off";
                        break;
                    }
                    case 1: {
                        str_readahead = "Off";
                        break;
                    }
                    default: {
                        str_readahead = Integer.toString(readahead);
                    }
                }
                this.setValue(CHILD_READAHEAD, "se6920.arrays.readAhead." + str_readahead);
                continue;
            }
            this.setValue(CHILD_HOTSPARE, "se6920ui.bui.notavailable");
            this.setValue(CHILD_SEGMENTSIZE, "se6920ui.bui.notavailable");
            this.setValue(CHILD_READAHEAD, "se6920ui.bui.notavailable");
        }
    }

    private void initHeaders() {
        this.setActionValue("ColName", "se6920ui.bui.arrays.summary.tableColName");
        this.setActionValue("ColHealth", "se6920ui.bui.arrays.summary.tableColHealth");
        this.setActionValue("ColHotSpare", "se6920ui.bui.arrays.summary.tableColHotSpare");
        this.setActionValue("ColSegmentSize", "se6920ui.bui.arrays.summary.tableColSegmentSize");
        this.setActionValue("ColReadAhead", "se6920ui.bui.arrays.summary.tableColReadAhead");
    }
}

