/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.reports;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SESubReportsModel;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.TooManyCIMInstanceException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.List;

public final class ArraySubReportsModel
extends SESubReportsModel {
    private int nDisks = -1;
    private int nTrays = -1;
    private int nVDisks = -1;

    public void initModelRows(Object obj) throws ConfigMgmtException {
        this.clear();
        T4Interface t4 = (T4Interface)obj;
        try {
            this.getTrays_Disks(t4);
        }
        catch (ConfigMgmtException cex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (String)"ConfigMgmtException getting # Tray and/or # Disks");
        }
        this.addItem("se6920ui.bui.array.details.subreport.row.trays", this.nTrays);
        this.addItem("se6920ui.bui.array.details.subreport.row.disks", this.nDisks);
        try {
            this.getVDisks(t4);
            this.addItem("se6920ui.bui.array.details.subreport.row.vdisks", this.nVDisks);
            this.addItem("se6920ui.bui.array.details.subreport.row.volumes", this.haveVolumes(t4) ? "se6920ui.bui.generic.details.subreport.many" : "0");
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (String)"ConfigMgmtException getting #Volumes and/or # VDisks");
            this.addItem("se6920ui.bui.array.details.subreport.row.vdisks", this.nVDisks);
            this.addItem("se6920ui.bui.array.details.subreport.row.volumes", -1);
        }
        catch (ItemNotFoundException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (Throwable)ex);
            this.addItem("se6920ui.bui.array.details.subreport.row.vdisks", this.nVDisks);
            this.addItem("se6920ui.bui.array.details.subreport.row.volumes", -1);
        }
        try {
            this.addItem("se6920ui.bui.array.details.subreport.row.repsets", this.haveRepSets(t4) ? "se6920ui.bui.generic.details.subreport.many" : "0");
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (String)"ConfigMgmtException getting # RepSets");
            this.addItem("se6920ui.bui.array.details.subreport.row.repsets", -1);
        }
        catch (ItemNotFoundException ex) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (Throwable)ex);
            this.addItem("se6920ui.bui.array.details.subreport.row.repsets", -1);
        }
    }

    private boolean haveVolumes(T4Interface t4) throws ConfigMgmtException, ItemNotFoundException {
        ManageStorageVolumesInterface msv = ManageStorageVolumesFactory.getManager();
        msv.init(UIUtil.getConfigContext(), null);
        ManageStorageVolumes mgr = (ManageStorageVolumes)msv;
        return mgr.doesArrayHaveVolumes(t4.getName());
    }

    private void getVDisks(T4Interface t4) throws ConfigMgmtException, ItemNotFoundException {
        ManageVDisksInterface mv = ManageVDisksFactory.getManager();
        mv.init(UIUtil.getConfigContext(), null);
        Trace.verbose((Object)((Object)this), (String)"getNumVDisks", (String)("Getting vdisks for Array: " + t4.getName()));
        ArrayList vdisks = mv.getItemsByArray(t4.getName());
        this.nVDisks = vdisks.size();
    }

    private void getTrays_Disks(T4Interface t4) throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        int size;
        List list = t4.getTrays();
        this.nTrays = size = list.size();
        this.nDisks = 0;
        for (int i = 0; i < size; ++i) {
            TrayInterface tray = (TrayInterface)list.get(i);
            this.nDisks += tray.getNumberOfDrives();
        }
        Trace.verbose((Object)((Object)this), (String)"getNumDisks", (String)("Got # trays: " + this.nTrays));
        Trace.verbose((Object)((Object)this), (String)"getNumDisks", (String)("Got # disks: " + this.nDisks));
    }

    private boolean haveRepSets(T4Interface t4) throws ConfigMgmtException, ItemNotFoundException {
        ManageReplicationServicesEnt1Interface repMgr = (ManageReplicationServicesEnt1Interface)ManageDataServicesFactory.getReplicationServicesManager();
        repMgr.init(UIUtil.getConfigContext(), null, null);
        return repMgr.doesArrayHaveRepSets(t4.getName());
    }
}

