/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.jobs;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.jobs.JobsHistoricalSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class JobsHistoricalSummaryModel
extends CCActionTableModel {
    public static final String DEFAULT_XML = "/jsp/jobs/JobsHistoricalSummaryTable.xml";
    public static final String CHILD_ID = "idData";
    public static final String CHILD_HIDDENID = "hiddenJobId";
    public static final String CHILD_DESCRIPTION = "descriptionData";
    public static final String CHILD_ENDTIME = "endTimeData";
    public static final String CHILD_STATUS = "statusData";

    public JobsHistoricalSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public JobsHistoricalSummaryModel() {
        this(DEFAULT_XML);
    }

    private void initHeaders() {
        this.setActionValue("CancelButton", "se6920ui.jobs.historical.summary.button");
        this.setActionValue("id", "se6920ui.jobs.summary.job.id");
        this.setActionValue("description", "se6920ui.jobs.summary.job.description");
        this.setActionValue("endTime", "se6920ui.jobs.summary.job.endtime");
        this.setActionValue("elapsedTime", "se6920ui.jobs.summary.job.elapsedtime");
        this.setActionValue("status", "se6920ui.jobs.summary.job.status");
    }

    public void initModelRows() throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"initModelRows");
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        HttpSession session = httprq.getSession();
        ConfigContext cfgctx = (ConfigContext)session.getAttribute("ConfigContext");
        JobsHistoricalSummaryData tableData = new JobsHistoricalSummaryData();
        this.clear();
        this.clearModelData();
        JobManagerInterface jobManIF = JobManagerFactory.create();
        try {
            jobManIF.init(cfgctx, null);
            jobManIF.setShowAllJobs(false);
            List jobList = jobManIF.getCompletedList();
            int numJobs = jobList.size();
            for (int i = 0; i < numJobs; ++i) {
                this.appendRow();
                this.setRowSelected(false);
                JobInterface jobIF = (JobInterface)jobList.get(i);
                String id = jobIF.getId();
                this.setValue(CHILD_ID, id);
                this.setValue(CHILD_HIDDENID, id);
                boolean UIJob = jobIF.isUIJob();
                if (UIJob) {
                    this.setValue(CHILD_DESCRIPTION, jobIF.getDescription());
                } else if (jobIF.getDescription().indexOf("CreatingVdisksBadDiskError") != -1) {
                    String diskInfo = jobIF.getDescription().substring(jobIF.getDescription().indexOf(":") + 1);
                    this.setValue(CHILD_DESCRIPTION, UIUtil.getBUIString1Subst((String)"se6920.job.description.CreatingVdisksBadDiskError", (String)diskInfo));
                } else {
                    this.setValue(CHILD_DESCRIPTION, UIUtil.getBUIString((String)("se6920.job.description." + jobIF.getDescription())));
                }
                Date endTime = jobIF.getEndTime();
                this.setValue(CHILD_ENDTIME, endTime);
                if (UIJob) {
                    int nErrors = jobIF.getTaskFailureCount();
                    String statusKey = null;
                    statusKey = jobIF.isActive() ? (nErrors == 1 ? "se6920ui.jobs.runningerror" : "se6920ui.jobs.runningerrors") : (nErrors == 1 ? "se6920ui.jobs.completeerror" : "se6920ui.jobs.completeerrors");
                    this.setValue(CHILD_STATUS, UIUtil.getBUIString1Subst((String)statusKey, (String)Integer.toString(nErrors)));
                    continue;
                }
                this.setValue(CHILD_STATUS, jobIF.isActive() ? UIUtil.getBUIString((String)"se6920ui.jobs.running") : UIUtil.getBUIString((String)("se6920.jobs.status." + jobIF.getJobStatus())));
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (String)"Error retrieving job information.");
            throw cme;
        }
    }
}

