/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.jobs;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.jobs.JobsCurrentSummaryData;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.Date;
import java.util.List;

public final class JobsCurrentSummaryModel
extends CCActionTableModel {
    public static final String DEFAULT_XML = "/jsp/jobs/JobsSummaryTable.xml";
    public static final String CHILD_ID = "idData";
    public static final String CHILD_HIDDENID = "hiddenJobId";
    public static final String CHILD_DESCRIPTION = "descriptionData";
    public static final String CHILD_STARTTIME = "startTimeData";
    public static final String CHILD_ELAPSEDTIME = "elapsedTimeData";
    public static final String CHILD_PERCENTCOMPLETE = "percentCompleteData";
    public static final String CHILD_REMAININGTIME = "remainingTimeData";

    public JobsCurrentSummaryModel(String xmlFile) {
        super(RequestManager.getRequestContext().getServletContext(), xmlFile);
        this.initHeaders();
    }

    public JobsCurrentSummaryModel() {
        this(DEFAULT_XML);
    }

    private void initHeaders() {
        this.setActionValue("CancelButton", "se6920ui.jobs.current.summary.button");
        this.setActionValue("id", "se6920ui.jobs.summary.job.id");
        this.setActionValue("description", "se6920ui.jobs.summary.job.description");
        this.setActionValue("startTime", "se6920ui.jobs.summary.job.starttime");
        this.setActionValue("elapsedTime", "se6920ui.jobs.summary.job.elapsedtime");
        this.setActionValue("percentComplete", "se6920ui.jobs.summary.job.percentcomplete");
        this.setActionValue("remainingTime", "se6920ui.jobs.summary.job.remainingTime");
    }

    public void initModelRows() throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"initModelRows");
        ConfigContext cfgctx = UIUtil.getConfigContext();
        RequestContext rq = RequestManager.getRequestContext();
        JobsCurrentSummaryData tableData = new JobsCurrentSummaryData();
        this.clear();
        this.clearModelData();
        JobManagerInterface jobManIF = JobManagerFactory.create();
        List jobList = null;
        try {
            jobManIF.init(cfgctx, null);
            jobManIF.setShowAllJobs(false);
            jobList = jobManIF.getItemList();
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (String)"initModelRows", (String)"Error retrieving job information.");
            throw cme;
        }
        int numJobs = jobList.size();
        for (int i = 0; i < numJobs; ++i) {
            this.appendRow();
            this.setRowSelected(false);
            JobInterface jobIF = (JobInterface)jobList.get(i);
            String id = jobIF.getId();
            this.setValue(CHILD_ID, id);
            this.setValue(CHILD_HIDDENID, id);
            boolean UIJob = jobIF.isUIJob();
            if (UIJob) {
                this.setValue(CHILD_DESCRIPTION, jobIF.getDescription());
            } else if (jobIF.getDescription().indexOf("CreatingVdisksBadDiskError") != -1) {
                String diskInfo = jobIF.getDescription().substring(jobIF.getDescription().indexOf(":") + 1);
                this.setValue(CHILD_DESCRIPTION, UIUtil.getBUIString1Subst((String)"se6920.job.description.CreatingVdisksBadDiskError", (String)diskInfo));
            } else {
                this.setValue(CHILD_DESCRIPTION, UIUtil.getBUIString((String)("se6920.job.description." + jobIF.getDescription())));
            }
            Date startTime = jobIF.getStartTime();
            Date endTime = jobIF.getEndTime();
            this.setValue(CHILD_STARTTIME, startTime);
            this.setValue(CHILD_ELAPSEDTIME, UIUtil.getElapsedTime((Date)startTime, (Date)endTime, (String)"se6920.jobs.elapsedtime"));
            this.setValue(CHILD_PERCENTCOMPLETE, UIUtil.getBUIString1Subst((String)"se6920ui.jobs.current.summary.percentcomplete", (String)Integer.toString(jobIF.getPercentComplete())));
            this.setValue(CHILD_REMAININGTIME, UIUtil.getTimeRemaining((Date)startTime, (Date)endTime, (int)jobIF.getPercentComplete(), (String)"se6920.jobs.elapsedtime"));
        }
    }
}

