/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.admin;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.array.mgmt.cfg.admin.business.FirewallAdminFactory;
import com.sun.netstorage.array.mgmt.cfg.admin.business.FirewallAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.FirewallRuleInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.admin.PortFilteringModel;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.CoreViewBean;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEAlertComponent;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEContainerView;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SEViewBeanBase;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PortFilteringView
extends SEContainerView {
    private PortFilteringModel actionTableModel = new PortFilteringModel("/jsp/admin/PortFilteringPropertyTable.xml");
    private static final String DEFAULT_TABLE_NAME = "PortFilteringTable";
    public static final String BUTTON_OPEN = "ButtonOpen";
    public static final String BUTTON_CLOSE = "ButtonClose";
    boolean userFlag = true;

    public PortFilteringView(View parent, String name) {
        super(parent, name, DEFAULT_TABLE_NAME, "/jsp/admin/PortFilteringPropertyTable.xml");
        if (UIUtil.isReadWrite(((Object)((Object)this)).getClass())) {
            this.userFlag = false;
        }
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren((CCActionTableModel)this.actionTableModel);
    }

    public View createChild(String name) {
        if (name.equals(this.childActionTable)) {
            if (this.userFlag) {
                this.actionTableModel.setSelectionType("none");
            } else {
                this.actionTableModel.setSelectionType("multiple");
            }
            try {
                this.actionTableModel.initModelRows();
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)((Object)this), (String)"createChild, portModel.initModelRows(...)", (String)("Failed: " + cex.getMessage()));
            }
            CCActionTable child = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.actionTableModel, name);
            return child;
        }
        if (name.equals(BUTTON_OPEN) || name.equals(BUTTON_CLOSE)) {
            CCButton child = (CCButton)this.actionTableModel.createChild((View)this, name);
            child.setDisabled(this.userFlag);
            return child;
        }
        View view = super.createChild((CCActionTableModel)this.actionTableModel, name);
        return view;
    }

    public void populateData() throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"populateData");
        this.actionTableModel.initModelRows();
    }

    public void handleButtonOpenRequest(RequestInvocationEvent event) {
        Trace.methodBegin((Object)((Object)this), (String)"handleButtonOpenRequest");
        this.setPortState(true);
    }

    public void handleButtonCloseRequest(RequestInvocationEvent event) {
        Trace.methodBegin((Object)((Object)this), (String)"handleButtonCloseRequest");
        this.setPortState(false);
    }

    private void setPortState(boolean state) {
        Integer[] selectedRows;
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        HttpSession session = httprq.getSession();
        ConfigContext cfgctx = (ConfigContext)session.getAttribute("ConfigContext");
        SEViewBeanBase vb = (SEViewBeanBase)this.getParentViewBean();
        List portList = null;
        CCActionTable child = (CCActionTable)this.getChild(this.childActionTable);
        try {
            child.restoreStateData();
            portList = ((PortFilteringModel)child.getModel()).getPortList();
        }
        catch (ModelControlException mce) {
            Trace.error((Object)((Object)this), (String)"setPortState", (Throwable)mce);
            SEAlertComponent.error((CoreViewBean)vb, (String)"se6920ui.error.admin.portFiltering.portState", (Exception)((Object)mce));
            vb.forwardTo(this.getRequestContext());
            return;
        }
        if (portList == null) {
            Trace.verbose((Object)((Object)this), (String)"setPortState", (String)"WARNING: Port list not found from table! Instantiating....");
            FirewallAdminInterface firewallAdminInterface = FirewallAdminFactory.create(null);
            try {
                firewallAdminInterface.init(cfgctx, null);
                portList = firewallAdminInterface.getItemList();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)((Object)this), (String)"setPortState", (ConfigMgmtException)cme);
                SEAlertComponent.error((CoreViewBean)vb, (String)"se6920ui.error.admin.portFiltering.portState", (Exception)((Object)cme));
                vb.forwardTo(this.getRequestContext());
                return;
            }
        }
        if ((selectedRows = this.actionTableModel.getSelectedRows()).length == 0) {
            Trace.error((Object)((Object)this), (String)"setPortState", (String)"No Ports Selected");
            SEAlertComponent.error((CoreViewBean)vb, (String)"se6920ui.error.admin.portFiltering.portState", (String)"se6x20ui.wizards.pool.CreatePoolSummaryPage.noneSelected");
            vb.forwardTo(this.getRequestContext());
            return;
        }
        Trace.verbose((Object)((Object)this), (String)"SetPortState", (String)("[" + selectedRows.length + "] rows were selected"));
        for (int i = 0; i < selectedRows.length; ++i) {
            FirewallRuleInterface filter = (FirewallRuleInterface)portList.get(selectedRows[i]);
            filter.setOpen(state);
            try {
                filter.save();
                continue;
            }
            catch (ConfigMgmtException e) {
                Trace.error((Object)((Object)this), (String)"SetPortState", (ConfigMgmtException)e);
                SEAlertComponent.error((CoreViewBean)vb, (String)"se6920ui.error.admin.portFiltering.portState", (Exception)((Object)e));
                vb.forwardTo(this.getRequestContext());
                return;
            }
        }
        SEAlertComponent.info((CoreViewBean)vb, (String)"se6920ui.admin.portFiltering.success.portSettings", (String)"");
        vb.forwardTo(this.getRequestContext());
    }

    public void beginDisplay(DisplayEvent arg0) throws ModelControlException {
        super.beginDisplay(arg0);
    }

    public List getSummaryData(Scope scope, SearchFilter filter) throws ConfigMgmtException {
        return null;
    }

    protected String getChildTiledViewName() {
        return null;
    }
}

