/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.admin;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.UIUtil;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.license.License;
import com.sun.netstorage.array.mgmt.cfg.license.LicenseManagerFactory;
import com.sun.web.ui.model.CCActionTableModel;
import java.text.DateFormat;
import java.text.NumberFormat;

public final class LicenseSummaryModel
extends CCActionTableModel {
    public static final String DEFAULT_XML = "/jsp/admin/LicenseSummaryTable.xml";
    private DateFormat df = DateFormat.getDateInstance(2);
    private NumberFormat nf = NumberFormat.getInstance();

    public LicenseSummaryModel() {
        super(RequestManager.getRequestContext().getServletContext(), DEFAULT_XML);
        String[] cols = new String[]{"Feature", "Amount", "LicenseId", "SystemId", "Expiration", "Version", "Actions"};
        for (int i = 0; i < cols.length; ++i) {
            this.setActionValue("Col" + cols[i], "se6920ui.licenseSummary.col" + cols[i]);
        }
    }

    public void initModelRows(String featureType) {
        this.clearModelData();
        Trace.verbose((Object)((Object)this), (String)"initModelRows", (String)"initModelRows");
        this.nf.setMinimumIntegerDigits(20);
        License[] la = LicenseManagerFactory.getManager((ConfigContext)UIUtil.getConfigContext()).getLicenses();
        for (int j = 0; j < la.length; ++j) {
            License l = la[j];
            if (!featureType.equals(l.getFeatureName())) continue;
            this.appendRow();
            this.setValue("Feature", "se6920ui.licensing.feature." + l.getFeatureName() + ".label");
            if (l.getAmount() == Long.MAX_VALUE) {
                this.setValue("Amount", "se6920ui.admin.lfs.unlimited");
                this.setValue("AmountHidden", this.nf.format(Long.MAX_VALUE));
            } else {
                this.setValue("Amount", SizeConvert.bytesStringToDisplayValue((String)("" + l.getAmount())).toLocalizedString());
                this.setValue("AmountHidden", this.nf.format(l.getAmount()));
            }
            this.setValue("LicenseId", l.toString());
            this.setValue("LicenseIdHidden", this.nf.format(l.getLicenseId()));
            this.setValue("SystemId", l.getSystemId());
            if (l.getExpiration() == null) {
                this.setValue("Expiration", UIUtil.getBUIString((String)"se6920ui.admin.license.expiration.never"));
                this.setValue("ExpirationHidden", this.nf.format(0L));
            } else {
                this.setValue("Expiration", this.df.format(l.getExpiration()));
                this.setValue("ExpirationHidden", this.nf.format(l.getExpiration().getTime()));
            }
            this.setValue("Version", "" + l.getVersion());
            this.setValue("HiddenKey", l.toString());
            this.setValue("DeleteActionText", "se6920ui.licenseSummary.actionDelete");
            this.setValue("DeleteAction", new Integer(this.getRowIndex()));
        }
    }
}

