/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.bui.admin;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.SizeConvert;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.license.License;
import com.sun.netstorage.array.mgmt.cfg.license.LicenseManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.license.LicenseManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.license.Summary;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.alarm.CCAlarmObject;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class FeatureSummaryModel
extends CCActionTableModel {
    public static final String DEFAULT_XML = "/jsp/admin/FeatureSummaryTable.xml";

    public FeatureSummaryModel() {
        super(RequestManager.getRequestContext().getServletContext(), DEFAULT_XML);
        this.setActionValue("ColFeature", "se6920ui.admin.lfs.ColFeature");
        this.setActionValue("ColKeyCount", "se6920ui.admin.lfs.ColKeyCount");
        this.setActionValue("ColAmountLicensed", "se6920ui.admin.lfs.ColAmountLicensed");
        this.setActionValue("ColAmountInUse", "se6920ui.admin.lfs.ColAmountInUse");
        this.setActionValue("ColInCompliance", "se6920ui.admin.lfs.ColInCompliance");
    }

    public void initModelRows() {
        this.clear();
        this.clearModelData();
        RequestContext rq = RequestManager.getRequestContext();
        HttpServletRequest httprq = rq.getRequest();
        HttpSession session = httprq.getSession();
        ConfigContext cfgctx = (ConfigContext)session.getAttribute("ConfigContext");
        HashMap<String, Integer> lc = new HashMap<String, Integer>();
        LicenseManagerInterface licenseMgr = LicenseManagerFactory.getManager((ConfigContext)cfgctx);
        License[] l = licenseMgr.getLicenses();
        for (int i = 0; i < l.length; ++i) {
            Integer c = (Integer)lc.get(l[i].getFeatureName());
            if (c == null) {
                c = new Integer(0);
            }
            c = new Integer(c + 1);
            lc.put(l[i].getFeatureName(), c);
        }
        long GIGABYTE = 0x40000000L;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        Summary[] s = licenseMgr.getSummary();
        for (int i = 0; i < s.length; ++i) {
            this.appendRow();
            this.setValue("FeatureHref", s[i].getFeatureName());
            this.setValue("Feature", "se6920ui.licensing.feature." + s[i].getFeatureName() + ".label");
            if (lc.get(s[i].getFeatureName()) == null) {
                this.setValue("KeyCount", new Integer(0));
                this.setValue("AmountLicensed", "se6920ui.admin.lfs.none");
                this.setValue("AmountLicensedHidden", "0");
            } else {
                this.setValue("KeyCount", lc.get(s[i].getFeatureName()));
                if (s[i].getAmountLicensed() == Long.MAX_VALUE) {
                    this.setValue("AmountLicensed", "se6920ui.admin.lfs.unlimited");
                    this.setValue("AmountLicensedHidden", nf.format(Long.MAX_VALUE));
                } else {
                    this.setValue("AmountLicensed", SizeConvert.bytesStringToDisplayValue((String)("" + s[i].getAmountLicensed())).toLocalizedString());
                    this.setValue("AmountLicensedHidden", nf.format(s[i].getAmountLicensed()));
                }
            }
            long amountInUse = s[i].getAmountInUse();
            this.setValue("AmountInUseHidden", nf.format(s[i].getAmountInUse()));
            this.setValue("AmountInUse", SizeConvert.bytesStringToDisplayValue((String)("" + s[i].getAmountInUse())).toLocalizedString());
            if (s[i].getAmountLicensed() >= s[i].getAmountInUse()) {
                this.setValue("InComplianceIcon", this.getAlarm(true));
                this.setValue("InCompliance", "se6920ui.licensing.compliance.yes.label");
                this.setValue("InComplianceHidden", "1");
                continue;
            }
            this.setValue("InComplianceIcon", this.getAlarm(false));
            this.setValue("InCompliance", "se6920ui.licensing.compliance.no.label");
            this.setValue("InComplianceHidden", "0");
        }
    }

    protected CCAlarmObject getAlarm(boolean fInCompliance) {
        CCAlarmObject alarm = new CCAlarmObject(5);
        if (fInCompliance) {
            return alarm;
        }
        alarm = new CCAlarmObject(2);
        return alarm;
    }
}

