/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.util;

import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.StorageJobStatus;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.StorageJobType;
import com.sun.netstorage.array.mgmt.cfg.util.MessageResources;
import com.sun.netstorage.array.mgmt.cfg.util.Size;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Convert
implements Constants.StorageSize {
    public static String KEY_SEPARATOR = "<NL>";
    public static String KEY_NAME_VAL_SEPARATOR = "==";
    private static final Map PERMISSION_MAP = new HashMap();
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$util$Convert;

    public static Date stringToDateTime(String dateString, TimeZone zone, int stylePattern, Locale userLocale) throws ParseException {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "stringToDate");
        DateFormat df = DateFormat.getDateTimeInstance(stylePattern, stylePattern, userLocale);
        df.setTimeZone(zone);
        return df.parse(dateString);
    }

    public static String dateTimeToString(Date date, TimeZone zone, int stylePattern, Locale userLocale) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "dateToString");
        DateFormat df = DateFormat.getDateTimeInstance(stylePattern, stylePattern, userLocale);
        df.setTimeZone(zone);
        return df.format(date);
    }

    public static String dateTimeToLocalString(Date date, Locale locale) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "dateToString");
        DateFormat df = DateFormat.getDateTimeInstance(1, 1, locale);
        return df.format(date);
    }

    public static String timeToString(Date time, TimeZone zone, int stylePattern, Locale userLocale) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "dateToString");
        DateFormat df = DateFormat.getTimeInstance(stylePattern, userLocale);
        df.setTimeZone(zone);
        return df.format(time);
    }

    public static String longSecToDateString(Long secondsSince1970, Locale loc) {
        if (secondsSince1970 == null || secondsSince1970.intValue() == 0) {
            return "-";
        }
        return Convert.dateTimeToLocalString(new Date(secondsSince1970 * 1000L), loc);
    }

    public static Date stringToTime(String timeString, TimeZone zone, int stylePattern, Locale userLocale) throws ParseException {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "stringToDate");
        DateFormat df = DateFormat.getTimeInstance(stylePattern, userLocale);
        if (zone != null) {
            df.setTimeZone(zone);
        }
        return df.parse(timeString);
    }

    public static Date fieldsToDateTime(String year, String month, String date, String timeString, int stylePattern, Locale userLocale, TimeZone zone) throws ParseException {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "stringFieldsToDateTime");
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        if (zone != null) {
            calendar.setTimeZone(zone);
        }
        Date time = Convert.stringToTime(timeString, zone, stylePattern, userLocale);
        calendar.setTime(time);
        int yearInt = Integer.parseInt(year);
        int monthInt = Integer.parseInt(month) - 1;
        int dateInt = Integer.parseInt(date);
        calendar.set(yearInt, monthInt, dateInt);
        return calendar.getTime();
    }

    public static String bytesToGB(BigInteger bytes) {
        String size = "";
        try {
            if (bytes != null) {
                size = Convert.bytesStringToGB(bytes.toString());
            }
        }
        catch (Exception ae) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "Exception trying to convert bytes to GB", (Throwable)ae);
        }
        return size;
    }

    public static String bytesStringToGB(String bytes) {
        String size = "";
        try {
            BigDecimal bdSize = new BigDecimal(bytes);
            bdSize = bdSize.setScale(2, 1);
            bdSize = bdSize.divide(Constants.StorageSize.ONE_GB, 1);
            size = bdSize.toString();
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "bytesStringToGB", "Returning gb conversion string = " + size);
        }
        catch (ArithmeticException ae) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "Exception trying to convert bytes to GB", (Throwable)ae);
        }
        return size;
    }

    public static String bytesStringToMBOrGB(String bytes) {
        String methodName = "bytesStringToMBOrGB";
        String size = "";
        try {
            BigDecimal bdSize = new BigDecimal(bytes);
            bdSize = bdSize.setScale(2, 0);
            if (bdSize.compareTo(Constants.StorageSize.ONE_GB) == -1) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "Given bytes size is less than 1 GB; convert to MB!");
                bdSize = bdSize.divide(Constants.StorageSize.ONE_MB, 0);
            } else {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "Given bytes size is greater than 1 GB; convert to GB!");
                bdSize = bdSize.divide(Constants.StorageSize.ONE_GB, 0);
            }
            size = bdSize.toString();
            if (size != null && size.indexOf(".") < 0) {
                size = size + ".00";
            }
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "Returning conversion string = " + size);
        }
        catch (ArithmeticException ae) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "Exception trying to convert bytes to MB or GB", (Throwable)ae);
        }
        return size;
    }

    public static String getMBOrGBString(String bytes) {
        String methodName = "getMBOrGBString";
        try {
            BigDecimal bdSize = new BigDecimal(bytes);
            bdSize = bdSize.setScale(2, 0);
            if (bdSize.compareTo(Constants.StorageSize.ONE_GB) == -1) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "Given bytes size is less than 1 GB; return  MB!");
                return "MB";
            }
        }
        catch (Exception ae) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "Exception trying to get MB or GB string", (Throwable)ae);
        }
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "Given bytes size is greater than 1 GB; return  GB!");
        return "GB";
    }

    public static BigInteger MBStringToBytes(String megabytes) throws NumberFormatException {
        String methodName = "MBStringToBytes";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName);
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "Trying to convert MB string to bytes; string = " + megabytes);
        BigDecimal bdSize = new BigDecimal(megabytes);
        bdSize = bdSize.setScale(2, 0);
        bdSize = bdSize.multiply(Constants.StorageSize.ONE_MB);
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "big decimal bytes = " + bdSize.toString());
        BigInteger bi = bdSize.toBigInteger();
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "BD converted to BI = " + bi.toString());
        return bi;
    }

    public static BigInteger GBStringToBytes(String gigabytes) throws NumberFormatException {
        String methodName = "GBStringToBytes";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName);
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "Trying to convert GB string to bytes; string = " + gigabytes);
        BigDecimal bdSize = new BigDecimal(gigabytes);
        bdSize = bdSize.setScale(2, 1);
        bdSize = bdSize.multiply(Constants.StorageSize.ONE_GB);
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "big decimal bytes = " + bdSize.toString());
        BigInteger bi = bdSize.toBigInteger();
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "BD converted to BI = " + bi.toString());
        return bi;
    }

    public static String formatSize(Locale locale, BigInteger size, MessageResources messages) {
        String convertedSize = "0";
        if (size == null) {
            return "0.0";
        }
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setMinimumFractionDigits(2);
        try {
            convertedSize = nf.format(nf.parse(Convert.bytesStringToMBOrGB(size.toString())));
        }
        catch (Exception e) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "formatSize", (Throwable)e);
        }
        String unit = messages.getMessage(locale, "size." + Convert.getMBOrGBString(size.toString()));
        return convertedSize + unit;
    }

    public static int[] stringArrayToIntArray(String[] strings) {
        if (null == strings) {
            return null;
        }
        int[] intArray = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            intArray[i] = Integer.parseInt(strings[i]);
        }
        return intArray;
    }

    public static String[] intArrayToStringArray(int[] ints) {
        if (null == ints) {
            return null;
        }
        String[] stringArray = new String[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            stringArray[i] = Integer.toString(ints[i]);
        }
        return stringArray;
    }

    public static String arrayToCommaString(String[] array) {
        StringBuffer str = new StringBuffer("");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (i == 0) {
                    str.append(array[i]);
                    continue;
                }
                str.append(",").append(array[i]);
            }
        }
        return str.toString();
    }

    public static String[] commaStringToArray(String cStr) {
        String[] array = new String[]{};
        if (cStr != null) {
            StringTokenizer st = new StringTokenizer(cStr, ",");
            array = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                array[i++] = st.nextToken();
            }
        }
        return array;
    }

    public static String cleanUpAndUpcase(String stringIn) {
        stringIn = stringIn.trim();
        return stringIn.toUpperCase();
    }

    public static synchronized String bytesToString(byte[] data) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                sbuf.append(":".charAt(0));
            }
            sbuf.append(Convert.toHex(data[i], 2));
        }
        return sbuf.toString().toUpperCase();
    }

    public static synchronized String bytesToStringRaw(byte[] data) {
        StringBuffer sbuf = new StringBuffer("");
        int size = data == null ? 0 : data.length;
        for (int i = 0; i < size; ++i) {
            sbuf.append(Integer.toHexString(data[i])).append(":");
        }
        return sbuf.toString().toUpperCase();
    }

    public static String toHex(int value, int width) {
        StringBuffer buf = new StringBuffer();
        String rep = Integer.toHexString(value);
        while (buf.length() + rep.length() < width) {
            buf.append('0');
        }
        int i = rep.length() > width ? rep.length() - width : 0;
        while (buf.length() < width) {
            buf.append(rep.charAt(i++));
        }
        return buf.toString();
    }

    public static String keyToString(Map key) {
        StringBuffer kbuf = new StringBuffer("");
        Iterator it = key.keySet().iterator();
        while (it.hasNext()) {
            String keyName = (String)it.next();
            String keyVal = (String)key.get(keyName);
            kbuf.append(keyName).append(KEY_NAME_VAL_SEPARATOR).append(keyVal).append(KEY_SEPARATOR);
        }
        return kbuf.toString();
    }

    public static List listOfStringKeysToMap(List keys) {
        ArrayList<Map> list = new ArrayList<Map>();
        int size = keys == null ? 0 : keys.size();
        for (int i = 0; i < size; ++i) {
            Map map = null;
            if (keys.get(i) instanceof Map) {
                map = (Map)keys.get(i);
            } else {
                String theKey = (String)keys.get(i);
                map = Convert.keyAsStringToMap(theKey);
            }
            list.add(map);
        }
        return list;
    }

    public static Map keyAsStringToMap(String thekey) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (thekey == null) {
            return map;
        }
        String[] key = thekey.split(KEY_SEPARATOR);
        for (int j = 0; j < key.length; ++j) {
            String[] akey = key[j].split(KEY_NAME_VAL_SEPARATOR);
            if (akey == null || akey.length != 2 || akey[0] == null) continue;
            map.put(akey[0], akey[1]);
        }
        return map;
    }

    public static String scopeToArrayKey(Scope scope) throws ConfigMgmtException {
        String arrayKey = (String)scope.getAttribute("array");
        String arrayWWN = null;
        if (arrayKey != null) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "scopeToArrayKey", "arrayKey:" + arrayKey);
            Map m = Convert.keyAsStringToMap(arrayKey);
            arrayWWN = (String)m.get("array");
            if (arrayWWN == null) {
                arrayWWN = arrayKey;
            }
        } else {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "scopeToArrayKey", "No array in scope; scope is:" + scope);
        }
        if (arrayWWN == null) {
            throw new ConfigMgmtException("unsupported.scope.exception", "Array not set in scope");
        }
        return arrayWWN;
    }

    public static byte[] stringToBytes(String hexString) {
        if (hexString == null) {
            return new byte[0];
        }
        String[] hexs = hexString.split("\\:");
        int length = hexs.length;
        BigInteger TWO_TO_32 = new BigInteger("4294967296");
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            if (hexs[i].length() > 2) {
                BigInteger x = new BigInteger(hexs[i], 16);
                hexs[i] = x.subtract(TWO_TO_32).toString();
                bytes[i] = x.byteValue();
                continue;
            }
            bytes[i] = (byte)Integer.parseInt(hexs[i], 16);
        }
        return bytes;
    }

    public static String getIpStrFromInt(int ip) {
        return (ip >> 24 & 0xFF) + "." + (ip >> 16 & 0xFF) + "." + (ip >> 8 & 0xFF) + "." + (ip & 0xFF);
    }

    public static int getIpIntFromString(String ip) {
        String METHOD_NAME = "getIpIntFromString";
        StringTokenizer tok = new StringTokenizer(ip, ".");
        if (tok.countTokens() != 4) {
            return 0;
        }
        int encodedIP = 0;
        while (tok.hasMoreTokens()) {
            String s1 = tok.nextToken();
            String s2 = tok.nextToken();
            String s3 = tok.nextToken();
            String s4 = tok.nextToken();
            encodedIP = new Integer(s4);
            encodedIP += new Integer(s3) << 8;
            encodedIP += new Integer(s2) << 16;
            encodedIP += new Integer(s1) << 24;
        }
        return encodedIP;
    }

    public static String extractRefFromProps(Properties props, String propertyName, String objectRefName) throws ConfigMgmtException {
        String stringKey = props.getProperty(propertyName);
        if (stringKey != null) {
            Map map = Convert.keyAsStringToMap(stringKey);
            return (String)map.get(objectRefName);
        }
        throw new ConfigMgmtException("incorrect.method.parameter", propertyName + " property not populated.");
    }

    public static boolean mapsHaveEqualStringEntries(Map m1, Map m2) {
        int size2;
        boolean result = true;
        if (m1 == null || m2 == null) {
            return false;
        }
        int size1 = m1 == null ? 0 : m1.size();
        int n = size2 = m2 == null ? 0 : m2.size();
        if (size1 != size2) {
            return false;
        }
        Iterator iter1 = m1.entrySet().iterator();
        while (iter1.hasNext()) {
            Map.Entry e1 = iter1.next();
            String val2 = (String)m2.get(e1.getKey());
            if (val2 != null && val2.equals(e1.getValue())) continue;
            return false;
        }
        return result;
    }

    public static String loopIdValue(Integer loopId) {
        String convertedLoopId = "";
        if (loopId == null) {
            loopId = new Integer("255");
        }
        convertedLoopId = loopId < 128 && loopId >= 0 ? convertedLoopId + loopId : "controller.loopId." + loopId;
        return convertedLoopId;
    }

    public static String bytesToKB(BigInteger bytes) {
        String size = "";
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "bytesToKB", "Calling Convert.bytesToKB");
        try {
            if (bytes != null) {
                size = Convert.bytesStringToKB(bytes.toString());
            }
        }
        catch (Exception ae) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "Exception trying to convert bytes to GB", (Throwable)ae);
        }
        return size;
    }

    public static String bytesToKB(Double bytes) {
        String size = "";
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "bytesToKB", "Calling Convert.bytesToKB");
        try {
            if (bytes != null) {
                size = Convert.bytesStringToKB(bytes.toString());
            }
        }
        catch (Exception ae) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "Exception trying to convert bytes to GB", (Throwable)ae);
        }
        return size;
    }

    public static String bytesStringToKB(String bytes) {
        String size = "";
        try {
            BigDecimal bdSize = new BigDecimal(bytes);
            bdSize = bdSize.setScale(2, 1);
            bdSize = bdSize.divide(new BigDecimal(1024.0), 1);
            size = bdSize.toString();
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "bytesStringToKB", "Returning kb conversion string = " + size);
        }
        catch (ArithmeticException ae) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "Exception trying to convert bytes to GB", (Throwable)ae);
        }
        return size;
    }

    public static String doubleToScale2(Double bytes) {
        String methodName = "doubleToScale2";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName);
        String size = "";
        try {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "bytes to scale down = " + bytes);
            BigDecimal bdSize = new BigDecimal(bytes.toString());
            bdSize = bdSize.setScale(2, 1);
            size = bdSize.toString();
            if (Trace.isTraceEnabled(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert)) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, methodName, "Returning scaled decimal string = " + size);
            }
        }
        catch (Exception ae) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "Exception trying to scale decimal", (Throwable)ae);
        }
        return size;
    }

    public static String jobStatusToString(StorageJobStatus status) {
        if (status != null) {
            return status.toString();
        }
        return "-";
    }

    public static String jobTypeToString(StorageJobType type) {
        if (type != null) {
            return type.toString();
        }
        return "-";
    }

    public static long sizeStringToSizeInBytes(String sizeString) throws ConfigMgmtException {
        if (sizeString != null) {
            sizeString = sizeString.toUpperCase();
            StringTokenizer st = new StringTokenizer(sizeString);
            String valueString = null;
            String unitString = null;
            if (st.countTokens() == 2) {
                valueString = st.nextToken();
                unitString = st.nextToken();
            } else if (st.countTokens() == 1) {
                StringCharacterIterator iterator = new StringCharacterIterator(st.nextToken());
                StringBuffer valueStringBuffer = new StringBuffer();
                char character = iterator.current();
                while (character != '\uffff') {
                    try {
                        Integer.parseInt(character + "");
                        valueStringBuffer.append(character);
                    }
                    catch (NumberFormatException nfe) {
                        if (character != '.') break;
                        valueStringBuffer.append(character);
                    }
                    character = iterator.next();
                }
                valueString = valueStringBuffer.toString();
                unitString = sizeString.substring(valueStringBuffer.length());
            } else {
                return -1L;
            }
            double valueAsDouble = -1.0;
            try {
                valueAsDouble = Double.parseDouble(valueString);
            }
            catch (NumberFormatException nfe) {
                throw new ConfigMgmtException("incorrect.method.parameter", "Size string not in the expected format " + sizeString);
            }
            if ("TB".equalsIgnoreCase(unitString)) {
                return (long)(valueAsDouble * Constants.StorageSize.ONE_TB.doubleValue());
            }
            if ("GB".equalsIgnoreCase(unitString)) {
                return (long)(valueAsDouble * Constants.StorageSize.ONE_GB.doubleValue());
            }
            if ("MB".equalsIgnoreCase(unitString)) {
                return (long)(valueAsDouble * Constants.StorageSize.ONE_MB.doubleValue());
            }
            if ("KB".equalsIgnoreCase(unitString)) {
                return (long)(valueAsDouble * Constants.StorageSize.ONE_KB.doubleValue());
            }
            if ("BLK".equalsIgnoreCase(unitString)) {
                return (long)(valueAsDouble * Constants.StorageSize.ONE_BLOCK.doubleValue());
            }
            if ("Bytes".equalsIgnoreCase(unitString)) {
                return (long)valueAsDouble;
            }
            throw new ConfigMgmtException("incorrect.method.parameter", "Size string not in the expected format " + sizeString);
        }
        return -1L;
    }

    public static Size sizeInBytesToLocalizableSize(BigInteger sizeInBytes, Locale locale) {
        Size localizedSize = new Size();
        if (sizeInBytes != null) {
            BigDecimal size = new BigDecimal(sizeInBytes);
            localizedSize.setSizeInBytes(sizeInBytes);
            localizedSize.setLocale(locale);
            size = size.setScale(3, 1);
            if (size.compareTo(Constants.StorageSize.ONE_TB) >= 0) {
                size = size.divide(Constants.StorageSize.ONE_TB, 1);
                localizedSize.setUnit(Size.SIZE_UNIT_TB);
            } else if (size.compareTo(Constants.StorageSize.ONE_GB) >= 0) {
                size = size.divide(Constants.StorageSize.ONE_GB, 1);
                localizedSize.setUnit(Size.SIZE_UNIT_GB);
            } else if (size.compareTo(Constants.StorageSize.ONE_MB) >= 0) {
                size = size.divide(Constants.StorageSize.ONE_MB, 1);
                localizedSize.setUnit(Size.SIZE_UNIT_MB);
            } else if (size.compareTo(Constants.StorageSize.ONE_KB) >= 0) {
                size = size.divide(Constants.StorageSize.ONE_KB, 1);
                localizedSize.setUnit(Size.SIZE_UNIT_KB);
            } else if (size.compareTo(Constants.StorageSize.ONE_BLOCK) >= 0) {
                size = size.divide(Constants.StorageSize.ONE_BLOCK, 1);
                localizedSize.setUnit(Size.SIZE_UNIT_BLOCK);
            }
            localizedSize.setConvertedSize(size);
            NumberFormat nf = NumberFormat.getInstance(locale);
            nf.setMaximumFractionDigits(3);
            nf.setMinimumFractionDigits(3);
            localizedSize.setConvertedSizeStr(nf.format(size));
        }
        return localizedSize;
    }

    public static Size sizeInBytesToLocalizableSize(Integer sb, Locale locale) {
        if (sb == null) {
            return null;
        }
        return Convert.sizeInBytesToLocalizableSize(new BigInteger(sb.toString()), locale);
    }

    public static Size sizeInBytesToLocalizableSize(Long sb, Locale locale) {
        if (sb == null) {
            return null;
        }
        return Convert.sizeInBytesToLocalizableSize(new BigInteger(sb.toString()), locale);
    }

    public static Size sizeStringToSizeInBytes(String sizeString, Locale locale) throws ConfigMgmtException {
        String methodName = "sizeStringToSizeInBytes";
        Size size = new Size();
        if (sizeString == null) {
            return size;
        }
        String value = sizeString;
        String unit = Size.SIZE_UNIT_GB;
        BigDecimal multiplier = Constants.StorageSize.ONE_GB;
        NumberFormat nf = NumberFormat.getInstance(locale);
        if ((sizeString = sizeString.toUpperCase(locale)).indexOf(Size.SIZE_UNIT_BLOCK) >= 0) {
            value = sizeString.substring(0, sizeString.indexOf(Size.SIZE_UNIT_BLOCK));
            multiplier = Constants.StorageSize.ONE_BLOCK;
            unit = Size.SIZE_UNIT_BLOCK;
        } else if (sizeString.indexOf(Size.SIZE_UNIT_MB) >= 0) {
            value = sizeString.substring(0, sizeString.indexOf(Size.SIZE_UNIT_MB));
            multiplier = Constants.StorageSize.ONE_MB;
            unit = Size.SIZE_UNIT_MB;
        } else if (sizeString.indexOf(Size.SIZE_UNIT_GB) >= 0) {
            value = sizeString.substring(0, sizeString.indexOf(Size.SIZE_UNIT_GB));
            multiplier = Constants.StorageSize.ONE_GB;
            unit = Size.SIZE_UNIT_GB;
        } else if (sizeString.indexOf(Size.SIZE_UNIT_TB) >= 0) {
            value = sizeString.substring(0, sizeString.indexOf(Size.SIZE_UNIT_TB));
            multiplier = Constants.StorageSize.ONE_TB;
            unit = Size.SIZE_UNIT_TB;
        } else if (sizeString.indexOf(Size.SIZE_UNIT_KB) >= 0) {
            value = sizeString.substring(0, sizeString.indexOf(Size.SIZE_UNIT_KB));
            multiplier = Constants.StorageSize.ONE_KB;
            unit = Size.SIZE_UNIT_KB;
        } else {
            throw new ConfigMgmtException("error.create.volume.invalid.size.format", new String[]{sizeString}, "Size string not in the expected format.", null);
        }
        value = value.trim();
        ParsePosition pp = new ParsePosition(0);
        Number number = nf.parse(value, pp);
        if (pp.getErrorIndex() >= 0 || pp.getIndex() < value.length()) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$util$Convert == null ? (class$com$sun$netstorage$array$mgmt$cfg$util$Convert = Convert.class$("com.sun.netstorage.array.mgmt.cfg.util.Convert")) : class$com$sun$netstorage$array$mgmt$cfg$util$Convert, "sizeStringToSizeInBytes", "ERROR VALUE WRONG!");
            throw new ConfigMgmtException("wizards.volume.CapacityCheckPrompt", "incorrect.method.parameter");
        }
        double dubSize = number.doubleValue() * multiplier.doubleValue();
        BigDecimal b = new BigDecimal(dubSize);
        size.setSizeInBytes(b.toBigInteger());
        size.setConvertedSize(new BigDecimal(number.doubleValue()));
        size.setConvertedSizeStr(value);
        size.setLocale(locale);
        size.setUnit(unit);
        return size;
    }

    public static String longMillisecondsToTimeFormatString(Long longMsObj) {
        long longMs = longMsObj;
        if (longMsObj == null || longMs < 0L) {
            return "-";
        }
        int days = (int)(longMs / 86400000L);
        if (days > 1) {
            longMs -= (long)(86400000 * days);
        }
        int ms = (int)(longMs % 1000L);
        int secs = (int)(longMs / 1000L % 60L);
        int mins = (int)(longMs / 60000L % 60L);
        int hours = (int)(longMs / 3600000L % 24L);
        if (days > 0) {
            hours += days * 24;
        }
        if (ms > 500) {
            ++secs;
        }
        String secsStr = (secs < 10 ? "0" : "") + secs;
        String minsStr = (mins < 10 ? "0" : "") + mins;
        String hoursStr = (hours < 10 ? "0" : "") + hours;
        return hoursStr + ":" + minsStr + ":" + secsStr;
    }

    public static String longMinutesToTimeFormatString(Long longMinsObj) {
        long longMins = longMinsObj;
        if (longMinsObj == null || longMins < 0L) {
            return "-";
        }
        int days = (int)(longMins / 1440L);
        if (days > 1) {
            longMins -= (long)(1440 * days);
        }
        int secs = 0;
        int mins = (int)(longMins % 60L);
        int hours = (int)(longMins / 60L % 24L);
        if (days > 0) {
            hours += days * 24;
        }
        String secsStr = (secs < 10 ? "0" : "") + secs;
        String minsStr = (mins < 10 ? "0" : "") + mins;
        String hoursStr = (hours < 10 ? "0" : "") + hours;
        return hoursStr + ":" + minsStr + ":" + secsStr;
    }

    public static String featureEnableIDToString(String featureEnableID) {
        String formatID = "";
        int length = featureEnableID.length();
        int beginIndex = 0;
        int endIndex = beginIndex + 4;
        if (length <= 4) {
            return featureEnableID;
        }
        while (beginIndex < length) {
            formatID = beginIndex == 0 ? featureEnableID.substring(beginIndex, endIndex) : formatID + " " + featureEnableID.substring(beginIndex, endIndex);
            beginIndex = endIndex;
            if ((endIndex += 4) <= length) continue;
            return formatID + " " + featureEnableID.substring(beginIndex, length);
        }
        return formatID;
    }

    public static String cvtPermission(Integer intIn) {
        return (String)PERMISSION_MAP.get(intIn.toString());
    }

    public static void checkMCS(MethodCallStatus mcs, ArrayList errors) {
    }

    public static String wwnToString(String wwn) {
        String result = null;
        if (wwn.length() == 32 || wwn.length() == 16) {
            result = wwn;
        } else if (wwn.length() == 47) {
            StringBuffer colWwn = new StringBuffer(wwn);
            StringBuffer nocolWwn = new StringBuffer(32);
            for (int i = 0; i < colWwn.length(); ++i) {
                if (colWwn.charAt(i) == ':') continue;
                nocolWwn = nocolWwn.append(colWwn.charAt(i));
            }
            result = nocolWwn.toString();
        }
        return result;
    }

    public static String toLargeRemotePeerWWN(String peerWwn) {
        if (peerWwn != null && peerWwn.length() < 32) {
            String s = "";
            for (int i = 32 - peerWwn.length(); i > 0; --i) {
                s = s + "0";
            }
            peerWwn = s + peerWwn;
        }
        return peerWwn;
    }

    public static String toShortRemotePeerWWN(String peerWwn) {
        if (peerWwn != null && peerWwn.length() == 32) {
            peerWwn = peerWwn.substring(peerWwn.length() / 2, peerWwn.length());
        }
        return peerWwn;
    }

    public static Boolean convertConsistencyGroup(Integer consistencyGroup) {
        if (consistencyGroup != null && consistencyGroup == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean convertAutoSynchronize(Integer autoSynchronize) {
        if (autoSynchronize != null && autoSynchronize == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PERMISSION_MAP.put(Integer.toString(1), "Other");
        PERMISSION_MAP.put(Integer.toString(2), "Create");
        PERMISSION_MAP.put(Integer.toString(3), "Delete");
        PERMISSION_MAP.put(Integer.toString(4), "Detect");
        PERMISSION_MAP.put(Integer.toString(5), "Read");
        PERMISSION_MAP.put(Integer.toString(6), "Write");
        PERMISSION_MAP.put(Integer.toString(7), "Execute");
    }
}

