/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.quicksearch.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.quicksearch.impl.ent1.SearchConstants;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SearchTableData
extends ArrayList
implements SearchConstants {
    public static final String[] headingNames = new String[]{"se6920ui.bui.quicksearch.tableColName", "se6920ui.bui.quicksearch.tableColType", "se6920ui.bui.quicksearch.tableColDescription"};
    private String searchTerm;
    private ConfigContext cfgctx;

    boolean matches(String name) {
        String METHOD = "matches(String)";
        Trace.methodBegin(this, "matches(String)");
        if (name == null) {
            Trace.verbose((Object)this, "matches(String)", "name value is null returning false.");
            return false;
        }
        if (this.searchTerm.equals("*")) {
            Trace.verbose((Object)this, "matches(String)", "Search term is '*' (all), returning true.");
            return true;
        }
        return name.toLowerCase().indexOf(this.searchTerm) != -1;
    }

    boolean matches(String name, String description) {
        String METHOD = "matches(String, String)";
        Trace.methodBegin(this, "matches(String, String)");
        return this.matches(name) || this.matches(description);
    }

    private void errorResult(String type, Exception e) {
        String METHOD = "errorResult";
        Trace.methodBegin(this, "errorResult");
        this.add(new Object[]{"", "", type, e.getMessage()});
    }

    private void add(Object obj, String name, String type, String description) {
        this.add(new Object[]{obj, name, type, description});
    }

    public SearchTableData(ConfigContext cfgctx, String type, String userEnteredSearchTerm, String trayDescription, String diskDescription) {
        Iterator it;
        T4Interface t4;
        Iterator array_it;
        List arraysList;
        ManageT4sInterface mngT4s;
        String METHOD = "SearchTableData";
        Trace.constructor(this);
        this.searchTerm = userEnteredSearchTerm.toLowerCase();
        this.cfgctx = cfgctx;
        if ("se6920ui.bui.quicksearch.ArraysLabel".equals(type) || "se6920ui.bui.quicksearch.AllLabel".equals(type)) {
            try {
                mngT4s = ManageT4sFactory.getManager();
                mngT4s.init(cfgctx, null);
                arraysList = mngT4s.getItemList();
                array_it = arraysList.iterator();
                while (array_it.hasNext()) {
                    t4 = (T4Interface)array_it.next();
                    if (!this.matches(t4.getName(), t4.getDescription())) continue;
                    this.add(t4, t4.getName(), "se6920ui.bui.quicksearch.typeArray", t4.getDescription());
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, "SearchTableData", "Error searching type: " + type);
                this.errorResult("se6920ui.bui.quicksearch.ArraysLabel", e);
            }
        }
        if ("se6920ui.bui.quicksearch.TraysLabel".equals(type) || "se6920ui.bui.quicksearch.AllLabel".equals(type)) {
            try {
                ManageTraysInterface mngTrays = ManageTraysFactory.getManager();
                mngTrays.init(cfgctx, null);
                List trays = mngTrays.getItemList();
                it = trays.iterator();
                while (it.hasNext()) {
                    TrayInterface tray = (TrayInterface)it.next();
                    if (!this.matches(tray.getId())) continue;
                    MessageFormat msgFmt = new MessageFormat(trayDescription);
                    Object[] args = new Object[]{tray.getT4Name()};
                    String msg = msgFmt.format(args);
                    this.add(tray, tray.getId(), "se6920ui.bui.quicksearch.typeTray", msg);
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, "SearchTableData", "Error searching type: " + type);
                this.errorResult("se6920ui.bui.quicksearch.TraysLabel", e);
            }
        }
        if ("se6920ui.bui.quicksearch.PoolsLabel".equals(type) || "se6920ui.bui.quicksearch.AllLabel".equals(type)) {
            try {
                ManageStoragePoolsInterface mgr = ManageStoragePoolsFactory.getManager();
                mgr.init(cfgctx, null);
                ArrayList poolsList = mgr.getItemsBySystem();
                it = poolsList.iterator();
                while (it.hasNext()) {
                    StoragePoolInterface storagePool = (StoragePoolInterface)it.next();
                    if (!this.matches(storagePool.getName(), storagePool.getDescription())) continue;
                    this.add(storagePool, storagePool.getName(), "se6920ui.bui.quicksearch.typePool", storagePool.getDescription());
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, "SearchTableData", "Error searching type: " + type);
                this.errorResult("se6920ui.bui.quicksearch.PoolsLabel", e);
            }
        }
        if ("se6920ui.bui.quicksearch.VolumesLabel".equals(type) || "se6920ui.bui.quicksearch.AllLabel".equals(type)) {
            try {
                ManageStorageVolumesInterface msv = ManageStorageVolumesFactory.getManager();
                msv.init(cfgctx, null);
                ArrayList volumeList = msv.getItemsBySystem();
                it = volumeList.iterator();
                while (it.hasNext()) {
                    StorageVolumeInterface volume = (StorageVolumeInterface)it.next();
                    if (!this.matches(volume.getName(), volume.getDescription())) continue;
                    this.add(volume, volume.getName(), "se6920ui.bui.quicksearch.typeVolume", volume.getDescription());
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, "SearchTableData", "Error searching type: " + type);
                this.errorResult("se6920ui.bui.quicksearch.VolumesLabel", e);
            }
        }
        if ("se6920ui.bui.quicksearch.InitiatorsLabel".equals(type) || "se6920ui.bui.quicksearch.AllLabel".equals(type)) {
            try {
                ManageInitiatorsInterface imgr = ManageInitiatorsFactory.getManager();
                imgr.init(cfgctx, null);
                ArrayList initiatorList = imgr.getItemsBySystem();
                it = initiatorList.iterator();
                while (it.hasNext()) {
                    InitiatorInterface initiator = (InitiatorInterface)it.next();
                    if (!this.matches(initiator.getName(), initiator.getDescription())) continue;
                    this.add(initiator, initiator.getName(), "se6920ui.bui.quicksearch.typeInitiator", initiator.getDescription());
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, "SearchTableData", "Error searching type: " + type);
                this.errorResult("se6920ui.bui.quicksearch.InitiatorsLabel", e);
            }
        }
        if ("se6920ui.bui.quicksearch.DisksLabel".equals(type) || "se6920ui.bui.quicksearch.AllLabel".equals(type)) {
            try {
                mngT4s = ManageT4sFactory.getManager();
                mngT4s.init(cfgctx, null);
                arraysList = mngT4s.getItemList();
                array_it = arraysList.iterator();
                while (array_it.hasNext()) {
                    t4 = (T4Interface)array_it.next();
                    List traysList = t4.getTrays();
                    Iterator tray_it = traysList.iterator();
                    while (tray_it.hasNext()) {
                        TrayInterface tray = (TrayInterface)tray_it.next();
                        List disksList = tray.getDiskList();
                        Iterator disk_it = disksList.iterator();
                        while (disk_it.hasNext()) {
                            DiskInterface disk = (DiskInterface)disk_it.next();
                            if (!this.matches(disk.getName())) continue;
                            MessageFormat msgFmt = new MessageFormat(diskDescription);
                            Object[] args = new Object[]{tray.getId(), tray.getT4Name()};
                            String msg = msgFmt.format(args);
                            this.add(disk, disk.getName(), "se6920ui.bui.quicksearch.typeDisk", msg);
                        }
                    }
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, "SearchTableData", "Error searching type: " + type);
                this.errorResult("se6920ui.bui.quicksearch.DisksLabel", e);
            }
        }
        if ("se6920ui.bui.quicksearch.VDisksLabel".equals(type) || "se6920ui.bui.quicksearch.AllLabel".equals(type)) {
            try {
                ManageVDisks mgrvd = (ManageVDisks)ManageVDisksFactory.getManager();
                mgrvd.init(cfgctx, null);
                ArrayList list = mgrvd.getItemsBySystem();
                it = list.iterator();
                while (it.hasNext()) {
                    VDiskInterface vdisk = (VDiskInterface)it.next();
                    if (!this.matches(vdisk.getName())) continue;
                    this.add(vdisk, vdisk.getName(), "se6920ui.bui.quicksearch.typeVDisk", vdisk.getWWN());
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, "SearchTableData", "Error searching type: " + type);
                this.errorResult("se6920ui.bui.quicksearch.VDisksLabel", e);
            }
        }
        if ("se6920ui.bui.quicksearch.ProfilesLabel".equals(type) || "se6920ui.bui.quicksearch.AllLabel".equals(type)) {
            try {
                ManageStorageProfilesInterface mgrpf = ManageStorageProfilesFactory.getManager();
                mgrpf.init(cfgctx, null);
                ArrayList profileList = mgrpf.getItemsBySystem();
                it = profileList.iterator();
                while (it.hasNext()) {
                    StorageProfileInterface profile = (StorageProfileInterface)it.next();
                    if (!this.matches(profile.getName())) continue;
                    this.add(profile, profile.getName(), "se6920ui.bui.quicksearch.typeProfile", profile.getDescription());
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, "SearchTableData", "Error searching type: " + type);
                this.errorResult("se6920ui.bui.quicksearch.ProfilesLabel", e);
            }
        }
    }

    public static interface ObjectTypes {
        public static final String ARRAY = "se6920ui.bui.quicksearch.typeArray";
        public static final String TRAY = "se6920ui.bui.quicksearch.typeTray";
        public static final String DISK = "se6920ui.bui.quicksearch.typeDisk";
        public static final String POOL = "se6920ui.bui.quicksearch.typePool";
        public static final String VOLUME = "se6920ui.bui.quicksearch.typeVolume";
        public static final String PROFILE = "se6920ui.bui.quicksearch.typeProfile";
        public static final String VDISK = "se6920ui.bui.quicksearch.typeVDisk";
        public static final String INITIATOR = "se6920ui.bui.quicksearch.typeInitiator";
    }
}

