/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test.T4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ManageT4s
implements ManageT4sInterface {
    private static ArrayList t4List;
    private ConfigContext context;
    private SearchFilter filter;

    public ManageT4s() {
        Trace.constructor(this);
    }

    public void setT4List(ArrayList t4List) {
        ManageT4s.t4List = t4List;
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.filter = filter;
        if (t4List == null) {
            t4List = new ArrayList();
        }
        if (t4List.size() == 0 && (filter == null || filter.isEmpty())) {
            for (int i = 1; i < 9; ++i) {
                this.createT4("suenc167-" + i, "suenc167-" + i + " T4Description", 16384, "auto", 1, 8, "mpxio");
            }
        } else if (t4List.size() == 0) {
            for (int i = 1; i < 36; ++i) {
                this.createT4("suenc167-" + i, "suenc167-" + i + " T4Description", 16384, "auto", 8, 1, "mpxio");
            }
        }
        Trace.verbose((Object)this, "init", "number of T4 in list: " + t4List.size());
    }

    public List getItemList() throws ConfigMgmtException {
        return t4List;
    }

    public T4Interface getT4ByName(String name) throws ConfigMgmtException {
        this.createT4(name, "suenc167- T4Description", 16384, "auto", 8, 1, "mpxio");
        return (T4Interface)t4List.get(0);
    }

    public T4Interface getT4ByIP(String ip) throws ConfigMgmtException {
        this.createT4(ip, "suenc167- T4Description", 16384, "auto", 8, 1, "mpxio");
        return (T4Interface)t4List.get(0);
    }

    public void createT4(String name, String description, int blockSize, String cacheMode, int readaheadMode, int diskReconRate, String failoverMode) throws ConfigMgmtException {
        Trace.methodBegin(this, "createT4");
        T4 tee4 = new T4();
        tee4.init(this.context);
        tee4.setName(name);
        tee4.setDescription(description);
        tee4.setBlockSize(blockSize);
        tee4.setCacheMode(cacheMode);
        tee4.setReadaheadMode(readaheadMode);
        tee4.setDiskReconRate(diskReconRate);
        tee4.setFailoverMode(failoverMode);
        t4List.add(tee4);
    }

    public boolean areAllArraysHealthy() throws ConfigMgmtException {
        Trace.methodBegin(this, "arrAllArraysHealthy");
        return true;
    }

    public List getPossibleDuplicateArrays(T4Interface srcT4, List possibleDestinations) throws ConfigMgmtException {
        String METHOD = "getPossibleDuplicateArrays";
        Trace.methodBegin(this, "getPossibleDuplicateArrays");
        ArrayList<T4Interface> possibles = new ArrayList<T4Interface>();
        if (srcT4 == null || possibleDestinations == null) {
            Trace.verbose((Object)this, "getPossibleDuplicateArrays", "Received null arguments, returning.");
            return possibles;
        }
        Iterator i = possibleDestinations.iterator();
        while (i.hasNext()) {
            T4Interface cand = (T4Interface)i.next();
            if (srcT4.getClusterName().equals(cand.getClusterName()) || !srcT4.isDuplicateCandidate(cand)) continue;
            Trace.verbose((Object)this, "getPossibleDuplicateArrays", "Found candidate for destination: " + cand.getName());
            possibles.add(cand);
        }
        return possibles;
    }

    public T4Interface getByKey(Collection key) throws ConfigMgmtException {
        return (T4Interface)t4List.get(0);
    }
}

