/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageProfileParameters;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class ManageStorageProfiles
implements ManageStorageProfilesInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private ArrayList profiles;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.generateSomeProfiles();
    }

    private void generateSomeProfiles() throws ConfigMgmtException {
        this.profiles = new ArrayList();
        for (int i = 1; i < 3; ++i) {
            try {
                StorageProfile p = new StorageProfile();
                p.setName("Profile " + i);
                p.setDescription("Description for profile: " + i);
                p.setArrayType(i);
                p.setSegmentSize(i);
                p.setReadAhead(i % 2 == 0);
                p.setRAIDLevel(i % 2 == 0 ? 1 : 5);
                p.setNumberOfDisks(i + 3);
                p.setDedicatedSpare(!p.isReadAheadEnabled());
                Vector<CIMProperty> keys = new Vector<CIMProperty>();
                keys.add(new CIMProperty("Name", new CIMValue((Object)("StorageProfile_" + i))));
                p.setKey(keys);
                this.profiles.add(p);
                continue;
            }
            catch (Exception e) {
                throw new ConfigMgmtException("failed", "failed", e);
            }
        }
    }

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        return this.profiles;
    }

    public StorageProfileInterface getItemByName(String name) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemByName");
        return (StorageProfileInterface)this.profiles.get(0);
    }

    public StorageProfileInterface getByKey(Collection key) throws ConfigMgmtException {
        Trace.methodBegin(this, "getByKey");
        return (StorageProfileInterface)this.profiles.get(0);
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        Trace.methodBegin(this, "getNextAvailableName");
        return "New";
    }

    public MethodCallStatus createStorageProfile(StorageProfileParameters params) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "createStorageProfile");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        methodCallStatus.setReturnCode(0);
        return methodCallStatus;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "delete");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        methodCallStatus.setReturnCode(0);
        return methodCallStatus;
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "validateName");
        if (name != null) {
            if (name.length() > 16) {
                Trace.error((Object)this, "validateName", "Name: " + name + " is too long.");
                throw new BadParameterException(name, "error.bizobj.nameTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-]+", name)) {
                Trace.error((Object)this, "validateName", "Name: " + name + " contains invalid characters.");
                throw new BadParameterException(name, "error.bizobj.invalidCharacter");
            }
        } else {
            Trace.error((Object)this, "validateName", "Name is null.");
            throw new BadParameterException(name, "error.bizobj.noName");
        }
    }

    public void validateDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "validateDescription");
        if (description != null) {
            if (description.length() > 64) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " is too long.");
                throw new BadParameterException(description, "error.bizobj.descriptionTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-\\.\\:\\,\\%\\(\\)\\{\\}\\[\\]\\`\\~\\| ]*", description)) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " contains invalid characters.");
                throw new BadParameterException(description, "error.bizobj.invalidDescCharacter");
            }
        }
    }

    public List getXmlContentsForImport(ConfigContext context, String xml) {
        return new ArrayList();
    }

    public List getXmlContentsForImport(String xml) {
        return new ArrayList();
    }

    public String getExportXml(List profileList) throws ItemNotFoundException, ConfigMgmtException {
        return "";
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return null;
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
    }
}

