/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfErrorCode;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VolPerfCounterData;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Volume;
import java.util.Date;
import java.util.List;
import java.util.Map;

class VolPerfData
extends PerfData {
    protected static final double LAZILY_PROCESS = -2.0;
    protected VolPerfCounterData firstPerfData = null;
    protected VolPerfCounterData firstCurrentDiff = null;
    protected VolPerfCounterData diffPerfData = null;
    protected VolPerfCounterData currentPerfData = null;
    protected boolean controllerResetAfterStart = false;
    protected boolean volumeCreatedAfterStart = false;

    public VolPerfData(String volWWN, Map keyMap) {
        super(volWWN, keyMap);
    }

    public VolPerfData(String arrayWWN, Volume volume) {
        this(arrayWWN, ManageVolumes.getVolumeKeyMap(arrayWWN, Convert.bytesToStringRaw(volume.getVolumeRef().getRefToken()), UnicodeTranslator.getString((byte[])volume.getLabel().getValue()), Convert.bytesToString(volume.getWorldWideName())));
    }

    public Double getRunAverageTotalIOPs() {
        if (this.averageTotalIOPs == -2.0) {
            VolPerfCounterData diff = this.getFirstCurrentDiffData();
            if (!diff.isDataValid()) {
                this.setRunAverageTotalIOPs(-1.0);
            } else {
                long currentIOs = diff.totalRequestsServiced;
                if (currentIOs == 0L) {
                    this.setRunAverageTotalIOPs(0.0);
                } else {
                    this.setRunAverageTotalIOPs((double)currentIOs / (double)diff.interval);
                }
            }
        }
        return super.getRunAverageTotalIOPs();
    }

    public Double getRunAverageReadsPerSec() {
        if (this.averageBytesReadPerSec == -2.0) {
            VolPerfCounterData diff = this.getFirstCurrentDiffData();
            if (!diff.isBlockSizeValid() || !diff.isDataValid()) {
                this.setRunAverageReadsPerSec(-1.0);
            } else {
                this.setRunAverageReadsPerSec((double)(diff.totalReadBlocksRequested * (long)diff.blockSize) / (double)diff.interval);
            }
        }
        return super.getRunAverageReadsPerSec();
    }

    public Double getRunAverageWritesPerSec() {
        if (this.averageBytesWrittenPerSec == -2.0) {
            VolPerfCounterData diff = this.getFirstCurrentDiffData();
            if (!diff.isBlockSizeValid() || !diff.isDataValid()) {
                this.setRunAverageWritesPerSec(-1.0);
            } else {
                this.setRunAverageWritesPerSec((double)(diff.totalWriteBlocksRequested * (long)diff.blockSize) / (double)diff.interval);
            }
        }
        return super.getRunAverageWritesPerSec();
    }

    public Double getCacheReadHitPercentage() {
        if (this.cacheReadHitPercentage == -2.0) {
            if (this.diffPerfData.totalCacheReadChecks == 0L || this.diffPerfData.totalCacheReadCheckHits == 0L) {
                this.setCacheReadHitPercentage(0.0);
            } else {
                this.setCacheReadHitPercentage((double)this.diffPerfData.totalCacheReadCheckHits / (double)this.diffPerfData.totalCacheReadChecks * 100.0);
            }
        }
        return super.getCacheReadHitPercentage();
    }

    public Double getReadPercentage() {
        if (this.readPercentage == -2.0) {
            if (this.diffPerfData.totalReadRequests == 0L) {
                this.setReadPercentage(0.0);
            } else {
                this.setReadPercentage((double)this.diffPerfData.totalReadRequests / (double)this.diffPerfData.totalRequestsServiced * 100.0);
            }
        }
        return super.getReadPercentage();
    }

    public Date getStorageStatsLastPollTime() {
        if (this.currentPerfData == null) {
            return null;
        }
        return new Date(this.currentPerfData.time);
    }

    public Double getWritePercentage() {
        if (this.writePercentage == -2.0) {
            if (this.diffPerfData.totalWriteRequests == 0L) {
                this.setWritePercentage(0.0);
            } else {
                this.setWritePercentage((double)this.diffPerfData.totalWriteRequests / (double)this.diffPerfData.totalRequestsServiced * 100.0);
            }
        }
        return super.getWritePercentage();
    }

    public boolean hasPerfData() {
        return this.getPeakValueTotalIOPs().intValue() != 0;
    }

    public List getPerfStatsErrorCodes() {
        VolPerfCounterData diff = this.getFirstCurrentDiffData();
        return super.getPerfStatsErrorCodes();
    }

    public VolPerfCounterData getFirstCurrentDiffData() {
        if (this.firstCurrentDiff == null && this.firstPerfData != null) {
            this.firstCurrentDiff = this.firstPerfData.subtract(this.currentPerfData);
            this.addErrorCodes(this.firstPerfData.getErrorCodes());
        }
        return this.firstCurrentDiff;
    }

    public synchronized VolPerfCounterData getDiffData() {
        return this.diffPerfData;
    }

    public VolPerfCounterData getFirstPerfData() {
        return this.firstPerfData;
    }

    public VolPerfCounterData getPerfData() {
        return this.currentPerfData;
    }

    public boolean controllerResetAfterStart() {
        return this.controllerResetAfterStart;
    }

    public void setControllerResetAfterStart() {
        this.controllerResetAfterStart = true;
        this.firstPerfData = null;
        this.currentPerfData = null;
        this.diffPerfData = null;
        this.markDataAsNotAvailable();
    }

    public void setVolumeCreatedAfterStart() {
        this.volumeCreatedAfterStart = true;
    }

    public boolean volumeCreatedAfterStart() {
        return this.volumeCreatedAfterStart;
    }

    public void markInvalidDueToBlockSize() {
        this.addErrorCode(PerfErrorCode.VOL_BLOCKSIZE_CHANGED);
        this.setRunAverageReadsPerSec(-1.0);
        this.setRunAverageWritesPerSec(-1.0);
        this.setAverageReadSize(-1.0);
        this.setAverageWriteSize(-1.0);
        this.setReadsPerSec(-1.0);
        this.setWritesPerSec(-1.0);
    }

    public void setPerfData(VolPerfCounterData data) {
        this.clearAllErrors();
        this.firstCurrentDiff = null;
        if (this.firstPerfData == null) {
            this.firstPerfData = data;
        }
        if (this.currentPerfData != null) {
            this.diffPerfData = this.currentPerfData.subtract(data);
        }
        this.currentPerfData = data;
        if (this.diffPerfData == null) {
            if (this.controllerResetAfterStart()) {
                this.addErrorCode(PerfErrorCode.CONTROLLER_RESET);
            }
            return;
        }
        if (this.diffPerfData.isDataValid() && this.diffPerfData.interval > 0L) {
            long currentIOs = this.diffPerfData.totalRequestsServiced;
            if (currentIOs == 0L) {
                this.setTotalIOPs(0.0);
            } else {
                this.setTotalIOPs((double)currentIOs / (double)this.diffPerfData.interval);
            }
            if (!this.diffPerfData.isBlockSizeValid()) {
                this.markInvalidDueToBlockSize();
            } else {
                if (this.diffPerfData.totalReadBlocksRequested == 0L || this.diffPerfData.totalReadRequests == 0L) {
                    this.setAverageReadSize(0.0);
                } else {
                    this.setAverageReadSize((double)this.diffPerfData.totalReadBlocksRequested / (double)this.diffPerfData.totalReadRequests * (double)this.diffPerfData.blockSize);
                }
                if (this.diffPerfData.totalWriteBlocksRequested == 0L || this.diffPerfData.totalWriteRequests == 0L) {
                    this.setAverageWriteSize(0.0);
                } else {
                    this.setAverageWriteSize((double)this.diffPerfData.totalWriteBlocksRequested / (double)this.diffPerfData.totalWriteRequests * (double)this.diffPerfData.blockSize);
                }
            }
            this.setReadsPerSec((double)this.diffPerfData.totalReadBlocksRequested * (double)this.diffPerfData.blockSize / (double)this.diffPerfData.interval);
            this.setWritesPerSec((double)this.diffPerfData.totalWriteBlocksRequested * (double)this.diffPerfData.blockSize / (double)this.diffPerfData.interval);
            this.setRunAverageReadsPerSec(-2.0);
            this.setRunAverageTotalIOPs(-2.0);
            this.setRunAverageWritesPerSec(-2.0);
            this.setCacheReadHitPercentage(-2.0);
            this.setReadPercentage(-2.0);
            this.setWritePercentage(-2.0);
        } else {
            this.addErrorCodes(this.diffPerfData.getErrorCodes());
            this.markDataAsNotAvailable();
        }
    }

    String getStatsStr(String seperator, boolean vertical) {
        StringBuffer buf = new StringBuffer();
        if (vertical) {
            buf.append("Volume Name: ");
            buf.append(this.getKey().get("volumeName"));
            buf.append(seperator);
        } else {
            buf.append(this.getKey().get("volumeName"));
            buf.append(" ");
        }
        buf.append(super.getStatsStr(seperator, vertical));
        return buf.toString();
    }
}

