/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfCounterData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfErrorCode;
import devmgr.versioned.symbol.VolumePerformance;

public class VolPerfCounterData
extends PerfCounterData
implements Cloneable {
    private static final long OVERFLOW_ADJUSTMENT = (long)Math.pow(2.0, 32.0);
    private static final long MAX_LONG = (long)Math.pow(2.0, 63.0) - 1L;
    long time = -1L;
    long interval = 1L;
    long totalBlocksRequested = 0L;
    long totalCacheReadCheckHits = 0L;
    long totalCacheReadChecks = 0L;
    long totalReadBlocksRequested = 0L;
    long totalReadRequests = 0L;
    long totalRequestsServiced = 0L;
    long totalWriteBlocksRequested = 0L;
    long totalWriteRequests = 0L;
    String ref = null;
    int blockSize;
    boolean blockSizeValidity = true;
    boolean dataValidity = true;

    public VolPerfCounterData(long time, String controllerRef, int blockSize) {
        this.time = time;
        this.blockSize = blockSize;
        this.interval = 0L;
        this.ref = controllerRef;
    }

    public VolPerfCounterData(VolumePerformance volumePerf, String controllerRef, int blockSize) {
        this(volumePerf.getTime() * 1000L, controllerRef, blockSize);
        this.totalBlocksRequested = volumePerf.getTotalBlocksRequested();
        this.totalCacheReadChecks = volumePerf.getTotalCacheReadChecks();
        this.totalCacheReadCheckHits = volumePerf.getTotalCacheReadCheckHits();
        this.totalReadBlocksRequested = volumePerf.getTotalReadBlocksRequested();
        this.totalReadRequests = volumePerf.getTotalReadRequests();
        this.totalRequestsServiced = volumePerf.getTotalRequestsServiced();
        this.totalWriteBlocksRequested = volumePerf.getTotalWriteBlocksRequested();
        this.totalWriteRequests = volumePerf.getTotalWriteRequests();
        if (this.totalBlocksRequested < 0L) {
            this.totalBlocksRequested += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalCacheReadChecks < 0L) {
            this.totalCacheReadChecks += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalCacheReadCheckHits < 0L) {
            this.totalCacheReadCheckHits += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalReadBlocksRequested < 0L) {
            this.totalReadBlocksRequested += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalReadRequests < 0L) {
            this.totalReadRequests += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalRequestsServiced < 0L) {
            this.totalRequestsServiced += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalWriteBlocksRequested < 0L) {
            this.totalWriteBlocksRequested += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalWriteRequests < 0L) {
            this.totalWriteRequests += OVERFLOW_ADJUSTMENT;
        }
        this.interval = 1L;
    }

    public void add(VolPerfCounterData data) {
        if (this.blockSize != data.blockSize) {
            data.setBlockSizeValid(false);
            data.addErrorCode(PerfErrorCode.VOL_BLOCKSIZE_CHANGED);
        }
        if (this.ref != null && !this.ref.equals(data.ref)) {
            data.setDataValid(false);
            data.addErrorCode(PerfErrorCode.VOLUME_PRIMARY_PATH_CHANGED);
            return;
        }
        if (!data.isDataValid()) {
            this.setDataValid(false);
            this.addErrorCodes(data.getErrorCodes());
            return;
        }
        this.totalBlocksRequested += data.totalBlocksRequested;
        this.totalCacheReadCheckHits += data.totalCacheReadCheckHits;
        this.totalCacheReadChecks += data.totalCacheReadChecks;
        this.totalReadBlocksRequested += data.totalReadBlocksRequested;
        this.totalReadRequests += data.totalReadRequests;
        this.totalRequestsServiced += data.totalRequestsServiced;
        this.totalWriteBlocksRequested += data.totalWriteBlocksRequested;
        this.totalWriteRequests += data.totalWriteRequests;
    }

    public VolPerfCounterData subtract(VolPerfCounterData newer) {
        VolPerfCounterData data = new VolPerfCounterData(newer.time, newer.ref, newer.blockSize);
        data.interval = (newer.time - this.time) / 1000L;
        if (data.interval <= 0L) {
            data.interval = 1L;
        }
        if (this.blockSize != newer.blockSize) {
            data.setBlockSizeValid(false);
            data.addErrorCode(PerfErrorCode.VOL_BLOCKSIZE_CHANGED);
        }
        if (this.ref != null && !this.ref.equals(newer.ref)) {
            data.setDataValid(false);
            data.addErrorCode(PerfErrorCode.VOLUME_PRIMARY_PATH_CHANGED);
        }
        if (!newer.isDataValid()) {
            data.setDataValid(false);
            data.addErrorCodes(newer.getErrorCodes());
        }
        if (!this.isDataValid()) {
            data.setDataValid(false);
            data.addErrorCodes(this.getErrorCodes());
        }
        if (data.isDataValid()) {
            data.totalBlocksRequested = this.subtractWithOverFlowProtection(newer.totalBlocksRequested, this.totalBlocksRequested);
            data.totalCacheReadChecks = this.subtractWithOverFlowProtection(newer.totalCacheReadChecks, this.totalCacheReadChecks);
            data.totalCacheReadCheckHits = this.subtractWithOverFlowProtection(newer.totalCacheReadCheckHits, this.totalCacheReadCheckHits);
            data.totalReadBlocksRequested = this.subtractWithOverFlowProtection(newer.totalReadBlocksRequested, this.totalReadBlocksRequested);
            data.totalReadRequests = this.subtractWithOverFlowProtection(newer.totalReadRequests, this.totalReadRequests);
            data.totalRequestsServiced = this.subtractWithOverFlowProtection(newer.totalRequestsServiced, this.totalRequestsServiced);
            data.totalWriteBlocksRequested = this.subtractWithOverFlowProtection(newer.totalWriteBlocksRequested, this.totalWriteBlocksRequested);
            data.totalWriteRequests = this.subtractWithOverFlowProtection(newer.totalWriteRequests, this.totalWriteRequests);
        }
        return data;
    }

    public boolean isBlockSizeValid() {
        return this.blockSizeValidity;
    }

    public void setBlockSizeValid(boolean validity) {
        this.blockSizeValidity = validity;
    }

    public boolean isDataValid() {
        return this.dataValidity;
    }

    public void setDataValid(boolean dataValidity) {
        this.dataValidity = dataValidity;
    }

    protected long subtractWithOverFlowProtection(long value, long subtractValue) {
        if (value < subtractValue) {
            return MAX_LONG - subtractValue + value;
        }
        return value - subtractValue;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cns) {
            throw new AssertionError((Object)"Assertion failure");
        }
    }
}

