/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ControllerPerfCounterData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ControllerPerfData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfErrorCode;
import java.util.Hashtable;
import java.util.Map;

class StorageArrayPerfData
extends ControllerPerfData {
    public StorageArrayPerfData(String objectName, Map keyMap, Hashtable controllerHashtable) {
        super(objectName, keyMap, controllerHashtable);
    }

    public void setVolumeCreatedAfterStart() {
        super.setVolumeCreatedAfterStart();
        this.addErrorCode(PerfErrorCode.NEW_VOL_FOUND);
    }

    public void setVolumeDeletedAfterStart() {
        super.setVolumeDeletedAfterStart();
        this.addErrorCode(PerfErrorCode.VOLUME_DELETED);
    }

    public void computeRunAverageStats() {
        ControllerPerfData[] controllerPerfData = this.hashtable.values().toArray(new ControllerPerfData[this.hashtable.size()]);
        double runAverageTotalIOPs = 0.0;
        double runAverageReadsPerSec = 0.0;
        double runAverageWritesPerSec = 0.0;
        boolean runAverageStatsAvailable = true;
        for (int i = 0; i < controllerPerfData.length && runAverageStatsAvailable; ++i) {
            if (controllerPerfData[i] == null) {
                runAverageStatsAvailable = false;
                this.addErrorCode(PerfErrorCode.NO_PATH_TO_CONTROLLER);
                continue;
            }
            double value = controllerPerfData[i].getRunAverageTotalIOPs();
            if (value == -1.0) {
                runAverageStatsAvailable = false;
                this.addErrorCodes(controllerPerfData[i].getPerfStatsErrorCodes());
                continue;
            }
            runAverageTotalIOPs += controllerPerfData[i].getRunAverageTotalIOPs().doubleValue();
            runAverageReadsPerSec += controllerPerfData[i].getRunAverageReadsPerSec().doubleValue();
            runAverageWritesPerSec += controllerPerfData[i].getRunAverageWritesPerSec().doubleValue();
        }
        if (runAverageStatsAvailable) {
            this.setRunAverageTotalIOPs(runAverageTotalIOPs);
            this.setRunAverageReadsPerSec(runAverageReadsPerSec);
            this.setRunAverageWritesPerSec(runAverageWritesPerSec);
        } else {
            this.setRunAverageReadsPerSec(-1.0);
            this.setRunAverageWritesPerSec(-1.0);
            this.setRunAverageTotalIOPs(-1.0);
        }
    }

    public void calcPerfStats() {
        ControllerPerfData[] controllerPerfData = this.hashtable.values().toArray(new ControllerPerfData[this.hashtable.size()]);
        this.setPerfData(controllerPerfData);
    }

    public void setPerfData(ControllerPerfData[] controllerPerfData) {
        String METHOD_NAME = "setPerfData";
        ControllerPerfCounterData data = new ControllerPerfCounterData();
        boolean processed = false;
        this.clearAllErrors();
        for (int i = 0; i < controllerPerfData.length && data.isDataValid(); ++i) {
            ControllerPerfCounterData controllerData;
            if (controllerPerfData[i] == null) {
                data.setDataValid(false);
                this.markDataAsNotAvailable();
                data.addErrorCode(PerfErrorCode.NO_PATH_TO_CONTROLLER);
                continue;
            }
            if (controllerPerfData[i].volumeDeletedAfterStart()) {
                this.setVolumeDeletedAfterStart();
            }
            if (controllerPerfData[i].volumeCreatedAfterStart()) {
                this.setVolumeCreatedAfterStart();
            }
            if ((controllerData = controllerPerfData[i].getPerfData()) == null) {
                data.setDataValid(false);
                data.addErrorCode(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION);
                Trace.error((Object)this, "setPerfData", "Got an null ControllerPerfData.getPerfData() object.");
                continue;
            }
            if (!controllerData.isDataValid()) {
                data.setDataValid(false);
                data.addErrorCodes(controllerData.getErrorCodes());
                continue;
            }
            if (data.time < controllerData.time) {
                data.time = controllerData.time;
            }
            data.add(controllerData);
        }
        if (data.isDataValid()) {
            if (this.volumeCreatedAfterStart() || this.volumeDeletedAfterStart()) {
                if (this.volumeCreatedAfterStart()) {
                    data.addErrorCode(PerfErrorCode.NEW_VOL_FOUND);
                }
                if (this.volumeDeletedAfterStart()) {
                    data.addErrorCode(PerfErrorCode.VOLUME_DELETED);
                }
                this.setRunAverageReadsPerSec(-1.0);
                this.setRunAverageTotalIOPs(-1.0);
                this.setRunAverageWritesPerSec(-1.0);
            } else {
                this.setRunAverageReadsPerSec(-2.0);
                this.setRunAverageTotalIOPs(-2.0);
                this.setRunAverageWritesPerSec(-2.0);
            }
            this.setRunAverageReadsPerSec(-2.0);
            this.setRunAverageTotalIOPs(-2.0);
            this.setRunAverageWritesPerSec(-2.0);
            this.setCacheReadHitPercentage(-2.0);
            this.setReadPercentage(-2.0);
            this.setWritePercentage(-2.0);
            this.setTotalIOPs(data.totalIOPs);
            if (data.isBlockSizeValid()) {
                this.setAverageReadSize(data.totalAverageReadSize);
                this.setAverageWriteSize(data.totalAverageWriteSize);
                this.setReadsPerSec(data.totalBytesReadPerSec);
                this.setWritesPerSec(data.totalBytesWrittenPerSec);
            } else {
                this.markInvalidDueToBlockSize();
            }
        } else {
            this.markDataAsNotAvailable();
        }
        this.currentPerfData = data;
        this.addErrorCodes(data.getErrorCodes());
    }
}

