/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolData;
import devmgr.versioned.jrpc.RPCError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PoolDataManager {
    public static final String DEFAULT_POOL_FILE_NAME = "poolData.xml";
    public static final String DEFAULT_DATA_DIR_NAME = "/opt/SUNWse6130ui/resources";
    public static final String DEFAULT_POOLS_FILE_PROP = "factory-defined-pools";
    private static final String XML_DATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String TAG_TOP_LEVEL = "pool_data";
    private static final String TAG_POOL = "pool";
    private static final String TAG_VOLUME = "volume";
    private static final String ATT_KEY = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_DESC = "description";
    private static final String ATT_PROFILE_ID = "profile_id";
    private static final String ATT_PROFILE_NAME = "profile_name";
    private static final String ENCODING_SCHEME = "UTF-8";
    private ObjectBundleManager _obm = null;
    private String _arrayId = null;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager;

    public PoolDataManager(String arrayId) throws ConfigMgmtException {
        this._arrayId = arrayId;
        this._obm = ObjectBundleManager.getInstance();
    }

    public Map getRawPoolMap() throws ConfigMgmtException {
        Map pools;
        block5: {
            pools = new HashMap();
            try {
                pools = (Map)this._obm.getPoolData(this._arrayId);
                if (pools != null && pools.isEmpty()) {
                    try {
                        Collection rawData = PoolDataManager.getDefaultPoolsForArray(this._arrayId);
                        this.saveData(rawData);
                        String poolString = (String)PoolDataManager.preprocessPoolsToStore(rawData);
                        pools = (Map)PoolDataManager.preprocessStoredPools(poolString);
                    }
                    catch (Exception e) {
                        Trace.error((Object)this, "getRawPoolMap", "Could not re-initialize pools. Returning an empty collection.");
                        Trace.error((Object)this, "getRawPoolMap", e.toString());
                    }
                }
            }
            catch (ConfigMgmtException cme) {
                if ("error.reason.100218".equals(cme.getExceptionKey()) || "error.reason.100029".equals(cme.getExceptionKey()) || "error.reason.100030".equals(cme.getExceptionKey())) break block5;
                throw cme;
            }
        }
        return pools;
    }

    public Collection getRawPools() throws ConfigMgmtException {
        HashMap m = this.getRawPoolMap();
        if (m == null) {
            m = new HashMap();
        }
        return m.values();
    }

    public PoolData getPoolData(String poolId) throws ConfigMgmtException {
        Map poolMap = this.getRawPoolMap();
        return (PoolData)poolMap.get(poolId);
    }

    public void updatePool(PoolData pd) throws ConfigMgmtException, IOException, RPCError {
        Map poolMap = this.getRawPoolMap();
        poolMap.put(pd.poolId, pd);
        this.saveData(poolMap.values());
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
        String METHOD = "validateName";
        Trace.methodBegin(this, "validateName");
        if (name != null) {
            if (name.length() > 32) {
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "validateName", "Name: " + name + " is too long.");
                throw new BadParameterException(name, "error.bizobj.nameTooLong");
            }
            if (!this.nameIsUnique(name)) {
                Trace.error((Object)this, "validateName", "Name: " + name + " already exists.");
                throw new BadParameterException(name, "error.objectAlreadyExists");
            }
            if (name.trim().length() == 0) {
                Trace.error((Object)this, "validateName", "Empty pool names are not allowed.");
                throw new BadParameterException("", "error.bizobj.noName");
            }
        } else {
            Trace.error((Object)this, "validateName", "Name is null.");
            throw new BadParameterException(name, "error.bizobj.noName");
        }
    }

    public boolean nameIsUnique(String newName) throws ConfigMgmtException {
        String METHOD = "nameIsUnqiue";
        boolean result = true;
        if (newName == null) {
            return false;
        }
        Collection poolData = this.getRawPools();
        if (poolData == null) {
            Trace.verbose((Object)this, "nameIsUnqiue", "No existing Pools, so true.");
            return true;
        }
        Iterator it = poolData.iterator();
        while (it.hasNext()) {
            PoolData pd = (PoolData)it.next();
            if (!pd.poolName.equals(newName)) continue;
            Trace.verbose((Object)this, "nameIsUnqiue", "Found duplicate name: " + newName);
            result = false;
        }
        return result;
    }

    public void validateDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "validateDescription");
        if (description != null && description.length() > 256) {
            Trace.error((Object)this, "validateDescription", "Description: " + description + " is too long.");
            throw new BadParameterException(description, "error.bizobj.descriptionTooLong");
        }
    }

    private static Document getFactoryPoolDocument(String arrayId) throws ConfigMgmtException {
        String methodName = "getFactoryPoolDocument";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "getFactoryPoolDocument");
        String fileName = null;
        fileName = Repository.getRepository().getProperty(DEFAULT_POOLS_FILE_PROP) != null ? (String)Repository.getRepository().getProperty(DEFAULT_POOLS_FILE_PROP) : "/opt/SUNWse6130ui/resources/poolData.xml";
        StringBuffer buf = new StringBuffer();
        Document preDoc = null;
        try {
            File file = null;
            FileReader fr = null;
            try {
                file = new File(fileName);
                fr = new FileReader(file);
            }
            catch (FileNotFoundException fnf) {
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "getFactoryPoolDocument", "File not found:" + fileName);
                String defaultFile = "/opt/SUNWse6130ui/resources/poolData.xml";
                if (!defaultFile.equals(fileName)) {
                    Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "getFactoryPoolDocument", "Attempt reading default location:" + defaultFile);
                    file = new File(fileName);
                    fr = new FileReader(file);
                }
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
            }
            BufferedReader dis = new BufferedReader(fr);
            String line = null;
            while ((line = dis.readLine()) != null) {
                buf.append(line).append("\n");
            }
            preDoc = PoolDataManager.getDocFromXMLString(buf.toString());
        }
        catch (FileNotFoundException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryPoolDocument", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        catch (IOException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryPoolDocument", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_IO_KEY, fileName);
        }
        catch (FactoryConfigurationError e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryPoolDocument", e.getMessage());
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        catch (ParserConfigurationException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryPoolDocument", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        catch (SAXException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryPoolDocument", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        return preDoc;
    }

    private static Document getDocFromXMLString(String buf) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        Document preDoc = null;
        if (buf != null) {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            preDoc = builder.parse(new InputSource(new StringReader(buf.toString())));
        }
        return preDoc;
    }

    public static Collection getDefaultPoolsForArray(String arrayId) throws ConfigMgmtException {
        Collection<Object> pools = new ArrayList();
        Document document = PoolDataManager.getFactoryPoolDocument(arrayId);
        pools = PoolDataManager.getPoolsFromXMLDoc(document).values();
        return pools;
    }

    private static Map getPoolsFromXMLDoc(Document document) throws ConfigMgmtException {
        NodeList poolNodes;
        HashMap<String, PoolData> pools = new HashMap<String, PoolData>();
        Element root = document.getDocumentElement();
        NodeList pl = root.getElementsByTagName(TAG_TOP_LEVEL);
        Element poolsRoot = (Element)pl.item(0);
        if (poolsRoot == null) {
            poolsRoot = root;
        }
        int size = (poolNodes = root.getElementsByTagName(TAG_POOL)) == null ? 0 : poolNodes.getLength();
        for (int i = 0; i < size; ++i) {
            Element poolEl = (Element)poolNodes.item(i);
            PoolData p = new PoolData();
            try {
                p.poolName = URLDecoder.decode(poolEl.getAttribute(ATT_NAME), ENCODING_SCHEME);
                String elem = poolEl.getAttribute(ATT_DESC) == null ? "-" : poolEl.getAttribute(ATT_DESC);
                p.poolDesc = URLDecoder.decode(elem, ENCODING_SCHEME);
                p.profileId = URLDecoder.decode(poolEl.getAttribute(ATT_PROFILE_ID), ENCODING_SCHEME);
                if (poolEl.getAttribute(ATT_KEY) != null && !poolEl.getAttribute(ATT_KEY).trim().equals("")) {
                    p.poolId = URLDecoder.decode(poolEl.getAttribute(ATT_KEY), ENCODING_SCHEME);
                }
                pools.put(p.poolId, p);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "preprocessPoolsToStore", (Throwable)e);
                throw new ConfigMgmtException(e);
            }
        }
        return pools;
    }

    public static Object preprocessStoredPools(Object storedData) throws ConfigMgmtException {
        String methodName = "preprocessStoredPools";
        Map poolMap = new HashMap();
        String xml = (String)storedData;
        try {
            Document preDoc = PoolDataManager.getDocFromXMLString(xml);
            poolMap = PoolDataManager.getPoolsFromXMLDoc(preDoc);
        }
        catch (FactoryConfigurationError e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "preprocessStoredPools", (Throwable)e.getException());
            throw new ConfigMgmtException(e.getException());
        }
        catch (ParserConfigurationException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "preprocessStoredPools", (Throwable)e);
            throw new ConfigMgmtException(e);
        }
        catch (SAXException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "preprocessStoredPools", (Throwable)e);
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "preprocessStoredPools", "Dumping content of stored pools in DAC store:");
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "preprocessStoredPools", "\n" + xml);
            throw new ConfigMgmtException(e);
        }
        catch (IOException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "preprocessStoredPools", (Throwable)e);
            throw new ConfigMgmtException(e);
        }
        return poolMap;
    }

    public static Object preprocessPoolsToStore(Object poolsData) throws ConfigMgmtException {
        Collection list = null;
        if (poolsData instanceof Collection) {
            list = (Collection)poolsData;
        } else {
            if (poolsData == null) {
                return "";
            }
            list = ((Map)poolsData).values();
        }
        StringBuffer sb = new StringBuffer("<");
        sb.append(TAG_TOP_LEVEL).append(">\n");
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                PoolData p = (PoolData)it.next();
                String encName = null;
                String encDesc = null;
                String encProf = null;
                String encId = null;
                try {
                    encName = URLEncoder.encode(p.poolName, ENCODING_SCHEME);
                    if (p.poolDesc != null) {
                        encDesc = URLEncoder.encode(p.poolDesc, ENCODING_SCHEME);
                    }
                    encProf = URLEncoder.encode(p.profileId, ENCODING_SCHEME);
                    encId = URLEncoder.encode(p.poolId, ENCODING_SCHEME);
                }
                catch (UnsupportedEncodingException e) {
                    Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager = PoolDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$PoolDataManager, "preprocessPoolsToStore", (Throwable)e);
                    throw new ConfigMgmtException(e);
                }
                sb.append("  <").append(TAG_POOL).append(" ").append(ATT_KEY).append("=\"").append(encId).append("\" ").append(ATT_NAME).append("=\"").append(encName).append("\" ").append(ATT_DESC).append("=\"").append(encDesc).append("\" ").append(ATT_PROFILE_ID).append("=\"").append(encProf).append("\">\n");
                sb.append("  </pool>\n");
            }
        }
        sb.append("</pool_data>\n");
        return sb.toString();
    }

    public void saveData(Collection data) throws RPCError, IOException, ConfigMgmtException {
        if (data == null) {
            return;
        }
        this._obm.stopMonitoringThread(this._arrayId);
        this._obm.setPoolData(this._arrayId, data);
        this._obm.forceBundleReload(this._arrayId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

