/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager;
import devmgr.versioned.jrpc.RPCError;
import java.io.IOException;
import java.util.Map;
import java.util.Random;

public class PoolCreationSingleton {
    private Random rnd = new Random();
    private static PoolCreationSingleton _instance;

    private PoolCreationSingleton() {
    }

    public static synchronized PoolCreationSingleton getInstance() {
        if (_instance == null) {
            _instance = new PoolCreationSingleton();
        }
        return _instance;
    }

    public synchronized void createPool(String arrayId, PoolData pd) throws ConfigMgmtException {
        String METHOD = "createPool";
        PoolDataManager pdm = new PoolDataManager(arrayId);
        pdm.validateName(pd.poolName);
        pdm.validateDescription(pd.poolDesc);
        pd.poolId = "" + this.generateNextId(pdm.getRawPoolMap());
        try {
            pdm.updatePool(pd);
        }
        catch (RPCError e) {
            Trace.error((Object)this, "createPool", e.getMessage());
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_IO_KEY, e.getMessage());
        }
        catch (IOException e) {
            Trace.error((Object)this, "createPool", e.getMessage());
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_IO_KEY, e.getMessage());
        }
    }

    private synchronized int generateNextId(Map map) {
        int nextId = 0;
        while (nextId == 0) {
            nextId = this.rnd.nextInt();
            if (!map.containsKey("" + nextId)) continue;
            nextId = 0;
        }
        return nextId;
    }
}

