/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolCapacityHelper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import devmgr.versioned.symbol.Volume;
import java.io.Serializable;
import java.math.BigInteger;

public class Pool
extends com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.common.Pool
implements Serializable {
    private ConfigContext context;
    private String arrayId;
    private Profile profile;
    private String poolId;
    private String profileKeyAsString = null;
    private BigInteger maximumVolumeSize;
    private String profileId = null;

    public String getPoolId() {
        return this.poolId;
    }

    public void setPoolId(String poolId) {
        this.poolId = poolId;
    }

    public String getArrayId() {
        return this.arrayId;
    }

    public void setArrayId(String arrayId) {
        this.arrayId = arrayId;
    }

    public ConfigContext getContext() {
        return this.context;
    }

    public void setContext(ConfigContext context) {
        this.context = context;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public String getArrayScopeAsString() {
        return (String)this.getKey().get("array");
    }

    public String getProfileKeyAsString() {
        return "id" + Convert.KEY_NAME_VAL_SEPARATOR + this.profileId + Convert.KEY_SEPARATOR;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public BigInteger getMaximumVolumeSize() {
        if (this.maximumVolumeSize == null) {
            this.fillCapacities();
        }
        return this.maximumVolumeSize;
    }

    public void setMaximumVolumeSize(BigInteger maximumVolumeSize) {
        this.maximumVolumeSize = maximumVolumeSize;
    }

    public BigInteger getConfiguredCapacity() {
        if (this.configuredCapacity == null) {
            this.fillCapacities();
        }
        return this.configuredCapacity;
    }

    public BigInteger getAvailableCapacity() {
        if (this.availableCapacity == null) {
            this.fillCapacities();
        }
        return this.availableCapacity;
    }

    public BigInteger getTotalCapacity() {
        if (this.configuredCapacity == null || this.availableCapacity == null) {
            this.fillCapacities();
        }
        return this.getAvailableCapacity().add(this.getConfiguredCapacity());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Pool:\n");
        buf.append("Name:").append(this.getName()).append("\n");
        buf.append("Profile Id:").append(this.profileId).append("\n");
        buf.append("Profile name:").append(this.profileName).append("\n");
        buf.append("String key").append(this.getKeyAsString()).append("\n");
        return buf.toString();
    }

    private void fillCapacities() {
        String methodName = "fillCapacities";
        Trace.methodBegin(this, "fillCapacities");
        try {
            PoolCapacityHelper poolCaps = new PoolCapacityHelper(this.context, this.arrayId);
            PoolCapacityHelper.PoolCapacityData data = poolCaps.getCapacities(this.profile);
            this.maximumVolumeSize = data.getMaximumVolumeSize();
            this.availableCapacity = data.getAvailableCapacity();
            BigInteger cap = BigInteger.ZERO;
            Volume[] ozVols = ObjectBundleManager.getInstance().getObjectBundle(this.arrayId).getVolume();
            for (int i = 0; i < ozVols.length; ++i) {
                if (this.poolId == null || !this.poolId.equals("" + ozVols[i].getMgmtClientAttribute())) continue;
                cap = cap.add(BigInteger.valueOf(ozVols[i].getCapacity()));
            }
            this.configuredCapacity = cap;
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "fillCapacities", e);
        }
    }
}

